/*******************************************************************************
 * Size: 18 px
 * Bpp: 4
 * Opts: --bpp 4 --size 18 --no-compress --stride 1 --align 1 --font FRADM.TTF --range 32-127,176,8226,1040-1103,1105 --format lvgl -o Franklin_18_rus.c
 ******************************************************************************/

#ifdef __has_include
    #if __has_include("lvgl.h")
        #ifndef LV_LVGL_H_INCLUDE_SIMPLE
            #define LV_LVGL_H_INCLUDE_SIMPLE
        #endif
    #endif
#endif

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
    #include "lvgl.h"
#else
    #include "lvgl/lvgl.h"
#endif



#ifndef FRANKLIN_18_RUS
#define FRANKLIN_18_RUS 1
#endif

#if FRANKLIN_18_RUS

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0xf, 0xff, 0x40, 0xef, 0xf2, 0xc, 0xff, 0x10,
    0xaf, 0xf0, 0x9, 0xfd, 0x0, 0x7f, 0xc0, 0x5,
    0xfa, 0x0, 0x4f, 0x80, 0x1, 0x52, 0x0, 0x8c,
    0xc0, 0xb, 0xff, 0x0, 0xbf, 0xf0,

    /* U+0022 "\"" */
    0x4f, 0xc1, 0xff, 0x3f, 0xb0, 0xfe, 0x2f, 0xa0,
    0xfd, 0x1f, 0x90, 0xec, 0xf, 0x70, 0xda,

    /* U+0023 "#" */
    0x0, 0x1, 0xfa, 0xf, 0xc0, 0x0, 0x5, 0xf6,
    0x2f, 0x90, 0x0, 0x8, 0xf3, 0x6f, 0x60, 0x9,
    0xff, 0xff, 0xff, 0xfd, 0x8, 0xbf, 0xfb, 0xff,
    0xb8, 0x0, 0xf, 0xb0, 0xed, 0x0, 0x1b, 0xcf,
    0xeb, 0xfe, 0xb4, 0x4f, 0xff, 0xff, 0xff, 0xf3,
    0x0, 0x8f, 0x36, 0xf5, 0x0, 0x0, 0xbf, 0x9,
    0xf2, 0x0, 0x0, 0xed, 0xc, 0xf0, 0x0, 0x0,
    0xfb, 0xe, 0xd0, 0x0,

    /* U+0024 "$" */
    0x0, 0x0, 0x44, 0x0, 0x0, 0x0, 0x0, 0xbb,
    0x0, 0x0, 0x0, 0x4c, 0xff, 0xd7, 0x0, 0x5,
    0xff, 0xff, 0xff, 0x90, 0xd, 0xfc, 0x10, 0x8f,
    0xd0, 0xf, 0xfc, 0x0, 0x2, 0x0, 0xc, 0xff,
    0xfc, 0x83, 0x0, 0x4, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x18, 0xcf, 0xff, 0xf4, 0x0, 0x20, 0x0,
    0x8f, 0xf8, 0x5f, 0xf4, 0x0, 0x4f, 0xf6, 0x1e,
    0xff, 0xcb, 0xff, 0xe0, 0x3, 0xdf, 0xff, 0xfd,
    0x20, 0x0, 0x2, 0xcc, 0x20, 0x0, 0x0, 0x0,
    0xbb, 0x0, 0x0,

    /* U+0025 "%" */
    0x6, 0xee, 0x60, 0x0, 0x7d, 0x0, 0x2f, 0x67,
    0xf2, 0x1, 0xe5, 0x0, 0x6f, 0x22, 0xf6, 0x8,
    0xc0, 0x0, 0x6f, 0x22, 0xf6, 0x2f, 0x30, 0x0,
    0x3f, 0x55, 0xf2, 0xaa, 0x0, 0x0, 0x8, 0xff,
    0x83, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xc, 0x91,
    0xbe, 0xa0, 0x0, 0x0, 0x5e, 0x1b, 0xc3, 0xe8,
    0x0, 0x0, 0xd7, 0xf, 0x80, 0xbd, 0x0, 0x6,
    0xd0, 0xf, 0x80, 0xbd, 0x0, 0xe, 0x50, 0xc,
    0xc1, 0xe9, 0x0, 0x8c, 0x0, 0x2, 0xcf, 0xb1,

    /* U+0026 "&" */
    0x0, 0x4, 0xbe, 0xfc, 0x40, 0x0, 0x0, 0x3,
    0xff, 0xfe, 0xff, 0x30, 0x0, 0x0, 0x8f, 0xf1,
    0xb, 0xf8, 0x0, 0x0, 0x7, 0xff, 0x60, 0xbf,
    0x80, 0x0, 0x0, 0x1e, 0xff, 0xcf, 0xe2, 0x0,
    0x0, 0x7, 0xef, 0xff, 0xc2, 0xb, 0x94, 0xb,
    0xff, 0xbf, 0xfe, 0x25, 0xff, 0x54, 0xff, 0xb0,
    0x4f, 0xfe, 0xef, 0xd0, 0x7f, 0xf9, 0x0, 0x5f,
    0xff, 0xf3, 0x4, 0xff, 0xf6, 0x46, 0xef, 0xfe,
    0x52, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x7, 0xdf, 0xfd, 0x81, 0x6d, 0xf8,

    /* U+0027 "'" */
    0x4f, 0xc3, 0xfb, 0x2f, 0xa1, 0xf9, 0xf, 0x70,

    /* U+0028 "(" */
    0x0, 0x5f, 0x90, 0x1e, 0xf1, 0x7, 0xfb, 0x0,
    0xef, 0x50, 0x3f, 0xf2, 0x6, 0xff, 0x0, 0x8f,
    0xd0, 0x9, 0xfd, 0x0, 0x8f, 0xd0, 0x6, 0xfe,
    0x0, 0x3f, 0xf1, 0x0, 0xef, 0x50, 0x7, 0xfa,
    0x0, 0x1e, 0xf1, 0x0, 0x6f, 0x80,

    /* U+0029 ")" */
    0x4f, 0xa0, 0x0, 0xcf, 0x40, 0x6, 0xfc, 0x0,
    0x1f, 0xf2, 0x0, 0xdf, 0x70, 0xa, 0xfb, 0x0,
    0x9f, 0xc0, 0x8, 0xfd, 0x0, 0x9f, 0xc0, 0xa,
    0xfb, 0x0, 0xdf, 0x70, 0x1f, 0xf3, 0x6, 0xfc,
    0x0, 0xcf, 0x40, 0x5f, 0xa0, 0x0,

    /* U+002A "*" */
    0x0, 0xc, 0xf4, 0x0, 0x0, 0x20, 0xaf, 0x20,
    0x30, 0x5f, 0xbc, 0xf9, 0xee, 0x6, 0xdf, 0xff,
    0xfe, 0xb1, 0x0, 0x7f, 0xfe, 0x10, 0x0, 0x5f,
    0xe8, 0xfc, 0x0, 0x5, 0xf6, 0xd, 0xb1, 0x0,
    0x1, 0x0, 0x10, 0x0,

    /* U+002B "+" */
    0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x30, 0x0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x0,
    0x0, 0xaf, 0x30, 0x0, 0x2e, 0xee, 0xff, 0xee,
    0xea, 0x2f, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0xaf, 0x30, 0x0, 0x0, 0x0, 0xaf, 0x30, 0x0,
    0x0, 0x0, 0xaf, 0x30, 0x0, 0x0, 0x0, 0xaf,
    0x30, 0x0,

    /* U+002C "," */
    0xb, 0xb7, 0xf, 0xfa, 0xf, 0xfa, 0x0, 0xe4,
    0x5, 0xb0, 0xd, 0x30,

    /* U+002D "-" */
    0xbe, 0xee, 0x5c, 0xff, 0xf6,

    /* U+002E "." */
    0xb, 0xb7, 0xf, 0xfa, 0xf, 0xfa,

    /* U+002F "/" */
    0x0, 0x0, 0x0, 0x0, 0xd, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x40, 0x0, 0x0, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x90, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x10, 0x0, 0x0, 0x0, 0x5, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x50, 0x0, 0x0, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x90, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x10, 0x0, 0x0, 0x0, 0x5, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xd0, 0x0, 0x0,
    0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x1a, 0xef, 0xd6, 0x0, 0x1, 0xef, 0xff,
    0xff, 0x80, 0xa, 0xff, 0x41, 0xaf, 0xf3, 0x1f,
    0xfb, 0x0, 0x2f, 0xf9, 0x4f, 0xf9, 0x0, 0xf,
    0xfd, 0x6f, 0xf8, 0x0, 0xf, 0xfe, 0x6f, 0xf8,
    0x0, 0xf, 0xfe, 0x4f, 0xf9, 0x0, 0xf, 0xfd,
    0x1f, 0xfc, 0x0, 0x2f, 0xf9, 0xa, 0xff, 0x62,
    0xbf, 0xf3, 0x1, 0xef, 0xff, 0xff, 0x80, 0x0,
    0x1a, 0xef, 0xd6, 0x0,

    /* U+0031 "1" */
    0x0, 0x0, 0x4f, 0xf3, 0x0, 0x0, 0x1, 0x9f,
    0xff, 0x30, 0x0, 0xa, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0xef, 0x9a, 0xff, 0x30, 0x0, 0x8, 0x20,
    0x9f, 0xf3, 0x0, 0x0, 0x0, 0x9, 0xff, 0x30,
    0x0, 0x0, 0x0, 0x9f, 0xf3, 0x0, 0x0, 0x0,
    0x9, 0xff, 0x30, 0x0, 0x0, 0x0, 0x9f, 0xf3,
    0x0, 0x0, 0x33, 0x3a, 0xff, 0x53, 0x31, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0x83, 0xff, 0xff, 0xff,
    0xff, 0xf8,

    /* U+0032 "2" */
    0x0, 0x3b, 0xef, 0xd8, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xc0, 0xe, 0xfe, 0x54, 0xdf, 0xf5, 0x4f,
    0xf4, 0x0, 0x5f, 0xf9, 0x1, 0x50, 0x0, 0x7f,
    0xf8, 0x0, 0x0, 0x2, 0xff, 0xf2, 0x0, 0x0,
    0x3e, 0xff, 0x60, 0x0, 0x6, 0xff, 0xf5, 0x0,
    0x1, 0xbf, 0xfb, 0x10, 0x0, 0x3e, 0xff, 0xb6,
    0x66, 0x64, 0x6f, 0xff, 0xff, 0xff, 0xfb, 0x6f,
    0xff, 0xff, 0xff, 0xf9,

    /* U+0033 "3" */
    0x0, 0x4b, 0xef, 0xc6, 0x0, 0x6, 0xff, 0xff,
    0xff, 0xc0, 0x1f, 0xfc, 0x22, 0xcf, 0xf3, 0x15,
    0x72, 0x0, 0x6f, 0xf4, 0x0, 0x0, 0x13, 0xcf,
    0xf1, 0x0, 0x8, 0xff, 0xfd, 0x30, 0x0, 0x8,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x1, 0x8f, 0xf7,
    0x5a, 0xc0, 0x0, 0x3f, 0xfa, 0x5f, 0xfb, 0x33,
    0xbf, 0xf8, 0xa, 0xff, 0xff, 0xff, 0xe1, 0x0,
    0x6c, 0xef, 0xd8, 0x10,

    /* U+0034 "4" */
    0x0, 0x0, 0x2f, 0xff, 0x70, 0x0, 0x0, 0xc,
    0xff, 0xf7, 0x0, 0x0, 0x7, 0xfb, 0xff, 0x70,
    0x0, 0x3, 0xfd, 0x3f, 0xf7, 0x0, 0x0, 0xdf,
    0x33, 0xff, 0x70, 0x0, 0x8f, 0x80, 0x3f, 0xf7,
    0x0, 0x4f, 0xd0, 0x3, 0xff, 0x70, 0x9, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0x20, 0x11, 0x11, 0x6f, 0xf8, 0x10, 0x0,
    0x0, 0x5, 0xff, 0x70, 0x0, 0x0, 0x0, 0x5f,
    0xf7, 0x0,

    /* U+0035 "5" */
    0x3, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x5f, 0xff,
    0xff, 0xff, 0x20, 0x6, 0xfe, 0x77, 0x77, 0x70,
    0x0, 0x7f, 0xb0, 0x0, 0x0, 0x0, 0x8, 0xfb,
    0x9e, 0xfc, 0x40, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0x40, 0x7, 0xef, 0x63, 0x9f, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xf0, 0x18, 0xa5, 0x0, 0xe,
    0xff, 0x0, 0xef, 0xe6, 0x4a, 0xff, 0xb0, 0x5,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0x3, 0xbe, 0xfe,
    0xa2, 0x0,

    /* U+0036 "6" */
    0x0, 0x8, 0xdf, 0xea, 0x20, 0x0, 0xcf, 0xff,
    0xff, 0xe2, 0x7, 0xff, 0x60, 0x4f, 0xf9, 0xe,
    0xfc, 0x0, 0x4, 0x30, 0x2f, 0xf9, 0x7d, 0xeb,
    0x20, 0x4f, 0xfe, 0xff, 0xff, 0xf2, 0x4f, 0xff,
    0x50, 0x7f, 0xfb, 0x2f, 0xfb, 0x0, 0xd, 0xff,
    0xf, 0xfb, 0x0, 0xd, 0xfe, 0x8, 0xff, 0x50,
    0x7f, 0xf9, 0x0, 0xcf, 0xff, 0xff, 0xe1, 0x0,
    0x8, 0xdf, 0xea, 0x10,

    /* U+0037 "7" */
    0xcf, 0xff, 0xff, 0xff, 0xae, 0xff, 0xff, 0xff,
    0xfa, 0x77, 0x77, 0x78, 0xff, 0x50, 0x0, 0x0,
    0xbf, 0x90, 0x0, 0x0, 0x8f, 0xf1, 0x0, 0x0,
    0x2f, 0xf8, 0x0, 0x0, 0xa, 0xff, 0x10, 0x0,
    0x1, 0xff, 0xc0, 0x0, 0x0, 0x6f, 0xf8, 0x0,
    0x0, 0xb, 0xff, 0x50, 0x0, 0x0, 0xdf, 0xf4,
    0x0, 0x0, 0xe, 0xff, 0x30, 0x0,

    /* U+0038 "8" */
    0x0, 0x4b, 0xef, 0xd9, 0x10, 0x0, 0x5f, 0xfe,
    0xdf, 0xfe, 0x20, 0xe, 0xfc, 0x0, 0x3f, 0xf8,
    0x0, 0xff, 0xb0, 0x0, 0xdf, 0x80, 0xd, 0xff,
    0xb4, 0x6f, 0xf2, 0x0, 0x3e, 0xff, 0xff, 0xf4,
    0x0, 0x4, 0xdf, 0xef, 0xff, 0xf4, 0x2, 0xff,
    0x70, 0x2a, 0xff, 0xd0, 0x7f, 0xf1, 0x0, 0xc,
    0xff, 0x5, 0xff, 0x80, 0x2, 0xef, 0xd0, 0xc,
    0xff, 0xff, 0xff, 0xf3, 0x0, 0x8, 0xdf, 0xfe,
    0xa2, 0x0,

    /* U+0039 "9" */
    0x0, 0x6c, 0xff, 0xc5, 0x0, 0x9, 0xff, 0xff,
    0xff, 0x70, 0x2f, 0xfc, 0x10, 0xaf, 0xf1, 0x5f,
    0xf5, 0x0, 0x2f, 0xf7, 0x3f, 0xfc, 0x11, 0xaf,
    0xfa, 0xc, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x8e,
    0xfd, 0x4f, 0xfc, 0x0, 0x0, 0x0, 0x1f, 0xfa,
    0x1, 0x43, 0x0, 0x4f, 0xf6, 0xd, 0xfd, 0x33,
    0xdf, 0xe0, 0x5, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x5c, 0xff, 0xb3, 0x0,

    /* U+003A ":" */
    0xf, 0xfa, 0xf, 0xfa, 0xa, 0xa6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xb7, 0xf, 0xfa,
    0xf, 0xfa,

    /* U+003B ";" */
    0xf, 0xfa, 0xf, 0xfa, 0xa, 0xa6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xb7, 0xf, 0xfa,
    0xf, 0xfa, 0x0, 0xe4, 0x5, 0xb0, 0xd, 0x30,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x3b, 0x0, 0x0, 0x3b, 0xff,
    0x0, 0x3b, 0xff, 0xfb, 0x2a, 0xff, 0xfb, 0x30,
    0xcf, 0xfb, 0x30, 0x0, 0xcf, 0xfa, 0x20, 0x0,
    0x3b, 0xff, 0xfa, 0x20, 0x0, 0x3b, 0xff, 0xf9,
    0x0, 0x0, 0x4c, 0xff, 0x0, 0x0, 0x0, 0x4c,
    0x0, 0x0, 0x0, 0x0,

    /* U+003D "=" */
    0x2f, 0xff, 0xff, 0xff, 0xfb, 0x2e, 0xee, 0xee,
    0xee, 0xea, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0xee, 0xee, 0xee, 0xea, 0x2f, 0xff, 0xff, 0xff,
    0xfb,

    /* U+003E ">" */
    0x68, 0x10, 0x0, 0x0, 0x7, 0xff, 0x70, 0x0,
    0x0, 0x3d, 0xff, 0xe7, 0x0, 0x0, 0x6, 0xdf,
    0xfe, 0x70, 0x0, 0x0, 0x6e, 0xff, 0x50, 0x0,
    0x5, 0xdf, 0xf5, 0x0, 0x5d, 0xff, 0xf8, 0x3,
    0xdf, 0xff, 0x81, 0x0, 0x7f, 0xf8, 0x10, 0x0,
    0x6, 0x91, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+003F "?" */
    0x0, 0x7d, 0xfd, 0x81, 0x0, 0xbf, 0xff, 0xff,
    0xd1, 0x5f, 0xf7, 0x3a, 0xff, 0x8a, 0xfd, 0x0,
    0x3f, 0xfa, 0x2, 0x20, 0x9, 0xff, 0x70, 0x0,
    0xa, 0xff, 0xd1, 0x0, 0x8, 0xff, 0xb1, 0x0,
    0x0, 0xbf, 0xb0, 0x0, 0x0, 0x7, 0x95, 0x0,
    0x0, 0x0, 0x8a, 0x90, 0x0, 0x0, 0xd, 0xff,
    0x0, 0x0, 0x0, 0xdf, 0xf0, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0x7c, 0xff, 0xea, 0x30, 0x0, 0x0,
    0x3e, 0xfc, 0x87, 0x9e, 0xf8, 0x0, 0x2, 0xfe,
    0x40, 0x0, 0x0, 0x9f, 0x70, 0xb, 0xf3, 0x9,
    0xed, 0xdf, 0xb, 0xf0, 0x1f, 0xb0, 0x8f, 0xdd,
    0xfd, 0x6, 0xf3, 0x4f, 0x80, 0xee, 0x0, 0xeb,
    0x6, 0xf3, 0x3f, 0x80, 0xed, 0x0, 0xf9, 0xb,
    0xf0, 0x1f, 0xb0, 0xaf, 0x9c, 0xfc, 0xbf, 0x70,
    0xb, 0xf4, 0x1b, 0xfb, 0x8f, 0xe6, 0x0, 0x2,
    0xee, 0x40, 0x0, 0x0, 0x42, 0x0, 0x0, 0x3e,
    0xfc, 0x98, 0x9d, 0xf9, 0x0, 0x0, 0x0, 0x7c,
    0xef, 0xeb, 0x71, 0x0,

    /* U+0041 "A" */
    0x0, 0x5, 0xff, 0xf4, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0x90, 0x0, 0x0, 0xe, 0xff, 0xfe, 0x0,
    0x0, 0x4, 0xff, 0xbf, 0xf3, 0x0, 0x0, 0x9f,
    0xa5, 0xff, 0x80, 0x0, 0xe, 0xf5, 0xf, 0xfd,
    0x0, 0x3, 0xff, 0x10, 0xbf, 0xf2, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0x70, 0xe, 0xff, 0xff, 0xff,
    0xfc, 0x3, 0xff, 0x43, 0x33, 0xdf, 0xf1, 0x8f,
    0xd0, 0x0, 0x8, 0xff, 0x6d, 0xf9, 0x0, 0x0,
    0x4f, 0xfb,

    /* U+0042 "B" */
    0xcf, 0xff, 0xff, 0xfc, 0x50, 0xc, 0xff, 0xff,
    0xff, 0xff, 0x40, 0xcf, 0xf1, 0x12, 0x9f, 0xfb,
    0xc, 0xff, 0x0, 0x2, 0xff, 0xb0, 0xcf, 0xf2,
    0x22, 0x9f, 0xf6, 0xc, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0xc, 0xff,
    0x0, 0x5, 0xff, 0xc0, 0xcf, 0xf0, 0x0, 0xd,
    0xff, 0x1c, 0xff, 0x33, 0x38, 0xff, 0xf0, 0xcf,
    0xff, 0xff, 0xff, 0xf8, 0xc, 0xff, 0xff, 0xff,
    0xc6, 0x0,

    /* U+0043 "C" */
    0x0, 0x6, 0xcf, 0xfd, 0x70, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xa0, 0x7, 0xff, 0xe6, 0x6e, 0xff,
    0x40, 0xef, 0xf3, 0x0, 0x4f, 0xfa, 0x3f, 0xfe,
    0x0, 0x1, 0x99, 0x75, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x5f, 0xfc, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xd0, 0x0, 0x5, 0x65, 0xf, 0xff, 0x20, 0x2,
    0xff, 0xb0, 0x8f, 0xfd, 0x65, 0xdf, 0xf5, 0x0,
    0xbf, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x6c, 0xff,
    0xc6, 0x0,

    /* U+0044 "D" */
    0xcf, 0xff, 0xfe, 0xa2, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0xcf, 0xf3, 0x38, 0xff, 0xf1,
    0xc, 0xff, 0x0, 0x8, 0xff, 0x90, 0xcf, 0xf0,
    0x0, 0x1f, 0xfd, 0xc, 0xff, 0x0, 0x0, 0xef,
    0xf0, 0xcf, 0xf0, 0x0, 0xe, 0xff, 0xc, 0xff,
    0x0, 0x1, 0xff, 0xd0, 0xcf, 0xf0, 0x0, 0x9f,
    0xf9, 0xc, 0xff, 0x44, 0x9f, 0xff, 0x10, 0xcf,
    0xff, 0xff, 0xff, 0x40, 0xc, 0xff, 0xff, 0xe9,
    0x20, 0x0,

    /* U+0045 "E" */
    0xcf, 0xff, 0xff, 0xff, 0xcc, 0xff, 0xff, 0xff,
    0xfc, 0xcf, 0xf5, 0x44, 0x44, 0x3c, 0xff, 0x0,
    0x0, 0x0, 0xcf, 0xf4, 0x44, 0x42, 0xc, 0xff,
    0xff, 0xff, 0x80, 0xcf, 0xff, 0xff, 0xf8, 0xc,
    0xff, 0x0, 0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0,
    0xc, 0xff, 0x65, 0x55, 0x54, 0xcf, 0xff, 0xff,
    0xff, 0xcc, 0xff, 0xff, 0xff, 0xfc,

    /* U+0046 "F" */
    0xcf, 0xff, 0xff, 0xff, 0xbc, 0xff, 0xff, 0xff,
    0xfb, 0xcf, 0xf7, 0x55, 0x55, 0x4c, 0xff, 0x20,
    0x0, 0x0, 0xcf, 0xf2, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xff, 0x90, 0xcf, 0xff, 0xff, 0xf9, 0xc,
    0xff, 0x53, 0x33, 0x20, 0xcf, 0xf2, 0x0, 0x0,
    0xc, 0xff, 0x20, 0x0, 0x0, 0xcf, 0xf2, 0x0,
    0x0, 0xc, 0xff, 0x20, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x7, 0xdf, 0xfb, 0x40, 0x0, 0xb, 0xff,
    0xff, 0xff, 0x50, 0x7, 0xff, 0xc5, 0x7f, 0xff,
    0x10, 0xef, 0xf1, 0x0, 0x6f, 0xf5, 0x3f, 0xfa,
    0x0, 0x1, 0x64, 0x15, 0xff, 0x80, 0x13, 0x33,
    0x32, 0x5f, 0xf8, 0x6, 0xff, 0xff, 0x83, 0xff,
    0xa0, 0x6f, 0xff, 0xf8, 0xf, 0xfe, 0x0, 0x3,
    0xff, 0x80, 0x9f, 0xfb, 0x33, 0xcf, 0xf8, 0x1,
    0xdf, 0xff, 0xff, 0xef, 0x80, 0x1, 0x8e, 0xfe,
    0x91, 0xe8,

    /* U+0048 "H" */
    0xcf, 0xf0, 0x0, 0x4f, 0xf7, 0xcf, 0xf0, 0x0,
    0x4f, 0xf7, 0xcf, 0xf0, 0x0, 0x4f, 0xf7, 0xcf,
    0xf0, 0x0, 0x4f, 0xf7, 0xcf, 0xf5, 0x55, 0x8f,
    0xf7, 0xcf, 0xff, 0xff, 0xff, 0xf7, 0xcf, 0xff,
    0xff, 0xff, 0xf7, 0xcf, 0xf0, 0x0, 0x4f, 0xf7,
    0xcf, 0xf0, 0x0, 0x4f, 0xf7, 0xcf, 0xf0, 0x0,
    0x4f, 0xf7, 0xcf, 0xf0, 0x0, 0x4f, 0xf7, 0xcf,
    0xf0, 0x0, 0x4f, 0xf7,

    /* U+0049 "I" */
    0xcf, 0xf0, 0xcf, 0xf0, 0xcf, 0xf0, 0xcf, 0xf0,
    0xcf, 0xf0, 0xcf, 0xf0, 0xcf, 0xf0, 0xcf, 0xf0,
    0xcf, 0xf0, 0xcf, 0xf0, 0xcf, 0xf0, 0xcf, 0xf0,

    /* U+004A "J" */
    0x0, 0xf, 0xfc, 0x0, 0xf, 0xfc, 0x0, 0xf,
    0xfc, 0x0, 0xf, 0xfc, 0x0, 0xf, 0xfc, 0x0,
    0xf, 0xfc, 0x0, 0xf, 0xfc, 0x0, 0xf, 0xfc,
    0x0, 0x1f, 0xfc, 0x66, 0xbf, 0xfa, 0xef, 0xff,
    0xf4, 0xcf, 0xfd, 0x60,

    /* U+004B "K" */
    0xcf, 0xf0, 0x0, 0x9f, 0xf2, 0xc, 0xff, 0x0,
    0x4f, 0xf6, 0x0, 0xcf, 0xf0, 0xe, 0xfb, 0x0,
    0xc, 0xff, 0x9, 0xff, 0x10, 0x0, 0xcf, 0xf4,
    0xff, 0xa0, 0x0, 0xc, 0xff, 0xef, 0xff, 0x10,
    0x0, 0xcf, 0xff, 0xff, 0xf9, 0x0, 0xc, 0xff,
    0xf4, 0xff, 0xf1, 0x0, 0xcf, 0xf7, 0x9, 0xff,
    0x80, 0xc, 0xff, 0x0, 0x2f, 0xfe, 0x0, 0xcf,
    0xf0, 0x0, 0xaf, 0xf7, 0xc, 0xff, 0x0, 0x3,
    0xff, 0xe0,

    /* U+004C "L" */
    0xcf, 0xf0, 0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0,
    0xcf, 0xf0, 0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0,
    0xcf, 0xf0, 0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0,
    0xcf, 0xf0, 0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0,
    0xcf, 0xf0, 0x0, 0x0, 0xcf, 0xf6, 0x55, 0x54,
    0xcf, 0xff, 0xff, 0xfd, 0xcf, 0xff, 0xff, 0xfd,

    /* U+004D "M" */
    0xcf, 0xff, 0xb0, 0x0, 0x4f, 0xff, 0xf4, 0xcf,
    0xff, 0xf0, 0x0, 0x9f, 0xff, 0xf4, 0xcf, 0xef,
    0xf4, 0x0, 0xef, 0xef, 0xf4, 0xcf, 0xaf, 0xf9,
    0x3, 0xff, 0xaf, 0xf4, 0xcf, 0x8c, 0xfe, 0x8,
    0xfb, 0x9f, 0xf4, 0xcf, 0x87, 0xff, 0x2c, 0xf6,
    0x9f, 0xf4, 0xcf, 0x82, 0xff, 0x9f, 0xf1, 0x9f,
    0xf4, 0xcf, 0x80, 0xdf, 0xff, 0xc0, 0x9f, 0xf4,
    0xcf, 0x80, 0x8f, 0xff, 0x70, 0x9f, 0xf4, 0xcf,
    0x80, 0x4f, 0xff, 0x30, 0x9f, 0xf4, 0xcf, 0x80,
    0xe, 0xfe, 0x0, 0x9f, 0xf4, 0xcf, 0x80, 0xa,
    0xf9, 0x0, 0x9f, 0xf4,

    /* U+004E "N" */
    0xcf, 0xf8, 0x0, 0xb, 0xf7, 0xcf, 0xff, 0x20,
    0xb, 0xf7, 0xcf, 0xff, 0xa0, 0xb, 0xf7, 0xcf,
    0xff, 0xf4, 0xb, 0xf7, 0xcf, 0xaf, 0xfd, 0xb,
    0xf7, 0xcf, 0x6b, 0xff, 0x6b, 0xf7, 0xcf, 0x62,
    0xff, 0xec, 0xf7, 0xcf, 0x60, 0x9f, 0xff, 0xf7,
    0xcf, 0x60, 0x1e, 0xff, 0xf7, 0xcf, 0x60, 0x6,
    0xff, 0xf7, 0xcf, 0x60, 0x0, 0xdf, 0xf7, 0xcf,
    0x60, 0x0, 0x3f, 0xf7,

    /* U+004F "O" */
    0x0, 0x7, 0xdf, 0xeb, 0x30, 0x0, 0xc, 0xff,
    0xff, 0xff, 0x40, 0x8, 0xff, 0xc5, 0x7f, 0xfe,
    0x10, 0xef, 0xf1, 0x0, 0x8f, 0xf7, 0x3f, 0xfb,
    0x0, 0x3, 0xff, 0xb5, 0xff, 0x90, 0x0, 0x1f,
    0xfd, 0x5f, 0xf9, 0x0, 0x1, 0xff, 0xd3, 0xff,
    0xb0, 0x0, 0x3f, 0xfb, 0xe, 0xff, 0x10, 0x8,
    0xff, 0x70, 0x7f, 0xfc, 0x57, 0xff, 0xf1, 0x0,
    0xcf, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x7d, 0xfe,
    0xb3, 0x0,

    /* U+0050 "P" */
    0xcf, 0xff, 0xff, 0xd9, 0x10, 0xcf, 0xff, 0xff,
    0xff, 0xc0, 0xcf, 0xf2, 0x24, 0xdf, 0xf5, 0xcf,
    0xf0, 0x0, 0x6f, 0xf7, 0xcf, 0xf0, 0x1, 0xbf,
    0xf5, 0xcf, 0xff, 0xff, 0xff, 0xe0, 0xcf, 0xff,
    0xff, 0xfc, 0x20, 0xcf, 0xf3, 0x22, 0x10, 0x0,
    0xcf, 0xf0, 0x0, 0x0, 0x0, 0xcf, 0xf0, 0x0,
    0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0, 0x0, 0xcf,
    0xf0, 0x0, 0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x7, 0xdf, 0xeb, 0x30, 0x0, 0xc, 0xff,
    0xff, 0xff, 0x50, 0x7, 0xff, 0xc5, 0x7f, 0xff,
    0x10, 0xef, 0xf1, 0x0, 0x7f, 0xf8, 0x3f, 0xfb,
    0x0, 0x2, 0xff, 0xc5, 0xff, 0x90, 0x0, 0xf,
    0xfe, 0x5f, 0xf9, 0x0, 0x0, 0xff, 0xe3, 0xff,
    0xb0, 0x0, 0x1f, 0xfc, 0xe, 0xff, 0x0, 0x6,
    0xff, 0x80, 0x7f, 0xfb, 0x46, 0xff, 0xf2, 0x0,
    0xcf, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x7d, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x8f, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x0,

    /* U+0052 "R" */
    0xcf, 0xff, 0xff, 0xeb, 0x40, 0xcf, 0xff, 0xff,
    0xff, 0xf3, 0xcf, 0xf2, 0x22, 0x9f, 0xfa, 0xcf,
    0xf0, 0x0, 0x1f, 0xfd, 0xcf, 0xf0, 0x0, 0x8f,
    0xfa, 0xcf, 0xff, 0xff, 0xff, 0xe2, 0xcf, 0xff,
    0xff, 0xfe, 0x10, 0xcf, 0xf0, 0xc, 0xff, 0x30,
    0xcf, 0xf0, 0x6, 0xff, 0x90, 0xcf, 0xf0, 0x1,
    0xff, 0xf0, 0xcf, 0xf0, 0x0, 0xaf, 0xf6, 0xcf,
    0xf0, 0x0, 0x4f, 0xfc,

    /* U+0053 "S" */
    0x0, 0x6c, 0xff, 0xc7, 0x0, 0x9, 0xff, 0xff,
    0xff, 0xb0, 0x2f, 0xfc, 0x33, 0xaf, 0xf4, 0x5f,
    0xf8, 0x0, 0x6, 0x10, 0x3f, 0xff, 0xb7, 0x40,
    0x0, 0xc, 0xff, 0xff, 0xfe, 0x60, 0x0, 0x8e,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x26, 0xcf, 0xfb,
    0x59, 0xa0, 0x0, 0x1f, 0xfc, 0xaf, 0xfa, 0x44,
    0xaf, 0xf8, 0x1d, 0xff, 0xff, 0xff, 0xd0, 0x1,
    0x8d, 0xff, 0xd8, 0x0,

    /* U+0054 "T" */
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
    0xfd, 0x55, 0x5f, 0xfe, 0x55, 0x40, 0x0, 0xff,
    0xd0, 0x0, 0x0, 0xf, 0xfd, 0x0, 0x0, 0x0,
    0xff, 0xd0, 0x0, 0x0, 0xf, 0xfd, 0x0, 0x0,
    0x0, 0xff, 0xd0, 0x0, 0x0, 0xf, 0xfd, 0x0,
    0x0, 0x0, 0xff, 0xd0, 0x0, 0x0, 0xf, 0xfd,
    0x0, 0x0, 0x0, 0xff, 0xd0, 0x0,

    /* U+0055 "U" */
    0xef, 0xf2, 0x0, 0xc, 0xfa, 0xef, 0xf2, 0x0,
    0xc, 0xfa, 0xef, 0xf2, 0x0, 0xc, 0xfa, 0xef,
    0xf2, 0x0, 0xc, 0xfa, 0xef, 0xf2, 0x0, 0xc,
    0xfa, 0xef, 0xf2, 0x0, 0xc, 0xfa, 0xef, 0xf2,
    0x0, 0xc, 0xfa, 0xef, 0xf2, 0x0, 0xc, 0xfa,
    0xdf, 0xf3, 0x0, 0xd, 0xf9, 0x9f, 0xfd, 0x65,
    0xaf, 0xf6, 0x2e, 0xff, 0xff, 0xff, 0xd0, 0x2,
    0x9e, 0xff, 0xd8, 0x0,

    /* U+0056 "V" */
    0xf, 0xff, 0x0, 0x0, 0x6f, 0xf0, 0xa, 0xff,
    0x40, 0x0, 0xbf, 0xa0, 0x6, 0xff, 0x80, 0x0,
    0xff, 0x50, 0x1, 0xff, 0xd0, 0x4, 0xff, 0x10,
    0x0, 0xcf, 0xf1, 0x8, 0xfc, 0x0, 0x0, 0x7f,
    0xf6, 0xd, 0xf7, 0x0, 0x0, 0x2f, 0xfa, 0x2f,
    0xf2, 0x0, 0x0, 0xd, 0xff, 0x7f, 0xd0, 0x0,
    0x0, 0x9, 0xff, 0xef, 0x80, 0x0, 0x0, 0x4,
    0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xfa, 0x0, 0x0,

    /* U+0057 "W" */
    0xcf, 0xf1, 0x0, 0x5f, 0xf8, 0x0, 0xd, 0xf7,
    0x7f, 0xf5, 0x0, 0x9f, 0xfc, 0x0, 0x1f, 0xf3,
    0x3f, 0xf8, 0x0, 0xdf, 0xff, 0x0, 0x4f, 0xf0,
    0xf, 0xfc, 0x1, 0xff, 0xff, 0x40, 0x8f, 0xb0,
    0xb, 0xff, 0x4, 0xfc, 0xff, 0x80, 0xcf, 0x70,
    0x7, 0xff, 0x38, 0xf7, 0xcf, 0xc0, 0xff, 0x30,
    0x3, 0xff, 0x7c, 0xf4, 0x8f, 0xf4, 0xff, 0x0,
    0x0, 0xff, 0xbf, 0xf0, 0x4f, 0xfb, 0xfb, 0x0,
    0x0, 0xbf, 0xff, 0xc0, 0xf, 0xff, 0xf7, 0x0,
    0x0, 0x7f, 0xff, 0x80, 0xc, 0xff, 0xf3, 0x0,
    0x0, 0x2f, 0xff, 0x40, 0x8, 0xff, 0xf0, 0x0,
    0x0, 0xe, 0xff, 0x10, 0x4, 0xff, 0xb0, 0x0,

    /* U+0058 "X" */
    0x4f, 0xfe, 0x0, 0x9, 0xff, 0x10, 0xaf, 0xf8,
    0x2, 0xff, 0x70, 0x1, 0xff, 0xf1, 0xbf, 0xd0,
    0x0, 0x8, 0xff, 0xcf, 0xf4, 0x0, 0x0, 0xe,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x6f, 0xff, 0x30,
    0x0, 0x0, 0xc, 0xff, 0xf9, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xf2, 0x0, 0x0, 0xef, 0x96, 0xff,
    0xb0, 0x0, 0x8f, 0xf1, 0xd, 0xff, 0x50, 0x2f,
    0xf8, 0x0, 0x5f, 0xfd, 0xa, 0xfe, 0x0, 0x0,
    0xcf, 0xf7,

    /* U+0059 "Y" */
    0x3f, 0xff, 0x10, 0x0, 0xef, 0x90, 0xaf, 0xf8,
    0x0, 0x6f, 0xf1, 0x2, 0xff, 0xf1, 0xe, 0xf8,
    0x0, 0x9, 0xff, 0x86, 0xfe, 0x0, 0x0, 0x1f,
    0xff, 0xef, 0x60, 0x0, 0x0, 0x8f, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0xef, 0xf5, 0x0, 0x0, 0x0,
    0xb, 0xff, 0x10, 0x0, 0x0, 0x0, 0xbf, 0xf1,
    0x0, 0x0, 0x0, 0xb, 0xff, 0x10, 0x0, 0x0,
    0x0, 0xbf, 0xf1, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x10, 0x0,

    /* U+005A "Z" */
    0x3f, 0xff, 0xff, 0xff, 0xfd, 0x3, 0xff, 0xff,
    0xff, 0xff, 0xd0, 0x4, 0x44, 0x44, 0xef, 0xf8,
    0x0, 0x0, 0x0, 0x9f, 0xfb, 0x0, 0x0, 0x0,
    0x5f, 0xfd, 0x10, 0x0, 0x0, 0x2f, 0xff, 0x20,
    0x0, 0x0, 0xd, 0xff, 0x50, 0x0, 0x0, 0xb,
    0xff, 0x80, 0x0, 0x0, 0x7, 0xff, 0xb0, 0x0,
    0x0, 0x4, 0xff, 0xf5, 0x44, 0x44, 0x40, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xf0,

    /* U+005B "[" */
    0xf, 0xff, 0xb0, 0xff, 0x21, 0xf, 0xf0, 0x0,
    0xff, 0x0, 0xf, 0xf0, 0x0, 0xff, 0x0, 0xf,
    0xf0, 0x0, 0xff, 0x0, 0xf, 0xf0, 0x0, 0xff,
    0x0, 0xf, 0xf0, 0x0, 0xff, 0x0, 0xf, 0xf0,
    0x0, 0xff, 0x10, 0xf, 0xff, 0xb0,

    /* U+005C "\\" */
    0x3f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x20,
    0x0, 0x0, 0x0, 0x2, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x60, 0x0,
    0x0, 0x0, 0x0, 0xce, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x0, 0x0,
    0xec, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x80,

    /* U+005D "]" */
    0x7f, 0xff, 0x50, 0x1b, 0xf5, 0x0, 0xbf, 0x50,
    0xb, 0xf5, 0x0, 0xbf, 0x50, 0xb, 0xf5, 0x0,
    0xbf, 0x50, 0xb, 0xf5, 0x0, 0xbf, 0x50, 0xb,
    0xf5, 0x0, 0xbf, 0x50, 0xb, 0xf5, 0x0, 0xbf,
    0x50, 0x1b, 0xf5, 0x7f, 0xff, 0x50,

    /* U+005E "^" */
    0x0, 0x5f, 0xff, 0x50, 0x0, 0xc, 0xff, 0xfc,
    0x0, 0x4, 0xff, 0x7f, 0xf4, 0x0, 0xbf, 0xc0,
    0xcf, 0xb0, 0x3f, 0xf4, 0x4, 0xff, 0x3a, 0xfd,
    0x0, 0xd, 0xfa,

    /* U+005F "_" */
    0x11, 0x11, 0x11, 0x11, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+0060 "`" */
    0x0, 0x0, 0x9, 0xc3, 0x0, 0x6d, 0xf9, 0x10,
    0x4, 0xa1,

    /* U+0061 "a" */
    0x0, 0x7c, 0xfe, 0xc6, 0x0, 0xaf, 0xfc, 0xef,
    0xf5, 0xd, 0xe6, 0x1, 0xff, 0x90, 0x0, 0x35,
    0x7f, 0xfa, 0x5, 0xef, 0xfe, 0xff, 0xa3, 0xff,
    0xc2, 0xf, 0xfa, 0x6f, 0xf5, 0x2, 0xff, 0xa3,
    0xff, 0xd7, 0xdf, 0xfa, 0x6, 0xef, 0xd4, 0xcf,
    0xb0,

    /* U+0062 "b" */
    0xef, 0xb0, 0x0, 0x0, 0xe, 0xfb, 0x0, 0x0,
    0x0, 0xef, 0xb0, 0x0, 0x0, 0xe, 0xfb, 0x8f,
    0xe8, 0x0, 0xef, 0xfe, 0xdf, 0xf7, 0xe, 0xfe,
    0x10, 0xcf, 0xe0, 0xef, 0xb0, 0x8, 0xff, 0x1e,
    0xfb, 0x0, 0x7f, 0xf2, 0xef, 0xb0, 0x8, 0xff,
    0x1e, 0xfe, 0x10, 0xdf, 0xd0, 0xef, 0xde, 0xef,
    0xf6, 0xe, 0xa2, 0xcf, 0xe7, 0x0,

    /* U+0063 "c" */
    0x0, 0x4c, 0xfe, 0xb2, 0x0, 0x6f, 0xff, 0xff,
    0xf2, 0xf, 0xfe, 0x21, 0xdf, 0xa4, 0xff, 0x90,
    0x3, 0x65, 0x6f, 0xf8, 0x0, 0x0, 0x5, 0xff,
    0x90, 0x5, 0x86, 0x1f, 0xfe, 0x33, 0xef, 0x90,
    0x7f, 0xff, 0xff, 0xe1, 0x0, 0x5c, 0xfe, 0xa2,
    0x0,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0xef, 0xa0, 0x0, 0x0, 0xe,
    0xfa, 0x0, 0x0, 0x0, 0xef, 0xa0, 0x1a, 0xfe,
    0x7e, 0xfa, 0xa, 0xff, 0xef, 0xff, 0xa1, 0xff,
    0xc0, 0x3f, 0xfa, 0x4f, 0xf6, 0x0, 0xff, 0xa6,
    0xff, 0x50, 0xe, 0xfa, 0x4f, 0xf5, 0x0, 0xef,
    0xa2, 0xff, 0xa0, 0x2f, 0xfa, 0xb, 0xff, 0xbe,
    0xff, 0xa0, 0x1b, 0xfe, 0x5c, 0xfa,

    /* U+0065 "e" */
    0x0, 0x4c, 0xfe, 0xa2, 0x0, 0x6, 0xff, 0xcd,
    0xfe, 0x10, 0xf, 0xfa, 0x0, 0xcf, 0x90, 0x4f,
    0xfb, 0x88, 0xcf, 0xe0, 0x6f, 0xff, 0xff, 0xff,
    0xf0, 0x5f, 0xf5, 0x0, 0x1, 0x0, 0xf, 0xfb,
    0x0, 0xaf, 0xc0, 0x6, 0xff, 0xfe, 0xff, 0x30,
    0x0, 0x5c, 0xfe, 0xb3, 0x0,

    /* U+0066 "f" */
    0x0, 0x9e, 0xf9, 0x8, 0xff, 0xfa, 0xb, 0xfe,
    0x10, 0xcf, 0xff, 0xf6, 0xcf, 0xff, 0xf6, 0xb,
    0xfd, 0x0, 0xb, 0xfd, 0x0, 0xb, 0xfd, 0x0,
    0xb, 0xfd, 0x0, 0xb, 0xfd, 0x0, 0xb, 0xfd,
    0x0, 0xb, 0xfd, 0x0,

    /* U+0067 "g" */
    0x0, 0x0, 0x0, 0x1, 0x89, 0x0, 0x0, 0x0,
    0x9, 0xff, 0x1, 0x8d, 0xff, 0xef, 0x80, 0xd,
    0xfe, 0x78, 0xff, 0x90, 0x2f, 0xf7, 0x0, 0xbf,
    0xe0, 0x1f, 0xfb, 0x24, 0xef, 0xc0, 0x3, 0xef,
    0xff, 0xfb, 0x20, 0xb, 0xf5, 0x43, 0x10, 0x0,
    0x5f, 0xf5, 0x11, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xc2, 0xb, 0xff, 0xff, 0xff, 0xfb, 0xaf,
    0xa0, 0x0, 0x1b, 0xfd, 0xaf, 0xfa, 0x99, 0xaf,
    0xf6, 0x19, 0xdf, 0xff, 0xeb, 0x50,

    /* U+0068 "h" */
    0xef, 0xa0, 0x0, 0x0, 0xef, 0xa0, 0x0, 0x0,
    0xef, 0xa0, 0x0, 0x0, 0xef, 0xa8, 0xef, 0x90,
    0xef, 0xff, 0xff, 0xf7, 0xef, 0xf3, 0x4f, 0xfa,
    0xef, 0xa0, 0xe, 0xfb, 0xef, 0xa0, 0xe, 0xfb,
    0xef, 0xa0, 0xe, 0xfb, 0xef, 0xa0, 0xe, 0xfb,
    0xef, 0xa0, 0xe, 0xfb, 0xef, 0xa0, 0xe, 0xfb,

    /* U+0069 "i" */
    0xef, 0xbe, 0xfb, 0x89, 0x6e, 0xfb, 0xef, 0xbe,
    0xfb, 0xef, 0xbe, 0xfb, 0xef, 0xbe, 0xfb, 0xef,
    0xbe, 0xfb,

    /* U+006A "j" */
    0x0, 0xef, 0xc0, 0xe, 0xfc, 0x0, 0x9a, 0x70,
    0xe, 0xfc, 0x0, 0xef, 0xc0, 0xe, 0xfc, 0x0,
    0xef, 0xc0, 0xe, 0xfc, 0x0, 0xef, 0xc0, 0xe,
    0xfc, 0x0, 0xef, 0xc0, 0xf, 0xfb, 0x15, 0xff,
    0xb8, 0xff, 0xf8, 0x7f, 0xfa, 0x0,

    /* U+006B "k" */
    0xef, 0x80, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0,
    0x0, 0xef, 0x80, 0x0, 0x0, 0xe, 0xf8, 0x0,
    0x7f, 0xe2, 0xef, 0x80, 0x5f, 0xf4, 0xe, 0xf8,
    0x3f, 0xf6, 0x0, 0xef, 0x9e, 0xff, 0x20, 0xe,
    0xff, 0xff, 0xfa, 0x0, 0xef, 0xf9, 0xaf, 0xf2,
    0xe, 0xfb, 0x3, 0xff, 0x90, 0xef, 0x80, 0xb,
    0xff, 0x1e, 0xf8, 0x0, 0x4f, 0xf9,

    /* U+006C "l" */
    0xef, 0xbe, 0xfb, 0xef, 0xbe, 0xfb, 0xef, 0xbe,
    0xfb, 0xef, 0xbe, 0xfb, 0xef, 0xbe, 0xfb, 0xef,
    0xbe, 0xfb,

    /* U+006D "m" */
    0xef, 0x99, 0xff, 0x91, 0x9e, 0xfa, 0xe, 0xff,
    0xff, 0xff, 0xef, 0xff, 0xf8, 0xef, 0xe0, 0x2f,
    0xfe, 0x11, 0xff, 0xbe, 0xfa, 0x0, 0xef, 0xb0,
    0xd, 0xfb, 0xef, 0xa0, 0xe, 0xfb, 0x0, 0xdf,
    0xce, 0xfa, 0x0, 0xef, 0xb0, 0xd, 0xfc, 0xef,
    0xa0, 0xe, 0xfb, 0x0, 0xdf, 0xce, 0xfa, 0x0,
    0xef, 0xb0, 0xd, 0xfc, 0xef, 0xa0, 0xe, 0xfb,
    0x0, 0xdf, 0xc0,

    /* U+006E "n" */
    0xef, 0x88, 0xee, 0x90, 0xef, 0xef, 0xff, 0xf8,
    0xef, 0xf1, 0x1f, 0xfb, 0xef, 0xb0, 0xd, 0xfc,
    0xef, 0xb0, 0xd, 0xfc, 0xef, 0xb0, 0xd, 0xfc,
    0xef, 0xb0, 0xd, 0xfc, 0xef, 0xb0, 0xd, 0xfc,
    0xef, 0xb0, 0xd, 0xfc,

    /* U+006F "o" */
    0x0, 0x5c, 0xfe, 0xa2, 0x0, 0x7, 0xff, 0xce,
    0xfe, 0x20, 0x1f, 0xfa, 0x1, 0xff, 0xa0, 0x5f,
    0xf6, 0x0, 0xbf, 0xf0, 0x6f, 0xf5, 0x0, 0xbf,
    0xf0, 0x5f, 0xf6, 0x0, 0xbf, 0xf0, 0x1f, 0xfb,
    0x1, 0xff, 0xa0, 0x7, 0xff, 0xce, 0xfe, 0x20,
    0x0, 0x5d, 0xfe, 0xa2, 0x0,

    /* U+0070 "p" */
    0xef, 0x8a, 0xfe, 0x70, 0xe, 0xff, 0xcc, 0xff,
    0x60, 0xef, 0xd0, 0xd, 0xfd, 0xe, 0xfa, 0x0,
    0xaf, 0xf0, 0xef, 0xa0, 0x9, 0xff, 0x1e, 0xfa,
    0x0, 0xaf, 0xf0, 0xef, 0xd0, 0x1e, 0xfd, 0xe,
    0xff, 0xef, 0xff, 0x60, 0xef, 0xaa, 0xfe, 0x70,
    0xe, 0xfa, 0x0, 0x0, 0x0, 0xef, 0xa0, 0x0,
    0x0, 0xe, 0xfa, 0x0, 0x0, 0x0,

    /* U+0071 "q" */
    0x0, 0x8e, 0xfb, 0x1d, 0xc0, 0x9f, 0xfd, 0xfe,
    0xfb, 0x1f, 0xfb, 0x2, 0xff, 0xb4, 0xff, 0x60,
    0xd, 0xfb, 0x6f, 0xf5, 0x0, 0xdf, 0xb4, 0xff,
    0x60, 0xe, 0xfb, 0x1f, 0xfb, 0x3, 0xff, 0xb0,
    0xaf, 0xfe, 0xff, 0xfb, 0x0, 0x9f, 0xe8, 0xdf,
    0xb0, 0x0, 0x0, 0xd, 0xfb, 0x0, 0x0, 0x0,
    0xdf, 0xb0, 0x0, 0x0, 0xd, 0xfb,

    /* U+0072 "r" */
    0x0, 0x0, 0xe, 0xf8, 0xbd, 0xef, 0xef, 0xee,
    0xff, 0xc6, 0xef, 0xe0, 0xe, 0xfb, 0x0, 0xef,
    0xa0, 0xe, 0xfa, 0x0, 0xef, 0xa0, 0xe, 0xfa,
    0x0,

    /* U+0073 "s" */
    0x3, 0xbe, 0xfc, 0x50, 0x2, 0xff, 0xba, 0xff,
    0x40, 0x7f, 0xd0, 0x4, 0x94, 0x6, 0xff, 0xfc,
    0x95, 0x0, 0xc, 0xff, 0xff, 0xf9, 0x0, 0x4,
    0x8a, 0xef, 0xf0, 0x8c, 0x80, 0x5, 0xff, 0x5,
    0xff, 0xdc, 0xff, 0xa0, 0x5, 0xce, 0xfd, 0x70,
    0x0,

    /* U+0074 "t" */
    0x2, 0xab, 0x0, 0x0, 0x5f, 0xf0, 0x0, 0x6,
    0xff, 0x0, 0xf, 0xff, 0xff, 0xf0, 0xff, 0xff,
    0xff, 0x0, 0x9f, 0xf0, 0x0, 0x9, 0xff, 0x0,
    0x0, 0x9f, 0xf0, 0x0, 0x9, 0xff, 0x0, 0x0,
    0x8f, 0xf4, 0x10, 0x5, 0xff, 0xff, 0x10, 0x9,
    0xef, 0xe0,

    /* U+0075 "u" */
    0xef, 0xa0, 0xf, 0xfa, 0xef, 0xa0, 0xf, 0xfa,
    0xef, 0xa0, 0xf, 0xfa, 0xef, 0xa0, 0xf, 0xfa,
    0xef, 0xa0, 0xf, 0xfa, 0xef, 0xa0, 0xf, 0xfa,
    0xef, 0xc0, 0x4f, 0xfa, 0xbf, 0xfe, 0xfe, 0xfa,
    0x2c, 0xfe, 0x6c, 0xfa,

    /* U+0076 "v" */
    0xe, 0xfc, 0x0, 0xf, 0xe0, 0x8, 0xff, 0x10,
    0x5f, 0x80, 0x3, 0xff, 0x60, 0xaf, 0x30, 0x0,
    0xef, 0xb0, 0xed, 0x0, 0x0, 0x8f, 0xf4, 0xf8,
    0x0, 0x0, 0x3f, 0xfd, 0xf3, 0x0, 0x0, 0xd,
    0xff, 0xd0, 0x0, 0x0, 0x8, 0xff, 0x80, 0x0,
    0x0, 0x2, 0xff, 0x20, 0x0,

    /* U+0077 "w" */
    0xcf, 0xf0, 0x8, 0xff, 0x10, 0x5f, 0xa7, 0xff,
    0x30, 0xbf, 0xf5, 0x9, 0xf6, 0x2f, 0xf7, 0xf,
    0xff, 0x90, 0xef, 0x10, 0xdf, 0xb3, 0xfd, 0xfd,
    0x2f, 0xc0, 0x8, 0xff, 0x8f, 0x5f, 0xf7, 0xf7,
    0x0, 0x3f, 0xfe, 0xe0, 0xff, 0xef, 0x30, 0x0,
    0xef, 0xfa, 0xc, 0xff, 0xe0, 0x0, 0xa, 0xff,
    0x60, 0x8f, 0xf9, 0x0, 0x0, 0x5f, 0xf2, 0x4,
    0xff, 0x40, 0x0,

    /* U+0078 "x" */
    0x4f, 0xfa, 0x1, 0xff, 0x20, 0xbf, 0xf4, 0xaf,
    0x80, 0x1, 0xff, 0xef, 0xd0, 0x0, 0x7, 0xff,
    0xf4, 0x0, 0x0, 0x4f, 0xff, 0x20, 0x0, 0xd,
    0xff, 0xfb, 0x0, 0x7, 0xfb, 0x9f, 0xf5, 0x2,
    0xff, 0x21, 0xef, 0xe0, 0xbf, 0x80, 0x6, 0xff,
    0x90,

    /* U+0079 "y" */
    0xe, 0xfd, 0x0, 0x1f, 0xc0, 0x8f, 0xf2, 0x6,
    0xf7, 0x2, 0xff, 0x80, 0xbf, 0x20, 0xc, 0xfd,
    0xf, 0xc0, 0x0, 0x6f, 0xf7, 0xf7, 0x0, 0x1,
    0xff, 0xff, 0x20, 0x0, 0xb, 0xff, 0xd0, 0x0,
    0x0, 0x5f, 0xf8, 0x0, 0x0, 0x0, 0xff, 0x20,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x8, 0xff, 0xf6,
    0x0, 0x0, 0x8f, 0xe8, 0x0, 0x0,

    /* U+007A "z" */
    0x5f, 0xff, 0xff, 0xf2, 0x3c, 0xcc, 0xff, 0xf2,
    0x0, 0x4, 0xff, 0x80, 0x0, 0x1e, 0xfc, 0x0,
    0x0, 0xbf, 0xf2, 0x0, 0x7, 0xff, 0x60, 0x0,
    0x3f, 0xfa, 0x0, 0x0, 0xaf, 0xfe, 0xee, 0xe4,
    0xaf, 0xff, 0xff, 0xf5,

    /* U+007B "{" */
    0x0, 0x9f, 0xf0, 0x2f, 0xf1, 0x4, 0xfe, 0x0,
    0x4f, 0xe0, 0x4, 0xfe, 0x0, 0x4f, 0xe0, 0xa,
    0xfb, 0x3, 0xff, 0x20, 0x7, 0xfa, 0x0, 0x4f,
    0xe0, 0x4, 0xfe, 0x0, 0x4f, 0xe0, 0x4, 0xfe,
    0x0, 0x2f, 0xf1, 0x0, 0x9f, 0xf0,

    /* U+007C "|" */
    0xbf, 0xcb, 0xfc, 0xbf, 0xcb, 0xfc, 0xbf, 0xcb,
    0xfc, 0xbf, 0xcb, 0xfc, 0xbf, 0xcb, 0xfc, 0xbf,
    0xcb, 0xfc, 0xbf, 0xcb, 0xfc, 0xbf, 0xc0,

    /* U+007D "}" */
    0x4f, 0xe5, 0x0, 0x5f, 0xd0, 0x3, 0xff, 0x0,
    0x3f, 0xf0, 0x3, 0xff, 0x0, 0x2f, 0xf0, 0x0,
    0xff, 0x30, 0x7, 0xff, 0x0, 0xff, 0x60, 0x2f,
    0xf0, 0x3, 0xff, 0x0, 0x3f, 0xf0, 0x3, 0xff,
    0x0, 0x5f, 0xd0, 0x4f, 0xe5, 0x0,

    /* U+007E "~" */
    0x0, 0x15, 0x20, 0x0, 0x20, 0x3, 0xff, 0xfd,
    0x78, 0xf6, 0xc, 0xff, 0xff, 0xff, 0xf2, 0x9,
    0xa0, 0x4a, 0xed, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+00B0 "°" */
    0x0, 0x0, 0x0, 0x3, 0xdf, 0xa0, 0xe, 0x95,
    0xe7, 0x2f, 0x10, 0x8b, 0xf, 0x72, 0xd9, 0x5,
    0xff, 0xd1, 0x0, 0x12, 0x0,

    /* U+0410 "А" */
    0x0, 0x5, 0xff, 0xf4, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0x90, 0x0, 0x0, 0xe, 0xff, 0xfe, 0x0,
    0x0, 0x4, 0xff, 0xbf, 0xf3, 0x0, 0x0, 0x9f,
    0xa5, 0xff, 0x80, 0x0, 0xe, 0xf5, 0xf, 0xfd,
    0x0, 0x3, 0xff, 0x10, 0xbf, 0xf2, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0x70, 0xe, 0xff, 0xff, 0xff,
    0xfc, 0x3, 0xff, 0x43, 0x33, 0xdf, 0xf1, 0x8f,
    0xd0, 0x0, 0x8, 0xff, 0x6d, 0xf9, 0x0, 0x0,
    0x4f, 0xfb,

    /* U+0411 "Б" */
    0xcf, 0xff, 0xff, 0xff, 0x30, 0xcf, 0xff, 0xff,
    0xff, 0x30, 0xcf, 0xf2, 0x22, 0x22, 0x0, 0xcf,
    0xf0, 0x0, 0x0, 0x0, 0xcf, 0xf1, 0x11, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xfb, 0x30, 0xcf, 0xff,
    0xff, 0xff, 0xe1, 0xcf, 0xf0, 0x1, 0xaf, 0xf6,
    0xcf, 0xf0, 0x0, 0x5f, 0xf8, 0xcf, 0xf4, 0x45,
    0xdf, 0xf6, 0xcf, 0xff, 0xff, 0xff, 0xe0, 0xcf,
    0xff, 0xff, 0xd9, 0x10,

    /* U+0412 "В" */
    0xcf, 0xff, 0xff, 0xfc, 0x50, 0xc, 0xff, 0xff,
    0xff, 0xff, 0x40, 0xcf, 0xf1, 0x12, 0x9f, 0xfb,
    0xc, 0xff, 0x0, 0x2, 0xff, 0xb0, 0xcf, 0xf2,
    0x22, 0x9f, 0xf6, 0xc, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xc1, 0xc, 0xff,
    0x0, 0x5, 0xff, 0xc0, 0xcf, 0xf0, 0x0, 0xd,
    0xff, 0x1c, 0xff, 0x33, 0x38, 0xff, 0xf0, 0xcf,
    0xff, 0xff, 0xff, 0xf8, 0xc, 0xff, 0xff, 0xff,
    0xc6, 0x0,

    /* U+0413 "Г" */
    0xcf, 0xff, 0xff, 0xf1, 0xcf, 0xff, 0xff, 0xf1,
    0xcf, 0xf5, 0x55, 0x50, 0xcf, 0xf0, 0x0, 0x0,
    0xcf, 0xf0, 0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0,
    0xcf, 0xf0, 0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0,
    0xcf, 0xf0, 0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0,
    0xcf, 0xf0, 0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0,

    /* U+0414 "Д" */
    0x0, 0x0, 0xcf, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0x10, 0x0, 0x0, 0x4, 0xff,
    0x9f, 0xf5, 0x0, 0x0, 0x0, 0x8f, 0xc3, 0xff,
    0x90, 0x0, 0x0, 0xc, 0xf8, 0xf, 0xfd, 0x0,
    0x0, 0x0, 0xff, 0x40, 0xcf, 0xf1, 0x0, 0x0,
    0x4f, 0xf1, 0x8, 0xff, 0x50, 0x0, 0x8, 0xfd,
    0x0, 0x5f, 0xf9, 0x0, 0x0, 0xcf, 0xa0, 0x1,
    0xff, 0xd0, 0x1, 0x4f, 0xf9, 0x44, 0x4e, 0xff,
    0x51, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x54,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x4f, 0xc0,
    0x0, 0x0, 0x0, 0xbf, 0x54, 0xfa, 0x0, 0x0,
    0x0, 0x9, 0xf5, 0x28, 0x40, 0x0, 0x0, 0x0,
    0x48, 0x20,

    /* U+0415 "Е" */
    0xcf, 0xff, 0xff, 0xff, 0xcc, 0xff, 0xff, 0xff,
    0xfc, 0xcf, 0xf5, 0x44, 0x44, 0x3c, 0xff, 0x0,
    0x0, 0x0, 0xcf, 0xf4, 0x44, 0x42, 0xc, 0xff,
    0xff, 0xff, 0x80, 0xcf, 0xff, 0xff, 0xf8, 0xc,
    0xff, 0x0, 0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0,
    0xc, 0xff, 0x65, 0x55, 0x54, 0xcf, 0xff, 0xff,
    0xff, 0xcc, 0xff, 0xff, 0xff, 0xfc,

    /* U+0416 "Ж" */
    0x9, 0xff, 0x40, 0x7, 0xff, 0x10, 0xa, 0xfd,
    0x0, 0x1, 0xef, 0xd0, 0x7, 0xff, 0x10, 0x4f,
    0xf4, 0x0, 0x0, 0x5f, 0xf8, 0x7, 0xff, 0x10,
    0xdf, 0x90, 0x0, 0x0, 0xb, 0xff, 0x27, 0xff,
    0x18, 0xfd, 0x0, 0x0, 0x0, 0x1, 0xff, 0xc7,
    0xff, 0x4f, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xee, 0xff, 0xdf, 0xfa, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x57, 0xff, 0x1b, 0xff, 0x40, 0x0,
    0x0, 0xd, 0xfb, 0x7, 0xff, 0x11, 0xff, 0xe0,
    0x0, 0x0, 0x8f, 0xe1, 0x7, 0xff, 0x10, 0x6f,
    0xf9, 0x0, 0x3, 0xff, 0x50, 0x7, 0xff, 0x10,
    0xb, 0xff, 0x30, 0xd, 0xfb, 0x0, 0x7, 0xff,
    0x10, 0x2, 0xff, 0xd0,

    /* U+0417 "З" */
    0x0, 0x6c, 0xef, 0xd8, 0x10, 0x9, 0xff, 0xff,
    0xff, 0xe1, 0x2f, 0xfb, 0x55, 0xdf, 0xf8, 0x3a,
    0xc0, 0x0, 0x4f, 0xf9, 0x0, 0x0, 0x0, 0x9f,
    0xf3, 0x0, 0x0, 0xaf, 0xfe, 0x40, 0x0, 0x0,
    0x8d, 0xff, 0xe3, 0x0, 0x0, 0x0, 0x3f, 0xfc,
    0x8d, 0xd0, 0x0, 0xf, 0xff, 0x8f, 0xfb, 0x55,
    0xbf, 0xfc, 0xd, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x8d, 0xff, 0xe9, 0x20,

    /* U+0418 "И" */
    0xcf, 0xf0, 0x0, 0xf, 0xfc, 0xcf, 0xf0, 0x0,
    0x2f, 0xfc, 0xcf, 0xf0, 0x0, 0xcf, 0xfc, 0xcf,
    0xf0, 0x8, 0xff, 0xfc, 0xcf, 0xf0, 0x3f, 0xff,
    0xfc, 0xcf, 0xf0, 0xdf, 0x7e, 0xfc, 0xcf, 0xe7,
    0xfe, 0xf, 0xfc, 0xcf, 0xee, 0xf4, 0xf, 0xfc,
    0xcf, 0xff, 0x90, 0xf, 0xfc, 0xcf, 0xfd, 0x0,
    0xf, 0xfc, 0xcf, 0xf3, 0x0, 0xf, 0xfc, 0xcf,
    0xf0, 0x0, 0xf, 0xfc,

    /* U+0419 "Й" */
    0x6, 0x40, 0x5, 0x50, 0x0, 0xa, 0xd2, 0x3e,
    0x70, 0x0, 0x1, 0xdf, 0xfb, 0x0, 0x0, 0x0,
    0x3, 0x20, 0x0, 0x0, 0xcf, 0xf0, 0x0, 0xf,
    0xfc, 0xcf, 0xf0, 0x0, 0x2f, 0xfc, 0xcf, 0xf0,
    0x0, 0xcf, 0xfc, 0xcf, 0xf0, 0x8, 0xff, 0xfc,
    0xcf, 0xf0, 0x3f, 0xff, 0xfc, 0xcf, 0xf0, 0xdf,
    0x7e, 0xfc, 0xcf, 0xe7, 0xfe, 0xf, 0xfc, 0xcf,
    0xee, 0xf4, 0xf, 0xfc, 0xcf, 0xff, 0x90, 0xf,
    0xfc, 0xcf, 0xfd, 0x0, 0xf, 0xfc, 0xcf, 0xf3,
    0x0, 0xf, 0xfc, 0xcf, 0xf0, 0x0, 0xf, 0xfc,

    /* U+041A "К" */
    0xcf, 0xf0, 0x0, 0x9f, 0xf2, 0xc, 0xff, 0x0,
    0x4f, 0xf6, 0x0, 0xcf, 0xf0, 0xe, 0xfb, 0x0,
    0xc, 0xff, 0x9, 0xff, 0x10, 0x0, 0xcf, 0xf4,
    0xff, 0xa0, 0x0, 0xc, 0xff, 0xef, 0xff, 0x10,
    0x0, 0xcf, 0xff, 0xff, 0xf9, 0x0, 0xc, 0xff,
    0xf4, 0xff, 0xf1, 0x0, 0xcf, 0xf7, 0x9, 0xff,
    0x80, 0xc, 0xff, 0x0, 0x2f, 0xfe, 0x0, 0xcf,
    0xf0, 0x0, 0xaf, 0xf7, 0xc, 0xff, 0x0, 0x3,
    0xff, 0xe0,

    /* U+041B "Л" */
    0x0, 0x0, 0xff, 0xff, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x9, 0xfe, 0xff,
    0x90, 0x0, 0x0, 0xe, 0xf7, 0xff, 0xd0, 0x0,
    0x0, 0x2f, 0xf3, 0xbf, 0xf2, 0x0, 0x0, 0x7f,
    0xe0, 0x7f, 0xf7, 0x0, 0x0, 0xbf, 0xa0, 0x3f,
    0xfb, 0x0, 0x0, 0xff, 0x60, 0xe, 0xff, 0x0,
    0x4, 0xff, 0x20, 0xa, 0xff, 0x40, 0x9, 0xfd,
    0x0, 0x6, 0xff, 0x90, 0xd, 0xf9, 0x0, 0x2,
    0xff, 0xd0, 0x2f, 0xf5, 0x0, 0x0, 0xdf, 0xf2,

    /* U+041C "М" */
    0xcf, 0xff, 0xb0, 0x0, 0x4f, 0xff, 0xf4, 0xcf,
    0xff, 0xf0, 0x0, 0x9f, 0xff, 0xf4, 0xcf, 0xef,
    0xf4, 0x0, 0xef, 0xef, 0xf4, 0xcf, 0xaf, 0xf9,
    0x3, 0xff, 0xaf, 0xf4, 0xcf, 0x8c, 0xfe, 0x8,
    0xfb, 0x9f, 0xf4, 0xcf, 0x87, 0xff, 0x2c, 0xf6,
    0x9f, 0xf4, 0xcf, 0x82, 0xff, 0x9f, 0xf1, 0x9f,
    0xf4, 0xcf, 0x80, 0xdf, 0xff, 0xc0, 0x9f, 0xf4,
    0xcf, 0x80, 0x8f, 0xff, 0x70, 0x9f, 0xf4, 0xcf,
    0x80, 0x4f, 0xff, 0x30, 0x9f, 0xf4, 0xcf, 0x80,
    0xe, 0xfe, 0x0, 0x9f, 0xf4, 0xcf, 0x80, 0xa,
    0xf9, 0x0, 0x9f, 0xf4,

    /* U+041D "Н" */
    0xcf, 0xf0, 0x0, 0x4f, 0xf7, 0xcf, 0xf0, 0x0,
    0x4f, 0xf7, 0xcf, 0xf0, 0x0, 0x4f, 0xf7, 0xcf,
    0xf0, 0x0, 0x4f, 0xf7, 0xcf, 0xf5, 0x55, 0x8f,
    0xf7, 0xcf, 0xff, 0xff, 0xff, 0xf7, 0xcf, 0xff,
    0xff, 0xff, 0xf7, 0xcf, 0xf0, 0x0, 0x4f, 0xf7,
    0xcf, 0xf0, 0x0, 0x4f, 0xf7, 0xcf, 0xf0, 0x0,
    0x4f, 0xf7, 0xcf, 0xf0, 0x0, 0x4f, 0xf7, 0xcf,
    0xf0, 0x0, 0x4f, 0xf7,

    /* U+041E "О" */
    0x0, 0x7, 0xdf, 0xeb, 0x30, 0x0, 0xc, 0xff,
    0xff, 0xff, 0x40, 0x8, 0xff, 0xc5, 0x7f, 0xfe,
    0x10, 0xef, 0xf1, 0x0, 0x8f, 0xf7, 0x3f, 0xfb,
    0x0, 0x3, 0xff, 0xb5, 0xff, 0x90, 0x0, 0x1f,
    0xfd, 0x5f, 0xf9, 0x0, 0x1, 0xff, 0xd3, 0xff,
    0xb0, 0x0, 0x3f, 0xfb, 0xe, 0xff, 0x10, 0x8,
    0xff, 0x70, 0x7f, 0xfc, 0x57, 0xff, 0xf1, 0x0,
    0xcf, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x7d, 0xfe,
    0xb3, 0x0,

    /* U+041F "П" */
    0xcf, 0xff, 0xff, 0xff, 0xf2, 0xcf, 0xff, 0xff,
    0xff, 0xf2, 0xcf, 0xf3, 0x33, 0xbf, 0xf2, 0xcf,
    0xf0, 0x0, 0xaf, 0xf2, 0xcf, 0xf0, 0x0, 0xaf,
    0xf2, 0xcf, 0xf0, 0x0, 0xaf, 0xf2, 0xcf, 0xf0,
    0x0, 0xaf, 0xf2, 0xcf, 0xf0, 0x0, 0xaf, 0xf2,
    0xcf, 0xf0, 0x0, 0xaf, 0xf2, 0xcf, 0xf0, 0x0,
    0xaf, 0xf2, 0xcf, 0xf0, 0x0, 0xaf, 0xf2, 0xcf,
    0xf0, 0x0, 0xaf, 0xf2,

    /* U+0420 "Р" */
    0xcf, 0xff, 0xff, 0xd9, 0x10, 0xcf, 0xff, 0xff,
    0xff, 0xc0, 0xcf, 0xf2, 0x24, 0xdf, 0xf5, 0xcf,
    0xf0, 0x0, 0x6f, 0xf7, 0xcf, 0xf0, 0x1, 0xbf,
    0xf5, 0xcf, 0xff, 0xff, 0xff, 0xe0, 0xcf, 0xff,
    0xff, 0xfc, 0x20, 0xcf, 0xf3, 0x22, 0x10, 0x0,
    0xcf, 0xf0, 0x0, 0x0, 0x0, 0xcf, 0xf0, 0x0,
    0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0, 0x0, 0xcf,
    0xf0, 0x0, 0x0, 0x0,

    /* U+0421 "С" */
    0x0, 0x6, 0xcf, 0xfd, 0x70, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xa0, 0x7, 0xff, 0xe6, 0x6e, 0xff,
    0x40, 0xef, 0xf3, 0x0, 0x4f, 0xfa, 0x3f, 0xfe,
    0x0, 0x1, 0x99, 0x75, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x5f, 0xfc, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xd0, 0x0, 0x5, 0x65, 0xf, 0xff, 0x20, 0x2,
    0xff, 0xb0, 0x8f, 0xfd, 0x65, 0xdf, 0xf5, 0x0,
    0xbf, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x6c, 0xff,
    0xc6, 0x0,

    /* U+0422 "Т" */
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
    0xfd, 0x55, 0x5f, 0xfe, 0x55, 0x40, 0x0, 0xff,
    0xd0, 0x0, 0x0, 0xf, 0xfd, 0x0, 0x0, 0x0,
    0xff, 0xd0, 0x0, 0x0, 0xf, 0xfd, 0x0, 0x0,
    0x0, 0xff, 0xd0, 0x0, 0x0, 0xf, 0xfd, 0x0,
    0x0, 0x0, 0xff, 0xd0, 0x0, 0x0, 0xf, 0xfd,
    0x0, 0x0, 0x0, 0xff, 0xd0, 0x0,

    /* U+0423 "У" */
    0x1f, 0xfe, 0x0, 0x0, 0xcf, 0xb0, 0x9f, 0xf6,
    0x0, 0x2f, 0xf5, 0x1, 0xff, 0xe0, 0x8, 0xfe,
    0x0, 0x8, 0xff, 0x60, 0xef, 0x80, 0x0, 0x1e,
    0xfd, 0x6f, 0xf1, 0x0, 0x0, 0x7f, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0xef, 0xff, 0x40, 0x0, 0x0,
    0x6, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x1f, 0xf7,
    0x0, 0x0, 0x3, 0x5b, 0xfe, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0x60, 0x0, 0x0, 0xd, 0xfd, 0x60,
    0x0, 0x0,

    /* U+0424 "Ф" */
    0x0, 0x0, 0x6, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x26, 0xbf, 0xf8, 0x40, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xe4, 0x0, 0xaf, 0xfb, 0xaf, 0xe8,
    0xff, 0xf2, 0x1f, 0xfb, 0x6, 0xfe, 0x3, 0xff,
    0x94, 0xff, 0x50, 0x6f, 0xe0, 0xd, 0xfc, 0x4f,
    0xf5, 0x6, 0xfe, 0x0, 0xdf, 0xc1, 0xff, 0xb0,
    0x6f, 0xe0, 0x3f, 0xf9, 0xa, 0xff, 0xba, 0xfe,
    0x7f, 0xff, 0x20, 0xa, 0xff, 0xff, 0xff, 0xfe,
    0x40, 0x0, 0x2, 0x7b, 0xff, 0x85, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xe0, 0x0, 0x0,

    /* U+0425 "Х" */
    0x4f, 0xfe, 0x0, 0x9, 0xff, 0x10, 0xaf, 0xf8,
    0x2, 0xff, 0x70, 0x1, 0xff, 0xf1, 0xbf, 0xd0,
    0x0, 0x8, 0xff, 0xcf, 0xf4, 0x0, 0x0, 0xe,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x6f, 0xff, 0x30,
    0x0, 0x0, 0xc, 0xff, 0xf9, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xf2, 0x0, 0x0, 0xef, 0x96, 0xff,
    0xb0, 0x0, 0x8f, 0xf1, 0xd, 0xff, 0x50, 0x2f,
    0xf8, 0x0, 0x5f, 0xfd, 0xa, 0xfe, 0x0, 0x0,
    0xcf, 0xf7,

    /* U+0426 "Ц" */
    0xbf, 0xf0, 0x0, 0x7f, 0xf4, 0xb, 0xff, 0x0,
    0x7, 0xff, 0x40, 0xbf, 0xf0, 0x0, 0x7f, 0xf4,
    0xb, 0xff, 0x0, 0x7, 0xff, 0x40, 0xbf, 0xf0,
    0x0, 0x7f, 0xf4, 0xb, 0xff, 0x0, 0x7, 0xff,
    0x40, 0xbf, 0xf0, 0x0, 0x7f, 0xf4, 0xb, 0xff,
    0x0, 0x7, 0xff, 0x40, 0xbf, 0xf0, 0x0, 0x7f,
    0xf4, 0xb, 0xff, 0x65, 0x5a, 0xff, 0x84, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xcb, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xc0,
    0x0, 0x0, 0x0, 0x3, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x18, 0x60,

    /* U+0427 "Ч" */
    0x1f, 0xfb, 0x0, 0xa, 0xff, 0x21, 0xff, 0xb0,
    0x0, 0xaf, 0xf2, 0x1f, 0xfb, 0x0, 0xa, 0xff,
    0x21, 0xff, 0xb0, 0x0, 0xaf, 0xf2, 0xf, 0xfb,
    0x0, 0xa, 0xff, 0x20, 0xff, 0xe2, 0x4, 0xdf,
    0xf2, 0xa, 0xff, 0xff, 0xff, 0xff, 0x20, 0x1b,
    0xff, 0xfc, 0xcf, 0xf2, 0x0, 0x1, 0x32, 0xa,
    0xff, 0x20, 0x0, 0x0, 0x0, 0xaf, 0xf2, 0x0,
    0x0, 0x0, 0xa, 0xff, 0x20, 0x0, 0x0, 0x0,
    0xaf, 0xf2,

    /* U+0428 "Ш" */
    0xbf, 0xf0, 0x0, 0xbf, 0xf0, 0x0, 0xcf, 0xfb,
    0xff, 0x0, 0xb, 0xff, 0x0, 0xc, 0xff, 0xbf,
    0xf0, 0x0, 0xbf, 0xf0, 0x0, 0xcf, 0xfb, 0xff,
    0x0, 0xb, 0xff, 0x0, 0xc, 0xff, 0xbf, 0xf0,
    0x0, 0xbf, 0xf0, 0x0, 0xcf, 0xfb, 0xff, 0x0,
    0xb, 0xff, 0x0, 0xc, 0xff, 0xbf, 0xf0, 0x0,
    0xbf, 0xf0, 0x0, 0xcf, 0xfb, 0xff, 0x0, 0xb,
    0xff, 0x0, 0xc, 0xff, 0xbf, 0xf0, 0x0, 0xbf,
    0xf0, 0x0, 0xcf, 0xfb, 0xff, 0x65, 0x5d, 0xff,
    0x65, 0x5d, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff,

    /* U+0429 "Щ" */
    0xbf, 0xf0, 0x0, 0xbf, 0xf0, 0x0, 0xcf, 0xf0,
    0xb, 0xff, 0x0, 0xb, 0xff, 0x0, 0xc, 0xff,
    0x0, 0xbf, 0xf0, 0x0, 0xbf, 0xf0, 0x0, 0xcf,
    0xf0, 0xb, 0xff, 0x0, 0xb, 0xff, 0x0, 0xc,
    0xff, 0x0, 0xbf, 0xf0, 0x0, 0xbf, 0xf0, 0x0,
    0xcf, 0xf0, 0xb, 0xff, 0x0, 0xb, 0xff, 0x0,
    0xc, 0xff, 0x0, 0xbf, 0xf0, 0x0, 0xbf, 0xf0,
    0x0, 0xcf, 0xf0, 0xb, 0xff, 0x0, 0xb, 0xff,
    0x0, 0xc, 0xff, 0x0, 0xbf, 0xf0, 0x0, 0xbf,
    0xf0, 0x0, 0xcf, 0xf0, 0xb, 0xff, 0x65, 0x5d,
    0xff, 0x65, 0x5d, 0xff, 0x52, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8b, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x28, 0x40,

    /* U+042A "Ъ" */
    0x7f, 0xff, 0xff, 0x20, 0x0, 0x0, 0x7, 0xff,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0x25, 0x5c, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xff, 0x42, 0x21, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xfe, 0x50, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0xaf,
    0xf2, 0x0, 0x7f, 0xf9, 0x0, 0xa, 0xff, 0x20,
    0x2, 0xff, 0xb0, 0x0, 0xaf, 0xf5, 0x44, 0xbf,
    0xf9, 0x0, 0xa, 0xff, 0xff, 0xff, 0xfe, 0x20,
    0x0, 0xaf, 0xff, 0xff, 0xea, 0x20,

    /* U+042B "Ы" */
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x1f, 0xfa, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x1f, 0xfa, 0xbf, 0xf0,
    0x0, 0x0, 0x0, 0x1f, 0xfa, 0xbf, 0xf0, 0x0,
    0x0, 0x0, 0x1f, 0xfa, 0xbf, 0xf3, 0x22, 0x10,
    0x0, 0x1f, 0xfa, 0xbf, 0xff, 0xff, 0xfd, 0x40,
    0x1f, 0xfa, 0xbf, 0xff, 0xff, 0xff, 0xf2, 0x1f,
    0xfa, 0xbf, 0xf0, 0x0, 0x8f, 0xf8, 0x1f, 0xfa,
    0xbf, 0xf0, 0x0, 0x3f, 0xfa, 0x1f, 0xfa, 0xbf,
    0xf4, 0x44, 0xbf, 0xf7, 0x1f, 0xfa, 0xbf, 0xff,
    0xff, 0xff, 0xe1, 0x1f, 0xfa, 0xbf, 0xff, 0xff,
    0xea, 0x10, 0x1f, 0xfa,

    /* U+042C "Ь" */
    0xcf, 0xf0, 0x0, 0x0, 0x0, 0xcf, 0xf0, 0x0,
    0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0, 0x0, 0xcf,
    0xf0, 0x0, 0x0, 0x0, 0xcf, 0xf2, 0x22, 0x10,
    0x0, 0xcf, 0xff, 0xff, 0xfd, 0x30, 0xcf, 0xff,
    0xff, 0xff, 0xf1, 0xcf, 0xf0, 0x0, 0xaf, 0xf7,
    0xcf, 0xf0, 0x0, 0x5f, 0xf8, 0xcf, 0xf4, 0x45,
    0xcf, 0xf6, 0xcf, 0xff, 0xff, 0xff, 0xd0, 0xcf,
    0xff, 0xff, 0xe9, 0x10,

    /* U+042D "Э" */
    0x0, 0x3a, 0xef, 0xea, 0x20, 0x0, 0x5f, 0xff,
    0xff, 0xff, 0x40, 0x1f, 0xff, 0x75, 0x8f, 0xfe,
    0x1, 0x8c, 0x40, 0x0, 0x7f, 0xf6, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xa0, 0x0, 0x3f, 0xff, 0xff,
    0xfc, 0x0, 0x3, 0xff, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x1f, 0xfa, 0x6c, 0xe2, 0x0, 0x7,
    0xff, 0x53, 0xff, 0xd6, 0x59, 0xff, 0xd0, 0x6,
    0xff, 0xff, 0xff, 0xe3, 0x0, 0x4, 0xbe, 0xfd,
    0x92, 0x0,

    /* U+042E "Ю" */
    0xcf, 0xf0, 0x0, 0x4, 0xbe, 0xfd, 0x70, 0x0,
    0xcf, 0xf0, 0x0, 0x7f, 0xff, 0xff, 0xfd, 0x10,
    0xcf, 0xf0, 0x3, 0xff, 0xd4, 0x29, 0xff, 0xb0,
    0xcf, 0xf0, 0xb, 0xff, 0x40, 0x0, 0xdf, 0xf2,
    0xcf, 0xf2, 0x2f, 0xfe, 0x0, 0x0, 0x8f, 0xf7,
    0xcf, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x6f, 0xf9,
    0xcf, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x6f, 0xf9,
    0xcf, 0xf0, 0xf, 0xfe, 0x0, 0x0, 0x8f, 0xf7,
    0xcf, 0xf0, 0xc, 0xff, 0x30, 0x0, 0xef, 0xf2,
    0xcf, 0xf0, 0x5, 0xff, 0xd3, 0x2a, 0xff, 0xa0,
    0xcf, 0xf0, 0x0, 0x8f, 0xff, 0xff, 0xfd, 0x10,
    0xcf, 0xf0, 0x0, 0x5, 0xbf, 0xfd, 0x80, 0x0,

    /* U+042F "Я" */
    0x0, 0x5c, 0xff, 0xff, 0xff, 0xa0, 0x5f, 0xff,
    0xff, 0xff, 0xfa, 0xd, 0xff, 0x72, 0x24, 0xff,
    0xa0, 0xff, 0xe0, 0x0, 0x3f, 0xfa, 0xd, 0xff,
    0x50, 0x3, 0xff, 0xa0, 0x4f, 0xff, 0xff, 0xff,
    0xfa, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xa0, 0x6,
    0xff, 0x40, 0x3f, 0xfa, 0x0, 0xdf, 0xd0, 0x3,
    0xff, 0xa0, 0x5f, 0xf7, 0x0, 0x3f, 0xfa, 0xd,
    0xff, 0x10, 0x3, 0xff, 0xa4, 0xff, 0xa0, 0x0,
    0x3f, 0xfa,

    /* U+0430 "а" */
    0x0, 0x7c, 0xfe, 0xc6, 0x0, 0xaf, 0xfc, 0xef,
    0xf5, 0xd, 0xe6, 0x1, 0xff, 0x90, 0x0, 0x35,
    0x7f, 0xfa, 0x5, 0xef, 0xfe, 0xff, 0xa3, 0xff,
    0xc2, 0xf, 0xfa, 0x6f, 0xf5, 0x2, 0xff, 0xa3,
    0xff, 0xd7, 0xdf, 0xfa, 0x6, 0xef, 0xd4, 0xcf,
    0xb0,

    /* U+0431 "б" */
    0x0, 0x0, 0x6, 0xff, 0x70, 0x0, 0x1a, 0xff,
    0xfa, 0x0, 0x0, 0xdf, 0xb5, 0x10, 0x0, 0x8,
    0xf9, 0x0, 0x0, 0x0, 0xe, 0xfa, 0xef, 0xd6,
    0x0, 0x2f, 0xff, 0xdd, 0xff, 0x80, 0x4f, 0xfb,
    0x0, 0xbf, 0xf1, 0x5f, 0xf5, 0x0, 0x6f, 0xf5,
    0x4f, 0xf4, 0x0, 0x5f, 0xf6, 0x3f, 0xf5, 0x0,
    0x6f, 0xf5, 0xe, 0xfb, 0x0, 0xbf, 0xf1, 0x5,
    0xff, 0xdd, 0xff, 0x60, 0x0, 0x4c, 0xff, 0xc5,
    0x0,

    /* U+0432 "в" */
    0xef, 0xff, 0xff, 0xc3, 0xe, 0xfe, 0xaa, 0xff,
    0xd0, 0xef, 0xb0, 0x7, 0xff, 0xe, 0xfb, 0x0,
    0xaf, 0xb0, 0xef, 0xff, 0xff, 0xb0, 0xe, 0xfc,
    0x33, 0xaf, 0xc0, 0xef, 0xb0, 0x6, 0xff, 0x4e,
    0xfe, 0xcc, 0xff, 0xf2, 0xef, 0xff, 0xff, 0xd5,
    0x0,

    /* U+0433 "г" */
    0xef, 0xff, 0xfe, 0xef, 0xfe, 0xed, 0xef, 0xb0,
    0x0, 0xef, 0xb0, 0x0, 0xef, 0xb0, 0x0, 0xef,
    0xb0, 0x0, 0xef, 0xb0, 0x0, 0xef, 0xb0, 0x0,
    0xef, 0xb0, 0x0,

    /* U+0434 "д" */
    0x0, 0x2, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x7f,
    0xef, 0xf0, 0x0, 0x0, 0xb, 0xf5, 0xff, 0x30,
    0x0, 0x0, 0xfd, 0xf, 0xf7, 0x0, 0x0, 0x4f,
    0x90, 0xdf, 0xb0, 0x0, 0x9, 0xf5, 0xa, 0xfe,
    0x0, 0x0, 0xdf, 0x10, 0x7f, 0xf2, 0x1, 0xdf,
    0xfd, 0xde, 0xff, 0xe5, 0x2f, 0xff, 0xff, 0xff,
    0xff, 0x62, 0xfa, 0x0, 0x0, 0x6, 0xf6, 0x2f,
    0x80, 0x0, 0x0, 0x4f, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+0435 "е" */
    0x0, 0x4c, 0xfe, 0xa2, 0x0, 0x6, 0xff, 0xcd,
    0xfe, 0x10, 0xf, 0xfa, 0x0, 0xcf, 0x90, 0x4f,
    0xfb, 0x88, 0xcf, 0xe0, 0x6f, 0xff, 0xff, 0xff,
    0xf0, 0x5f, 0xf5, 0x0, 0x1, 0x0, 0xf, 0xfb,
    0x0, 0xaf, 0xc0, 0x6, 0xff, 0xfe, 0xff, 0x30,
    0x0, 0x5c, 0xfe, 0xb3, 0x0,

    /* U+0436 "ж" */
    0xa, 0xfe, 0x0, 0xdf, 0xc0, 0x1e, 0xf8, 0x0,
    0x1e, 0xf9, 0xd, 0xfc, 0xa, 0xfc, 0x0, 0x0,
    0x5f, 0xf4, 0xdf, 0xc5, 0xfe, 0x10, 0x0, 0x0,
    0xaf, 0xee, 0xfe, 0xef, 0x50, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0xef,
    0x6d, 0xfd, 0x6f, 0xf4, 0x0, 0x0, 0x9f, 0xb0,
    0xdf, 0xc0, 0xcf, 0xd0, 0x0, 0x3f, 0xf2, 0xd,
    0xfc, 0x3, 0xff, 0x70, 0xd, 0xf8, 0x0, 0xdf,
    0xc0, 0xa, 0xff, 0x10,

    /* U+0437 "з" */
    0x3, 0xbe, 0xfe, 0x91, 0x3, 0xff, 0xed, 0xff,
    0xa0, 0x38, 0x90, 0xc, 0xfd, 0x0, 0x0, 0x6a,
    0xfe, 0x50, 0x0, 0xb, 0xff, 0xd5, 0x0, 0x0,
    0x1, 0xcf, 0xf1, 0x7d, 0xd0, 0xa, 0xff, 0x23,
    0xff, 0xdc, 0xff, 0xc0, 0x4, 0xcf, 0xfd, 0x91,
    0x0,

    /* U+0438 "и" */
    0xef, 0xb0, 0x7, 0xff, 0x2e, 0xfb, 0x0, 0xbf,
    0xf2, 0xef, 0xb0, 0x6f, 0xff, 0x2e, 0xfb, 0x2f,
    0xff, 0xf2, 0xef, 0xac, 0xf9, 0xff, 0x2e, 0xff,
    0xf8, 0x7f, 0xf2, 0xef, 0xfc, 0x7, 0xff, 0x2e,
    0xff, 0x20, 0x7f, 0xf2, 0xef, 0xb0, 0x7, 0xff,
    0x20,

    /* U+0439 "й" */
    0x8, 0xe1, 0xb, 0xc0, 0x0, 0x1e, 0xff, 0xf3,
    0x0, 0x0, 0x4, 0x41, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xb0, 0x7, 0xff, 0x2e, 0xfb,
    0x0, 0xbf, 0xf2, 0xef, 0xb0, 0x6f, 0xff, 0x2e,
    0xfb, 0x2f, 0xff, 0xf2, 0xef, 0xac, 0xf9, 0xff,
    0x2e, 0xff, 0xf8, 0x7f, 0xf2, 0xef, 0xfc, 0x7,
    0xff, 0x2e, 0xff, 0x20, 0x7f, 0xf2, 0xef, 0xb0,
    0x7, 0xff, 0x20,

    /* U+043A "к" */
    0xef, 0xb0, 0x5, 0xfe, 0x2e, 0xfb, 0x4, 0xff,
    0x30, 0xef, 0xb3, 0xff, 0x50, 0xe, 0xfc, 0xef,
    0xe0, 0x0, 0xef, 0xff, 0xff, 0x80, 0xe, 0xff,
    0x8b, 0xff, 0x10, 0xef, 0xc0, 0x3f, 0xf8, 0xe,
    0xfb, 0x0, 0xaf, 0xf1, 0xef, 0xb0, 0x2, 0xff,
    0x90,

    /* U+043B "л" */
    0x0, 0x6, 0xff, 0xc0, 0x0, 0x0, 0xb, 0xff,
    0xf1, 0x0, 0x0, 0x1f, 0xef, 0xf6, 0x0, 0x0,
    0x6f, 0x8d, 0xfb, 0x0, 0x0, 0xbf, 0x39, 0xff,
    0x0, 0x1, 0xfe, 0x4, 0xff, 0x40, 0x6, 0xf9,
    0x0, 0xff, 0x90, 0xb, 0xf3, 0x0, 0xcf, 0xe0,
    0x1f, 0xe0, 0x0, 0x7f, 0xf3,

    /* U+043C "м" */
    0xef, 0xff, 0x0, 0x5, 0xff, 0xf5, 0xef, 0xff,
    0x40, 0x9, 0xff, 0xf5, 0xef, 0xaf, 0x80, 0xe,
    0xaf, 0xf5, 0xef, 0x6f, 0xc0, 0x2f, 0x6f, 0xf5,
    0xef, 0x2f, 0xf1, 0x7f, 0x1f, 0xf5, 0xef, 0x1b,
    0xf5, 0xbc, 0xf, 0xf5, 0xef, 0x17, 0xfa, 0xf8,
    0xf, 0xf5, 0xef, 0x12, 0xff, 0xf3, 0xf, 0xf5,
    0xef, 0x10, 0xef, 0xf0, 0xf, 0xf5,

    /* U+043D "н" */
    0xef, 0xb0, 0x9, 0xff, 0xe, 0xfb, 0x0, 0x9f,
    0xf0, 0xef, 0xb0, 0x9, 0xff, 0xe, 0xff, 0xee,
    0xff, 0xf0, 0xef, 0xff, 0xff, 0xff, 0xe, 0xfb,
    0x0, 0x9f, 0xf0, 0xef, 0xb0, 0x9, 0xff, 0xe,
    0xfb, 0x0, 0x9f, 0xf0, 0xef, 0xb0, 0x9, 0xff,
    0x0,

    /* U+043E "о" */
    0x0, 0x5c, 0xfe, 0xa2, 0x0, 0x7, 0xff, 0xce,
    0xfe, 0x20, 0x1f, 0xfa, 0x1, 0xff, 0xa0, 0x5f,
    0xf6, 0x0, 0xbf, 0xf0, 0x6f, 0xf5, 0x0, 0xbf,
    0xf0, 0x5f, 0xf6, 0x0, 0xbf, 0xf0, 0x1f, 0xfb,
    0x1, 0xff, 0xa0, 0x7, 0xff, 0xce, 0xfe, 0x20,
    0x0, 0x5d, 0xfe, 0xa2, 0x0,

    /* U+043F "п" */
    0xef, 0xff, 0xff, 0xfb, 0xef, 0xec, 0xcf, 0xfb,
    0xef, 0xb0, 0xe, 0xfb, 0xef, 0xb0, 0xe, 0xfb,
    0xef, 0xb0, 0xe, 0xfb, 0xef, 0xb0, 0xe, 0xfb,
    0xef, 0xb0, 0xe, 0xfb, 0xef, 0xb0, 0xe, 0xfb,
    0xef, 0xb0, 0xe, 0xfb,

    /* U+0440 "р" */
    0xef, 0x8a, 0xfe, 0x70, 0xe, 0xff, 0xcc, 0xff,
    0x60, 0xef, 0xd0, 0xd, 0xfd, 0xe, 0xfa, 0x0,
    0xaf, 0xf0, 0xef, 0xa0, 0x9, 0xff, 0x1e, 0xfa,
    0x0, 0xaf, 0xf0, 0xef, 0xd0, 0x1e, 0xfd, 0xe,
    0xff, 0xef, 0xff, 0x60, 0xef, 0xaa, 0xfe, 0x70,
    0xe, 0xfa, 0x0, 0x0, 0x0, 0xef, 0xa0, 0x0,
    0x0, 0xe, 0xfa, 0x0, 0x0, 0x0,

    /* U+0441 "с" */
    0x0, 0x4c, 0xfe, 0xb2, 0x0, 0x6f, 0xff, 0xff,
    0xf2, 0xf, 0xfe, 0x21, 0xdf, 0xa4, 0xff, 0x90,
    0x3, 0x65, 0x6f, 0xf8, 0x0, 0x0, 0x5, 0xff,
    0x90, 0x5, 0x86, 0x1f, 0xfe, 0x33, 0xef, 0x90,
    0x7f, 0xff, 0xff, 0xe1, 0x0, 0x5c, 0xfe, 0xa2,
    0x0,

    /* U+0442 "т" */
    0x2f, 0xff, 0xff, 0xff, 0x42, 0xee, 0xff, 0xfe,
    0xe3, 0x0, 0xb, 0xfe, 0x0, 0x0, 0x0, 0xbf,
    0xe0, 0x0, 0x0, 0xb, 0xfe, 0x0, 0x0, 0x0,
    0xbf, 0xe0, 0x0, 0x0, 0xb, 0xfe, 0x0, 0x0,
    0x0, 0xbf, 0xe0, 0x0, 0x0, 0xb, 0xfe, 0x0,
    0x0,

    /* U+0443 "у" */
    0xe, 0xfd, 0x0, 0x1f, 0xc0, 0x8f, 0xf2, 0x6,
    0xf7, 0x2, 0xff, 0x80, 0xbf, 0x20, 0xc, 0xfd,
    0xf, 0xc0, 0x0, 0x6f, 0xf7, 0xf7, 0x0, 0x1,
    0xff, 0xff, 0x20, 0x0, 0xb, 0xff, 0xd0, 0x0,
    0x0, 0x5f, 0xf8, 0x0, 0x0, 0x0, 0xff, 0x20,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x8, 0xff, 0xf6,
    0x0, 0x0, 0x8f, 0xe8, 0x0, 0x0,

    /* U+0444 "ф" */
    0x0, 0x0, 0xc, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x80, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xf8, 0x0, 0x0, 0x0, 0x2, 0x9e, 0xff, 0xfd,
    0x80, 0x0, 0x3, 0xff, 0xdd, 0xfc, 0xef, 0xd1,
    0x0, 0xef, 0xc0, 0xbf, 0x71, 0xff, 0xa0, 0x3f,
    0xf6, 0xb, 0xf7, 0xa, 0xff, 0x5, 0xff, 0x40,
    0xbf, 0x70, 0x8f, 0xf1, 0x4f, 0xf6, 0xb, 0xf7,
    0xa, 0xff, 0x0, 0xef, 0xc0, 0xbf, 0x71, 0xff,
    0xb0, 0x5, 0xff, 0xdd, 0xfc, 0xef, 0xe2, 0x0,
    0x3, 0xbf, 0xff, 0xfe, 0x91, 0x0, 0x0, 0x0,
    0xc, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x80, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf8, 0x0,
    0x0, 0x0,

    /* U+0445 "х" */
    0x4f, 0xfa, 0x1, 0xff, 0x20, 0xbf, 0xf4, 0xaf,
    0x80, 0x1, 0xff, 0xef, 0xd0, 0x0, 0x7, 0xff,
    0xf4, 0x0, 0x0, 0x4f, 0xff, 0x20, 0x0, 0xd,
    0xff, 0xfb, 0x0, 0x7, 0xfb, 0x9f, 0xf5, 0x2,
    0xff, 0x21, 0xef, 0xe0, 0xbf, 0x80, 0x6, 0xff,
    0x90,

    /* U+0446 "ц" */
    0xef, 0xb0, 0xb, 0xfe, 0x0, 0xef, 0xb0, 0xb,
    0xfe, 0x0, 0xef, 0xb0, 0xb, 0xfe, 0x0, 0xef,
    0xb0, 0xb, 0xfe, 0x0, 0xef, 0xb0, 0xb, 0xfe,
    0x0, 0xef, 0xb0, 0xb, 0xfe, 0x0, 0xef, 0xb0,
    0xb, 0xfe, 0x0, 0xef, 0xfe, 0xef, 0xff, 0xe2,
    0xef, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0xa, 0xf2, 0x0, 0x0, 0x0, 0x8, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+0447 "ч" */
    0x2f, 0xf7, 0x2, 0xff, 0x72, 0xff, 0x70, 0x2f,
    0xf7, 0x2f, 0xf7, 0x2, 0xff, 0x72, 0xff, 0x70,
    0x2f, 0xf7, 0x1f, 0xfa, 0x5, 0xff, 0x70, 0xcf,
    0xff, 0xff, 0xf7, 0x1, 0x8b, 0x95, 0xff, 0x70,
    0x0, 0x0, 0x2f, 0xf7, 0x0, 0x0, 0x2, 0xff,
    0x70,

    /* U+0448 "ш" */
    0xdf, 0xc0, 0xe, 0xfb, 0x0, 0xef, 0xbd, 0xfc,
    0x0, 0xef, 0xb0, 0xe, 0xfb, 0xdf, 0xc0, 0xe,
    0xfb, 0x0, 0xef, 0xbd, 0xfc, 0x0, 0xef, 0xb0,
    0xe, 0xfb, 0xdf, 0xc0, 0xe, 0xfb, 0x0, 0xef,
    0xbd, 0xfc, 0x0, 0xef, 0xb0, 0xe, 0xfb, 0xdf,
    0xc0, 0xe, 0xfb, 0x0, 0xef, 0xbd, 0xff, 0xee,
    0xff, 0xfe, 0xef, 0xfb, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb0,

    /* U+0449 "щ" */
    0xdf, 0xc0, 0xe, 0xfb, 0x0, 0xef, 0xb0, 0xd,
    0xfc, 0x0, 0xef, 0xb0, 0xe, 0xfb, 0x0, 0xdf,
    0xc0, 0xe, 0xfb, 0x0, 0xef, 0xb0, 0xd, 0xfc,
    0x0, 0xef, 0xb0, 0xe, 0xfb, 0x0, 0xdf, 0xc0,
    0xe, 0xfb, 0x0, 0xef, 0xb0, 0xd, 0xfc, 0x0,
    0xef, 0xb0, 0xe, 0xfb, 0x0, 0xdf, 0xc0, 0xe,
    0xfb, 0x0, 0xef, 0xb0, 0xd, 0xff, 0xee, 0xff,
    0xfe, 0xef, 0xff, 0xe1, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+044A "ъ" */
    0x7f, 0xff, 0xf8, 0x0, 0x0, 0x6, 0xee, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x1f, 0xf8, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xda, 0xa8, 0x20, 0x0, 0x1f,
    0xff, 0xff, 0xff, 0x30, 0x1, 0xff, 0x80, 0x1d,
    0xf9, 0x0, 0x1f, 0xf8, 0x0, 0xcf, 0xa0, 0x1,
    0xff, 0xec, 0xdf, 0xf6, 0x0, 0x1f, 0xff, 0xff,
    0xd7, 0x0,

    /* U+044B "ы" */
    0xdf, 0xc0, 0x0, 0x0, 0xf, 0xfa, 0xdf, 0xc0,
    0x0, 0x0, 0xf, 0xfa, 0xdf, 0xc0, 0x0, 0x0,
    0xf, 0xfa, 0xdf, 0xea, 0xa8, 0x40, 0xf, 0xfa,
    0xdf, 0xff, 0xff, 0xf6, 0xf, 0xfa, 0xdf, 0xc0,
    0xb, 0xfd, 0xf, 0xfa, 0xdf, 0xc0, 0x8, 0xfe,
    0xf, 0xfa, 0xdf, 0xfc, 0xcf, 0xfa, 0xf, 0xfa,
    0xdf, 0xff, 0xfe, 0x91, 0xf, 0xfa,

    /* U+044C "ь" */
    0xef, 0xb0, 0x0, 0x0, 0xef, 0xb0, 0x0, 0x0,
    0xef, 0xb0, 0x0, 0x0, 0xef, 0xea, 0xa8, 0x30,
    0xef, 0xff, 0xff, 0xf5, 0xef, 0xb0, 0xb, 0xfc,
    0xef, 0xb0, 0x9, 0xfd, 0xef, 0xec, 0xcf, 0xf9,
    0xef, 0xff, 0xfe, 0x90,

    /* U+044D "э" */
    0x2, 0xae, 0xfd, 0x80, 0x2, 0xff, 0xec, 0xff,
    0xc0, 0x38, 0x90, 0x4, 0xff, 0x60, 0x4, 0xaa,
    0xaf, 0xfb, 0x0, 0x6f, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0xf, 0xfb, 0x7d, 0xd0, 0x5, 0xff, 0x62,
    0xff, 0xec, 0xff, 0xc0, 0x3, 0xbe, 0xfd, 0x80,
    0x0,

    /* U+044E "ю" */
    0xef, 0xb0, 0x1, 0x8d, 0xfe, 0xa2, 0x0, 0xef,
    0xb0, 0x1d, 0xfe, 0x9d, 0xfe, 0x20, 0xef, 0xb0,
    0x8f, 0xf2, 0x0, 0xff, 0xb0, 0xef, 0xfc, 0xff,
    0xd0, 0x0, 0xbf, 0xf0, 0xef, 0xff, 0xff, 0xc0,
    0x0, 0xaf, 0xf1, 0xef, 0xb0, 0xbf, 0xd0, 0x0,
    0xbf, 0xf0, 0xef, 0xb0, 0x6f, 0xf2, 0x0, 0xff,
    0xb0, 0xef, 0xb0, 0xb, 0xfe, 0x9d, 0xfe, 0x20,
    0xef, 0xb0, 0x0, 0x8d, 0xfe, 0xa1, 0x0,

    /* U+044F "я" */
    0x3, 0xcf, 0xff, 0xff, 0x90, 0xef, 0xea, 0xaf,
    0xf9, 0x3f, 0xf4, 0x0, 0xff, 0x93, 0xff, 0x60,
    0xf, 0xf9, 0xa, 0xff, 0xff, 0xff, 0x90, 0xe,
    0xfb, 0xbf, 0xf9, 0x7, 0xfd, 0x1, 0xff, 0x90,
    0xef, 0x60, 0x1f, 0xf9, 0x8f, 0xe0, 0x1, 0xff,
    0x90,

    /* U+0451 "ё" */
    0x0, 0x5f, 0x55, 0xf4, 0x0, 0x0, 0x5f, 0x66,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4c, 0xfe, 0xa2, 0x0, 0x6, 0xff, 0xcd, 0xfe,
    0x10, 0xf, 0xfa, 0x0, 0xcf, 0x90, 0x4f, 0xfb,
    0x88, 0xcf, 0xe0, 0x6f, 0xff, 0xff, 0xff, 0xf0,
    0x5f, 0xf5, 0x0, 0x1, 0x0, 0xf, 0xfb, 0x0,
    0xaf, 0xc0, 0x6, 0xff, 0xfe, 0xff, 0x30, 0x0,
    0x5c, 0xfe, 0xb3, 0x0,

    /* U+2022 "•" */
    0x6, 0xee, 0x60, 0x3f, 0xff, 0xf3, 0x6f, 0xff,
    0xf6, 0x3f, 0xff, 0xf3, 0x6, 0xee, 0x60
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 72, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 85, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 30, .adv_w = 107, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 45, .adv_w = 169, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 105, .adv_w = 169, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 180, .adv_w = 199, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 252, .adv_w = 207, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 330, .adv_w = 56, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 338, .adv_w = 85, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 376, .adv_w = 85, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 414, .adv_w = 169, .box_w = 9, .box_h = 8, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 450, .adv_w = 169, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 500, .adv_w = 74, .box_w = 4, .box_h = 6, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 512, .adv_w = 74, .box_w = 5, .box_h = 2, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 517, .adv_w = 74, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 523, .adv_w = 154, .box_w = 12, .box_h = 15, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 613, .adv_w = 169, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 673, .adv_w = 169, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 739, .adv_w = 169, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 799, .adv_w = 169, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 859, .adv_w = 169, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 925, .adv_w = 169, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 991, .adv_w = 169, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1051, .adv_w = 169, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1105, .adv_w = 169, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1171, .adv_w = 169, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1231, .adv_w = 74, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1249, .adv_w = 74, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1273, .adv_w = 169, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1317, .adv_w = 169, .box_w = 10, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 1342, .adv_w = 169, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1392, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1446, .adv_w = 224, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1530, .adv_w = 175, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1596, .adv_w = 188, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1662, .adv_w = 181, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1728, .adv_w = 187, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1794, .adv_w = 164, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1848, .adv_w = 160, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1902, .adv_w = 185, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1968, .adv_w = 187, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2028, .adv_w = 83, .box_w = 4, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2052, .adv_w = 110, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2088, .adv_w = 182, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2154, .adv_w = 145, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2202, .adv_w = 248, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2286, .adv_w = 186, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2346, .adv_w = 184, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2412, .adv_w = 174, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2472, .adv_w = 185, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2555, .adv_w = 189, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2615, .adv_w = 167, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2675, .adv_w = 141, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2729, .adv_w = 187, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2789, .adv_w = 160, .box_w = 12, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2861, .adv_w = 251, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2957, .adv_w = 173, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3023, .adv_w = 150, .box_w = 11, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3089, .adv_w = 167, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3155, .adv_w = 85, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3193, .adv_w = 154, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3276, .adv_w = 85, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3314, .adv_w = 144, .box_w = 9, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 3341, .adv_w = 144, .box_w = 9, .box_h = 3, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3355, .adv_w = 144, .box_w = 5, .box_h = 4, .ofs_x = 2, .ofs_y = 10},
    {.bitmap_index = 3365, .adv_w = 156, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3406, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3460, .adv_w = 147, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3501, .adv_w = 155, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3555, .adv_w = 154, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3600, .adv_w = 92, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3636, .adv_w = 159, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3706, .adv_w = 157, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3754, .adv_w = 76, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3772, .adv_w = 77, .box_w = 5, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 3810, .adv_w = 156, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3864, .adv_w = 76, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3882, .adv_w = 237, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3941, .adv_w = 158, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3977, .adv_w = 154, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4022, .adv_w = 155, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4076, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4130, .adv_w = 100, .box_w = 5, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4155, .adv_w = 136, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4196, .adv_w = 101, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4238, .adv_w = 156, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4274, .adv_w = 130, .box_w = 10, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4319, .adv_w = 208, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4378, .adv_w = 142, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4419, .adv_w = 128, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 4473, .adv_w = 123, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4509, .adv_w = 85, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4547, .adv_w = 144, .box_w = 3, .box_h = 15, .ofs_x = 3, .ofs_y = -3},
    {.bitmap_index = 4570, .adv_w = 85, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4608, .adv_w = 169, .box_w = 10, .box_h = 5, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 4633, .adv_w = 169, .box_w = 6, .box_h = 7, .ofs_x = 2, .ofs_y = 6},
    {.bitmap_index = 4654, .adv_w = 175, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4720, .adv_w = 178, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4780, .adv_w = 188, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4846, .adv_w = 129, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4894, .adv_w = 177, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 4992, .adv_w = 164, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5046, .adv_w = 249, .box_w = 18, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5154, .adv_w = 169, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5214, .adv_w = 192, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5274, .adv_w = 193, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5354, .adv_w = 182, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5420, .adv_w = 162, .box_w = 12, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5492, .adv_w = 247, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5576, .adv_w = 187, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5636, .adv_w = 184, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5702, .adv_w = 181, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5762, .adv_w = 174, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5822, .adv_w = 181, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5888, .adv_w = 141, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5942, .adv_w = 153, .box_w = 11, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6008, .adv_w = 216, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6086, .adv_w = 173, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6152, .adv_w = 187, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 6235, .adv_w = 181, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6301, .adv_w = 277, .box_w = 15, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6391, .adv_w = 279, .box_w = 17, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 6519, .adv_w = 193, .box_w = 13, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6597, .adv_w = 255, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6681, .adv_w = 174, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6741, .adv_w = 183, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6807, .adv_w = 276, .box_w = 16, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6903, .adv_w = 189, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6969, .adv_w = 156, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7010, .adv_w = 161, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7075, .adv_w = 158, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7116, .adv_w = 112, .box_w = 6, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7143, .adv_w = 148, .box_w = 11, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 7209, .adv_w = 154, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7254, .adv_w = 207, .box_w = 15, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7322, .adv_w = 141, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7363, .adv_w = 164, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7404, .adv_w = 164, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7463, .adv_w = 152, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7504, .adv_w = 131, .box_w = 10, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7549, .adv_w = 215, .box_w = 12, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7603, .adv_w = 162, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7644, .adv_w = 154, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7689, .adv_w = 157, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7725, .adv_w = 155, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 7779, .adv_w = 147, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7820, .adv_w = 113, .box_w = 9, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7861, .adv_w = 128, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 7915, .adv_w = 204, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8013, .adv_w = 142, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8054, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 8114, .adv_w = 153, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8155, .adv_w = 237, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8214, .adv_w = 240, .box_w = 15, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 8304, .adv_w = 161, .box_w = 11, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8354, .adv_w = 220, .box_w = 12, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8408, .adv_w = 148, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8444, .adv_w = 150, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8485, .adv_w = 235, .box_w = 14, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8548, .adv_w = 154, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8589, .adv_w = 154, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8649, .adv_w = 192, .box_w = 6, .box_h = 5, .ofs_x = 3, .ofs_y = 4}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_3[] = {
    0x0, 0x1bd1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 176, .range_length = 1, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1040, .range_length = 64, .glyph_id_start = 97,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1105, .range_length = 7122, .glyph_id_start = 161,
        .unicode_list = unicode_list_3, .glyph_id_ofs_list = NULL, .list_length = 2, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Pair left and right glyphs for kerning*/
static const uint8_t kern_pair_glyph_ids[] =
{
    13, 18,
    14, 34,
    14, 53,
    14, 56,
    14, 58,
    14, 97,
    14, 115,
    14, 116,
    14, 147,
    14, 148,
    15, 18,
    17, 18,
    17, 21,
    17, 24,
    18, 13,
    18, 15,
    18, 17,
    18, 18,
    18, 19,
    18, 20,
    18, 21,
    18, 22,
    18, 23,
    18, 24,
    18, 25,
    19, 18,
    19, 21,
    19, 24,
    20, 18,
    20, 24,
    21, 18,
    21, 21,
    21, 24,
    22, 18,
    22, 21,
    22, 24,
    23, 18,
    23, 21,
    24, 15,
    24, 18,
    24, 21,
    24, 23,
    24, 24,
    24, 27,
    25, 18,
    25, 21,
    25, 24,
    26, 18,
    26, 24,
    34, 13,
    34, 14,
    34, 15,
    34, 36,
    34, 40,
    34, 48,
    34, 50,
    34, 53,
    34, 54,
    34, 55,
    34, 56,
    34, 58,
    34, 68,
    34, 70,
    34, 72,
    34, 80,
    34, 82,
    34, 85,
    34, 86,
    34, 87,
    34, 88,
    34, 90,
    35, 55,
    35, 56,
    35, 58,
    36, 34,
    37, 34,
    37, 43,
    37, 53,
    37, 55,
    37, 58,
    39, 13,
    39, 14,
    39, 15,
    39, 34,
    39, 43,
    39, 48,
    39, 66,
    39, 70,
    39, 80,
    39, 83,
    39, 86,
    40, 34,
    40, 53,
    40, 55,
    40, 56,
    40, 58,
    43, 34,
    44, 36,
    44, 40,
    44, 48,
    44, 53,
    44, 66,
    44, 70,
    44, 80,
    44, 86,
    44, 90,
    45, 14,
    45, 36,
    45, 40,
    45, 48,
    45, 53,
    45, 54,
    45, 55,
    45, 56,
    45, 58,
    45, 90,
    47, 13,
    47, 15,
    48, 34,
    48, 53,
    48, 55,
    48, 56,
    48, 57,
    48, 58,
    49, 13,
    49, 15,
    49, 34,
    49, 43,
    49, 66,
    49, 70,
    49, 80,
    51, 36,
    51, 40,
    51, 48,
    51, 54,
    51, 55,
    51, 56,
    51, 58,
    51, 70,
    51, 80,
    51, 86,
    51, 90,
    52, 34,
    52, 53,
    52, 55,
    52, 56,
    52, 58,
    52, 85,
    53, 13,
    53, 14,
    53, 15,
    53, 27,
    53, 28,
    53, 34,
    53, 36,
    53, 40,
    53, 43,
    53, 52,
    53, 55,
    53, 56,
    53, 58,
    53, 66,
    53, 68,
    53, 70,
    53, 72,
    53, 80,
    53, 83,
    53, 84,
    53, 86,
    53, 87,
    53, 88,
    53, 90,
    54, 34,
    54, 78,
    54, 79,
    54, 81,
    54, 83,
    55, 13,
    55, 15,
    55, 27,
    55, 28,
    55, 34,
    55, 36,
    55, 40,
    55, 48,
    55, 53,
    55, 66,
    55, 70,
    55, 72,
    55, 80,
    55, 83,
    55, 86,
    55, 90,
    56, 13,
    56, 14,
    56, 15,
    56, 27,
    56, 34,
    56, 36,
    56, 40,
    56, 48,
    56, 52,
    56, 53,
    56, 66,
    56, 70,
    56, 72,
    56, 80,
    56, 83,
    56, 86,
    56, 90,
    57, 14,
    57, 36,
    57, 48,
    57, 50,
    57, 70,
    57, 80,
    57, 90,
    58, 13,
    58, 14,
    58, 15,
    58, 27,
    58, 28,
    58, 34,
    58, 36,
    58, 40,
    58, 48,
    58, 52,
    58, 53,
    58, 66,
    58, 70,
    58, 72,
    58, 80,
    58, 81,
    58, 86,
    66, 87,
    66, 88,
    66, 90,
    67, 87,
    67, 88,
    67, 90,
    68, 73,
    68, 76,
    70, 87,
    70, 88,
    70, 89,
    70, 90,
    71, 66,
    71, 70,
    71, 71,
    71, 80,
    71, 84,
    71, 85,
    73, 90,
    76, 13,
    76, 15,
    76, 70,
    76, 72,
    76, 80,
    76, 86,
    78, 87,
    78, 88,
    78, 90,
    79, 87,
    79, 88,
    79, 90,
    80, 87,
    80, 88,
    80, 89,
    80, 90,
    81, 85,
    81, 90,
    83, 13,
    83, 14,
    83, 15,
    83, 71,
    83, 73,
    83, 76,
    83, 81,
    83, 84,
    83, 85,
    83, 87,
    83, 88,
    83, 89,
    83, 90,
    84, 85,
    85, 27,
    85, 28,
    85, 66,
    85, 70,
    85, 80,
    87, 13,
    87, 14,
    87, 15,
    87, 27,
    87, 66,
    87, 68,
    87, 70,
    87, 72,
    87, 80,
    88, 13,
    88, 14,
    88, 15,
    88, 66,
    88, 68,
    88, 70,
    88, 72,
    88, 80,
    89, 66,
    89, 68,
    89, 70,
    89, 80,
    89, 82,
    90, 13,
    90, 14,
    90, 15,
    90, 27,
    90, 66,
    90, 68,
    90, 70,
    90, 72,
    90, 80,
    97, 13,
    97, 14,
    97, 15,
    97, 27,
    97, 28,
    97, 108,
    97, 111,
    97, 114,
    97, 115,
    97, 117,
    97, 120,
    97, 123,
    97, 136,
    97, 140,
    97, 143,
    97, 146,
    97, 147,
    97, 148,
    97, 149,
    97, 152,
    97, 155,
    98, 97,
    98, 103,
    98, 115,
    98, 116,
    98, 120,
    98, 121,
    98, 135,
    98, 147,
    98, 148,
    98, 155,
    99, 97,
    99, 103,
    99, 115,
    99, 116,
    99, 120,
    99, 135,
    99, 147,
    99, 148,
    99, 152,
    99, 155,
    100, 13,
    100, 14,
    100, 15,
    100, 27,
    100, 28,
    100, 101,
    100, 108,
    100, 115,
    100, 116,
    100, 117,
    100, 120,
    100, 129,
    100, 131,
    100, 133,
    100, 134,
    100, 135,
    100, 136,
    100, 137,
    100, 139,
    100, 140,
    100, 141,
    100, 142,
    100, 143,
    100, 144,
    100, 145,
    100, 146,
    100, 147,
    100, 148,
    100, 149,
    100, 150,
    100, 151,
    100, 152,
    100, 155,
    100, 159,
    100, 160,
    102, 117,
    103, 111,
    103, 114,
    103, 117,
    103, 129,
    103, 130,
    103, 134,
    103, 136,
    103, 143,
    103, 146,
    103, 147,
    103, 148,
    103, 149,
    103, 152,
    104, 97,
    104, 101,
    104, 103,
    104, 104,
    104, 108,
    104, 115,
    104, 116,
    104, 118,
    104, 120,
    104, 128,
    104, 147,
    104, 148,
    104, 150,
    104, 152,
    107, 104,
    107, 111,
    107, 114,
    107, 117,
    107, 129,
    107, 130,
    107, 134,
    107, 136,
    107, 143,
    107, 146,
    107, 147,
    107, 148,
    107, 149,
    107, 152,
    111, 97,
    111, 103,
    111, 108,
    111, 115,
    111, 116,
    111, 118,
    111, 120,
    111, 123,
    111, 128,
    113, 13,
    113, 15,
    113, 97,
    113, 101,
    113, 108,
    113, 129,
    113, 131,
    113, 132,
    113, 133,
    113, 134,
    113, 136,
    113, 140,
    113, 143,
    113, 146,
    113, 149,
    114, 97,
    114, 103,
    114, 104,
    114, 115,
    114, 116,
    114, 118,
    114, 128,
    114, 147,
    114, 148,
    115, 13,
    115, 14,
    115, 15,
    115, 27,
    115, 28,
    115, 97,
    115, 101,
    115, 104,
    115, 108,
    115, 114,
    115, 115,
    115, 116,
    115, 117,
    115, 129,
    115, 131,
    115, 132,
    115, 133,
    115, 134,
    115, 135,
    115, 136,
    115, 137,
    115, 139,
    115, 140,
    115, 141,
    115, 142,
    115, 143,
    115, 144,
    115, 145,
    115, 146,
    115, 147,
    115, 148,
    115, 149,
    115, 150,
    115, 151,
    115, 152,
    115, 155,
    115, 160,
    116, 13,
    116, 14,
    116, 15,
    116, 27,
    116, 28,
    116, 97,
    116, 101,
    116, 108,
    116, 111,
    116, 114,
    116, 115,
    116, 116,
    116, 117,
    116, 120,
    116, 128,
    116, 129,
    116, 130,
    116, 133,
    116, 134,
    116, 135,
    116, 136,
    116, 137,
    116, 139,
    116, 140,
    116, 141,
    116, 142,
    116, 143,
    116, 144,
    116, 145,
    116, 146,
    116, 147,
    116, 148,
    116, 149,
    116, 150,
    116, 151,
    116, 152,
    116, 159,
    116, 160,
    117, 97,
    117, 101,
    117, 103,
    117, 108,
    117, 116,
    117, 118,
    117, 120,
    117, 123,
    117, 128,
    117, 133,
    117, 140,
    118, 104,
    118, 111,
    118, 114,
    118, 117,
    118, 129,
    118, 134,
    118, 136,
    118, 143,
    118, 146,
    118, 147,
    118, 148,
    118, 149,
    118, 152,
    123, 115,
    123, 116,
    123, 120,
    123, 123,
    125, 115,
    125, 116,
    125, 120,
    125, 123,
    125, 155,
    126, 97,
    126, 108,
    126, 115,
    126, 116,
    126, 120,
    126, 123,
    126, 128,
    127, 97,
    127, 103,
    127, 108,
    127, 115,
    127, 116,
    127, 118,
    127, 120,
    127, 123,
    127, 128,
    127, 140,
    129, 147,
    129, 148,
    129, 152,
    130, 135,
    130, 147,
    130, 148,
    130, 150,
    130, 152,
    130, 160,
    131, 136,
    131, 147,
    131, 148,
    131, 150,
    131, 152,
    132, 13,
    132, 14,
    132, 15,
    132, 27,
    132, 28,
    132, 133,
    132, 140,
    132, 149,
    132, 160,
    134, 135,
    134, 136,
    134, 140,
    134, 148,
    134, 150,
    134, 152,
    135, 134,
    135, 143,
    135, 146,
    135, 149,
    136, 135,
    136, 147,
    136, 148,
    136, 150,
    136, 152,
    139, 129,
    139, 134,
    139, 143,
    139, 146,
    139, 149,
    143, 135,
    143, 140,
    143, 147,
    143, 148,
    143, 150,
    143, 155,
    145, 14,
    145, 15,
    145, 27,
    145, 28,
    145, 135,
    145, 147,
    145, 148,
    145, 150,
    145, 152,
    146, 129,
    146, 136,
    146, 143,
    146, 147,
    146, 150,
    147, 13,
    147, 15,
    147, 27,
    147, 28,
    147, 129,
    147, 133,
    147, 134,
    147, 136,
    147, 140,
    147, 143,
    147, 146,
    147, 147,
    147, 148,
    147, 152,
    147, 160,
    148, 13,
    148, 14,
    148, 15,
    148, 27,
    148, 28,
    148, 129,
    148, 133,
    148, 134,
    148, 140,
    148, 143,
    148, 146,
    148, 147,
    148, 149,
    148, 152,
    148, 160,
    149, 133,
    149, 135,
    149, 140,
    149, 148,
    149, 150,
    149, 152,
    149, 155,
    149, 160,
    150, 129,
    150, 134,
    150, 136,
    150, 143,
    150, 146,
    150, 149,
    155, 134,
    155, 146,
    155, 147,
    155, 148,
    155, 152,
    155, 155,
    157, 134,
    157, 146,
    157, 147,
    157, 148,
    157, 152,
    157, 155,
    158, 140,
    158, 147,
    158, 148,
    158, 152,
    158, 155,
    158, 160,
    159, 135,
    159, 140,
    159, 147,
    159, 148,
    159, 150,
    159, 152,
    159, 155
};

/* Kerning between the respective left and right glyphs
 * 4.4 format which needs to scaled with `kern_scale`*/
static const int8_t kern_pair_values[] =
{
    4, 6, -6, 1, -7, 6, -6, -5,
    -1, 5, 4, -4, 1, -8, 10, 10,
    -2, 3, 5, 4, 2, 2, -2, -15,
    4, -3, -2, -7, -5, -8, -3, 4,
    -14, -3, 3, -10, -4, 2, -22, -7,
    -20, -10, -6, -12, -2, 3, -6, -5,
    -9, 7, 5, 7, -6, -6, -6, -6,
    -15, -5, -9, -9, -13, -2, -2, 3,
    -2, -1, -2, -1, -4, -4, -5, -2,
    -3, -3, -2, -7, -3, -2, -5, -8,
    -19, 3, -19, -12, -13, -3, -8, -6,
    -6, -7, -9, 2, -1, -4, -4, -7,
    -4, -8, -8, -8, 3, -2, -7, -7,
    -6, -11, 1, -3, -2, -3, -16, -2,
    -14, -12, -18, -10, 2, 2, -6, -1,
    -4, -4, -7, -7, -24, -24, -12, -14,
    -2, -4, -3, -4, -4, -4, -3, -4,
    -5, -4, -5, -5, -3, 2, -3, 1,
    -2, -4, -4, -2, -12, -6, -12, -13,
    -13, -13, -1, -1, -13, 4, 11, 9,
    13, -15, -15, -15, -14, -15, -13, -12,
    -14, -14, -15, -14, -4, 1, 1, 1,
    1, -11, -11, -4, -5, -9, -4, -4,
    -4, 11, -8, -8, -7, -8, -5, -6,
    3, -9, 2, -9, -5, -8, -4, -4,
    -4, -1, 9, -7, -7, -6, -7, -5,
    -6, 2, -4, -7, -7, -7, -7, -8,
    -10, -14, -7, -14, -8, -9, -13, -7,
    -7, -7, -1, 14, -14, -14, -13, -14,
    -9, -10, -3, -2, -4, -2, -1, -3,
    2, 2, -3, -3, -4, -4, -1, -3,
    4, -2, 2, 6, -3, 6, 5, -4,
    4, -4, -2, -2, -2, -3, -2, -2,
    -3, -3, -3, -4, -4, 1, -2, -10,
    4, -10, 4, -1, -1, -2, 3, 6,
    6, 5, 2, 6, 2, 4, 4, 3,
    -1, -1, -9, 5, -9, 1, -4, -4,
    -4, -3, -4, -7, 5, -7, -4, -3,
    -3, -2, -3, -2, -5, -5, -4, -4,
    -8, 5, -7, 1, -4, -3, -3, -2,
    -3, 7, 5, 7, 1, 1, 11, -6,
    -6, -12, -8, -12, -7, 1, 10, -2,
    -2, -6, -5, -4, -8, -3, -1, -4,
    -5, -3, -7, -2, -4, -5, -5, -3,
    -1, -4, 2, -3, -5, 2, 4, 2,
    -3, 5, -21, -13, -21, -5, -6, -12,
    -9, 10, 12, -7, 3, -15, -7, -21,
    -18, 1, -11, -7, -7, -18, -7, -7,
    -17, -7, -5, -18, 3, 2, -20, -1,
    -8, -5, 5, -5, -13, -5, -5, -5,
    -9, 4, -3, -3, 3, -3, -3, -4,
    -8, -4, -12, -1, 5, -5, 4, 1,
    2, -3, -5, -5, -3, 4, 2, -1,
    -2, -3, -8, -8, -12, -2, -6, -7,
    -2, -7, -7, -10, -11, -8, -14, -6,
    -7, -2, -1, -5, -7, -3, 2, -4,
    -24, -24, -12, -11, -7, -2, -2, -2,
    -14, -4, 1, -11, -3, -4, -4, -2,
    -5, 4, 3, -3, -5, -1, 7, 5,
    -12, -6, -12, -5, -6, -11, -9, 4,
    -7, -1, 10, 12, -7, -13, -7, -7,
    -13, -13, 1, -12, -7, -7, -12, -7,
    -7, -13, -7, -5, -13, 3, 2, -14,
    -2, -8, -5, 5, -12, -19, -3, -19,
    -5, -6, -12, -10, -8, -5, -5, 13,
    15, -7, 5, -3, -11, -7, -16, -12,
    1, -7, -7, -7, -13, -7, -7, -12,
    -7, -6, -12, 3, 2, -13, -1, -7,
    -5, -6, -9, -7, -5, -10, -4, -8,
    -11, -3, -3, -5, -6, -3, -4, -7,
    -7, -11, -1, -7, -2, -8, -7, -8,
    -10, -9, -16, -13, -4, -4, -9, -13,
    -4, -4, -9, 1, -6, -2, -1, -5,
    -3, 2, -4, -6, -7, -3, -1, -5,
    -8, -3, 2, -4, -1, 1, -4, -5,
    -3, 2, -4, -5, -3, -1, 3, 4,
    -2, -2, -4, -15, -9, -15, 1, 1,
    -11, -8, -1, 2, -3, 1, -1, -4,
    -4, -2, -2, -2, -2, -3, -1, 3,
    -3, -3, -5, 1, -2, -2, -2, -3,
    -3, -1, 2, -4, -4, 4, 12, 2,
    1, 1, -1, 3, -2, -3, -2, 1,
    4, 1, 5, -2, -7, -7, 3, 3,
    3, -7, 1, 7, -5, 2, 1, 12,
    10, 4, 4, -8, 5, -7, 1, 1,
    -4, -6, -3, -4, -3, -3, 10, -5,
    2, -2, -1, -4, -3, -5, -6, -3,
    3, -2, -2, -5, -3, -4, -5, -6,
    1, 1, -10, -8, -3, -8, 1, 1,
    -10, -8, -3, -8, -1, 2, -4, -2,
    4, -1, -3, -1, 1, -4, -5, -2,
    4
};

/*Collect the kern pair's data in one place*/
static const lv_font_fmt_txt_kern_pair_t kern_pairs =
{
    .glyph_ids = kern_pair_glyph_ids,
    .values = kern_pair_values,
    .pair_cnt = 729,
    .glyph_ids_size = 0
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_pairs,
    .kern_scale = 16,
    .cmap_num = 4,
    .bpp = 4,
    .kern_classes = 0,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif

};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t Franklin_18_rus = {
#else
lv_font_t Franklin_18_rus = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 19,          /*The maximum line height required by the font*/
    .base_line = 3,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -1,
    .underline_thickness = 1,
#endif
    //.static_bitmap = 0,
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if FRANKLIN_18_RUS*/
