/*******************************************************************************
 * Size: 22 px
 * Bpp: 4
 * Opts: --bpp 4 --size 22 --no-compress --stride 1 --align 1 --font FRADM.TTF --range 32-127,176,8226,1040-1103,1105 --format lvgl -o Franklin_24_rus.c
 ******************************************************************************/

#ifdef __has_include
    #if __has_include("lvgl.h")
        #ifndef LV_LVGL_H_INCLUDE_SIMPLE
            #define LV_LVGL_H_INCLUDE_SIMPLE
        #endif
    #endif
#endif

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
    #include "lvgl.h"
#else
    #include "lvgl/lvgl.h"
#endif



#ifndef FRANKLIN_24_RUS
#define FRANKLIN_24_RUS 1
#endif

#if FRANKLIN_24_RUS

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0xcf, 0xff, 0x3a, 0xff, 0xf1, 0x9f, 0xff, 0x7,
    0xff, 0xe0, 0x5f, 0xfc, 0x3, 0xff, 0xb0, 0x2f,
    0xf9, 0x0, 0xff, 0x70, 0xe, 0xf6, 0x0, 0xdf,
    0x40, 0x2, 0x30, 0x2, 0x55, 0x50, 0x7f, 0xff,
    0x7, 0xff, 0xf0, 0x7f, 0xff, 0x0,

    /* U+0022 "\"" */
    0x2f, 0xf6, 0x4f, 0xf4, 0x1f, 0xf5, 0x3f, 0xf3,
    0xf, 0xf4, 0x1f, 0xf2, 0xf, 0xf3, 0xf, 0xf1,
    0xe, 0xf2, 0xf, 0xf0, 0xd, 0xf1, 0xe, 0xf0,
    0x0, 0x10, 0x0, 0x0,

    /* U+0023 "#" */
    0x0, 0x0, 0x3f, 0xe0, 0x6f, 0xc0, 0x0, 0x0,
    0x6, 0xfb, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x9f,
    0x80, 0xcf, 0x60, 0x0, 0x0, 0xc, 0xf5, 0xf,
    0xf3, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x10, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x1,
    0x26, 0xfd, 0x28, 0xfb, 0x21, 0x0, 0x0, 0x7f,
    0xa0, 0xaf, 0x80, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x2, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0x2, 0x2f, 0xf4, 0x4f, 0xf2, 0x20, 0x0,
    0x2, 0xff, 0x5, 0xfd, 0x0, 0x0, 0x0, 0x4f,
    0xd0, 0x7f, 0xb0, 0x0, 0x0, 0x7, 0xfa, 0xa,
    0xf8, 0x0, 0x0, 0x0, 0x9f, 0x80, 0xcf, 0x50,
    0x0, 0x0,

    /* U+0024 "$" */
    0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0xf5,
    0x10, 0x0, 0x0, 0x3d, 0xff, 0xff, 0xf9, 0x0,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x9, 0xff,
    0xa1, 0x4, 0xff, 0xe1, 0xc, 0xff, 0x70, 0x0,
    0x43, 0x0, 0xa, 0xff, 0xfb, 0x63, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xf9, 0x10, 0x0, 0x5e,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x48, 0xcf,
    0xff, 0xf6, 0x0, 0x12, 0x0, 0x1, 0xdf, 0xfa,
    0x4d, 0xfd, 0x0, 0x0, 0xbf, 0xf8, 0xe, 0xff,
    0xe9, 0x8b, 0xff, 0xf3, 0x4, 0xff, 0xff, 0xff,
    0xff, 0x70, 0x0, 0x19, 0xdf, 0xfe, 0xa4, 0x0,
    0x0, 0x0, 0xc, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf0, 0x0, 0x0,

    /* U+0025 "%" */
    0x1, 0xbf, 0xd4, 0x0, 0x0, 0x7f, 0x20, 0x0,
    0xbf, 0x6d, 0xf1, 0x0, 0x1f, 0x90, 0x0, 0x2f,
    0xb0, 0x6f, 0x70, 0x8, 0xf1, 0x0, 0x4, 0xf9,
    0x4, 0xf9, 0x2, 0xf8, 0x0, 0x0, 0x5f, 0x90,
    0x4f, 0xa0, 0xae, 0x0, 0x0, 0x3, 0xfa, 0x5,
    0xf8, 0x3f, 0x70, 0x0, 0x0, 0xd, 0xe2, 0xbf,
    0x2b, 0xd0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0x74,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x3, 0x10, 0xcc,
    0x5, 0xef, 0xe4, 0x0, 0x0, 0x0, 0x5f, 0x41,
    0xfd, 0x4d, 0xf1, 0x0, 0x0, 0xd, 0xb0, 0x6f,
    0x80, 0x8f, 0x60, 0x0, 0x6, 0xf3, 0x7, 0xf7,
    0x6, 0xf8, 0x0, 0x0, 0xea, 0x0, 0x6f, 0x80,
    0x8f, 0x60, 0x0, 0x8f, 0x20, 0x1, 0xed, 0x5d,
    0xf1, 0x0, 0x1f, 0x90, 0x0, 0x4, 0xdf, 0xc3,
    0x0,

    /* U+0026 "&" */
    0x0, 0x0, 0x3b, 0xef, 0xea, 0x10, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xe1, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xa4, 0x9f, 0xf9, 0x0, 0x0,
    0x0, 0xf, 0xff, 0x30, 0xe, 0xfb, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xb0, 0x3f, 0xfa, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfd, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xfe, 0x40, 0x45, 0x30,
    0x1, 0xbf, 0xff, 0xff, 0xf5, 0x0, 0xef, 0xf4,
    0xb, 0xff, 0xf9, 0xcf, 0xff, 0x45, 0xff, 0xe0,
    0x3f, 0xff, 0x80, 0x1d, 0xff, 0xfe, 0xff, 0x70,
    0x5f, 0xff, 0x50, 0x2, 0xef, 0xff, 0xfd, 0x0,
    0x3f, 0xff, 0xb0, 0x0, 0x5f, 0xff, 0xf4, 0x0,
    0xd, 0xff, 0xfe, 0xcd, 0xff, 0xff, 0xff, 0xc5,
    0x2, 0xef, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xf6,
    0x0, 0x18, 0xdf, 0xfe, 0xa4, 0x3, 0xbf, 0xe5,

    /* U+0027 "'" */
    0x2f, 0xf6, 0x1f, 0xf5, 0xf, 0xf4, 0xf, 0xf3,
    0xe, 0xf2, 0xd, 0xf1, 0x0, 0x10,

    /* U+0028 "(" */
    0x0, 0xb, 0xfa, 0x0, 0x4f, 0xf3, 0x0, 0xdf,
    0xb0, 0x4, 0xff, 0x60, 0xb, 0xff, 0x10, 0xf,
    0xfd, 0x0, 0x3f, 0xfa, 0x0, 0x5f, 0xf8, 0x0,
    0x7f, 0xf7, 0x0, 0x7f, 0xf6, 0x0, 0x7f, 0xf7,
    0x0, 0x5f, 0xf8, 0x0, 0x3f, 0xfa, 0x0, 0xf,
    0xfd, 0x0, 0xa, 0xff, 0x10, 0x4, 0xff, 0x50,
    0x0, 0xdf, 0xb0, 0x0, 0x5f, 0xf2, 0x0, 0xb,
    0xfa,

    /* U+0029 ")" */
    0x3f, 0xf3, 0x0, 0xb, 0xfc, 0x0, 0x4, 0xff,
    0x50, 0x0, 0xef, 0xb0, 0x0, 0x9f, 0xf2, 0x0,
    0x6f, 0xf6, 0x0, 0x3f, 0xfa, 0x0, 0x1f, 0xfd,
    0x0, 0xf, 0xfe, 0x0, 0xf, 0xff, 0x0, 0xf,
    0xfe, 0x0, 0x1f, 0xfc, 0x0, 0x3f, 0xfa, 0x0,
    0x6f, 0xf6, 0x0, 0xaf, 0xf2, 0x0, 0xef, 0xb0,
    0x4, 0xff, 0x50, 0xc, 0xfc, 0x0, 0x3f, 0xf2,
    0x0,

    /* U+002A "*" */
    0x0, 0x0, 0xdf, 0xa0, 0x0, 0x0, 0x0, 0xb,
    0xf9, 0x0, 0x0, 0xb, 0x92, 0xaf, 0x73, 0x9a,
    0x1, 0xff, 0xfe, 0xfe, 0xff, 0xf1, 0x28, 0xcf,
    0xff, 0xff, 0xb7, 0x10, 0x0, 0xaf, 0xff, 0x70,
    0x0, 0x0, 0x8f, 0xf9, 0xff, 0x60, 0x0, 0x2f,
    0xf9, 0xc, 0xfe, 0x0, 0x0, 0x2b, 0x10, 0x2a,
    0x10, 0x0,

    /* U+002B "+" */
    0x0, 0x0, 0x12, 0x10, 0x0, 0x0, 0x0, 0xb,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xa0, 0x0,
    0x0, 0x0, 0xb, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xa0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x55,
    0x5c, 0xfb, 0x55, 0x54, 0x0, 0x0, 0xbf, 0xa0,
    0x0, 0x0, 0x0, 0xb, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xa0, 0x0, 0x0, 0x0, 0xb, 0xfa,
    0x0, 0x0,

    /* U+002C "," */
    0x45, 0x52, 0xdf, 0xf7, 0xdf, 0xf7, 0xdf, 0xf7,
    0x6, 0xf1, 0xc, 0x90, 0x3f, 0x10, 0xa9, 0x0,

    /* U+002D "-" */
    0x35, 0x55, 0x51, 0xbf, 0xff, 0xf6, 0xbf, 0xff,
    0xf6,

    /* U+002E "." */
    0x34, 0x42, 0xdf, 0xf7, 0xdf, 0xf7, 0xdf, 0xf7,

    /* U+002F "/" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xef,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe1,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x2, 0xae, 0xfe, 0x91, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0x1, 0xef, 0xfb,
    0x7c, 0xff, 0xd0, 0x0, 0x8f, 0xfd, 0x0, 0xe,
    0xff, 0x60, 0xd, 0xff, 0x80, 0x0, 0x9f, 0xfc,
    0x1, 0xff, 0xf6, 0x0, 0x7, 0xff, 0xf0, 0x3f,
    0xff, 0x50, 0x0, 0x6f, 0xff, 0x24, 0xff, 0xf4,
    0x0, 0x5, 0xff, 0xf2, 0x3f, 0xff, 0x50, 0x0,
    0x6f, 0xff, 0x11, 0xff, 0xf6, 0x0, 0x7, 0xff,
    0xf0, 0xd, 0xff, 0x80, 0x0, 0x9f, 0xfc, 0x0,
    0x8f, 0xfd, 0x0, 0xe, 0xff, 0x60, 0x1, 0xef,
    0xfc, 0x8d, 0xff, 0xd0, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x0, 0x2, 0xae, 0xfe, 0x91,
    0x0, 0x0,

    /* U+0031 "1" */
    0x0, 0x0, 0x2, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x5, 0xef, 0xfc, 0x0, 0x0, 0x1, 0x6c, 0xff,
    0xff, 0xc0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0xa, 0xfe, 0x69, 0xff, 0xc0, 0x0,
    0x0, 0x98, 0x0, 0x9f, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xfc, 0x0, 0x0, 0xa, 0xaa,
    0xad, 0xff, 0xea, 0xaa, 0x90, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd0,

    /* U+0032 "2" */
    0x0, 0x5, 0xbe, 0xfe, 0xa3, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0x60, 0x6, 0xff, 0xfd, 0xcf,
    0xff, 0xf2, 0xe, 0xff, 0x80, 0x3, 0xff, 0xf9,
    0x2f, 0xff, 0x0, 0x0, 0xdf, 0xfb, 0x0, 0x45,
    0x0, 0x0, 0xef, 0xfa, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xc0,
    0x0, 0x0, 0x7, 0xff, 0xfd, 0x10, 0x0, 0x0,
    0xaf, 0xff, 0xb1, 0x0, 0x0, 0x2d, 0xff, 0xf7,
    0x0, 0x0, 0x6, 0xff, 0xfb, 0x20, 0x0, 0x0,
    0x4f, 0xff, 0xfe, 0xee, 0xee, 0xed, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xfb,

    /* U+0033 "3" */
    0x0, 0x6, 0xcf, 0xfe, 0xa3, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0x60, 0x9, 0xff, 0xf9, 0x9e,
    0xff, 0xf2, 0xf, 0xff, 0x40, 0x2, 0xff, 0xf6,
    0x0, 0x24, 0x0, 0x0, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x18, 0xff, 0xf1, 0x0, 0x0, 0xbf, 0xff,
    0xfd, 0x30, 0x0, 0x0, 0xbf, 0xff, 0xf9, 0x20,
    0x0, 0x0, 0x68, 0x9d, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xfa, 0x49, 0xb8, 0x0, 0x0,
    0xaf, 0xfd, 0x5f, 0xff, 0x30, 0x1, 0xef, 0xfc,
    0xd, 0xff, 0xfb, 0xae, 0xff, 0xf6, 0x2, 0xef,
    0xff, 0xff, 0xff, 0x90, 0x0, 0x18, 0xdf, 0xfe,
    0xb4, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x0, 0xdf, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0x50, 0x0, 0x0, 0xd, 0xf9, 0xef,
    0xf5, 0x0, 0x0, 0x8, 0xfe, 0x1e, 0xff, 0x50,
    0x0, 0x3, 0xff, 0x50, 0xef, 0xf5, 0x0, 0x0,
    0xdf, 0xb0, 0xe, 0xff, 0x50, 0x0, 0x8f, 0xf1,
    0x0, 0xef, 0xf5, 0x0, 0x3f, 0xf6, 0x0, 0xe,
    0xff, 0x50, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x64,
    0x88, 0x88, 0x89, 0xff, 0xfb, 0x83, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0x50, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0x50, 0x0,

    /* U+0035 "5" */
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xf5, 0x0, 0xe,
    0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0xf, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xf7, 0x27, 0x98, 0x30, 0x0, 0x3,
    0xff, 0xcf, 0xff, 0xff, 0xa0, 0x0, 0x5f, 0xff,
    0xff, 0xff, 0xff, 0x90, 0x3, 0xce, 0xd3, 0x4,
    0xef, 0xff, 0x10, 0x0, 0x0, 0x0, 0x5, 0xff,
    0xf4, 0x2, 0x47, 0x10, 0x0, 0x3f, 0xff, 0x30,
    0xff, 0xf9, 0x0, 0xb, 0xff, 0xf1, 0x8, 0xff,
    0xfd, 0xbe, 0xff, 0xfa, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x5, 0xbe, 0xff, 0xc6,
    0x0, 0x0,

    /* U+0036 "6" */
    0x0, 0x0, 0x8d, 0xff, 0xc6, 0x0, 0x0, 0x1,
    0xef, 0xff, 0xff, 0xfa, 0x0, 0x0, 0xcf, 0xfd,
    0x79, 0xff, 0xf6, 0x0, 0x5f, 0xff, 0x10, 0x6,
    0xff, 0xd0, 0xb, 0xff, 0x90, 0x0, 0x9, 0x40,
    0x0, 0xef, 0xf6, 0x3, 0x43, 0x0, 0x0, 0x1f,
    0xff, 0x6c, 0xff, 0xfe, 0x50, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x40, 0x1f, 0xff, 0xf6, 0x3,
    0xef, 0xfd, 0x0, 0xff, 0xf9, 0x0, 0x5, 0xff,
    0xf2, 0xc, 0xff, 0x70, 0x0, 0x3f, 0xff, 0x20,
    0x6f, 0xfc, 0x0, 0x8, 0xff, 0xf0, 0x0, 0xdf,
    0xfc, 0x7a, 0xff, 0xf8, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x1, 0x8d, 0xff, 0xc6,
    0x0, 0x0,

    /* U+0037 "7" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xc9, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0xbf, 0xf2, 0x0, 0x0,
    0x0, 0x8f, 0xf6, 0x0, 0x0, 0x0, 0x4f, 0xfd,
    0x0, 0x0, 0x0, 0xd, 0xff, 0x50, 0x0, 0x0,
    0x6, 0xff, 0xe0, 0x0, 0x0, 0x0, 0xdf, 0xf8,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0x40, 0x0, 0x0,
    0x9, 0xff, 0xf0, 0x0, 0x0, 0x0, 0xef, 0xfd,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xb0, 0x0, 0x0,
    0x2, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xa0, 0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x5, 0xbe, 0xfe, 0xb6, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x6, 0xff, 0xe5,
    0x36, 0xef, 0xf7, 0x0, 0xcf, 0xf7, 0x0, 0x6,
    0xff, 0xb0, 0xd, 0xff, 0xa0, 0x0, 0x4f, 0xfa,
    0x0, 0xaf, 0xff, 0xc5, 0x2c, 0xff, 0x40, 0x2,
    0xef, 0xff, 0xff, 0xfe, 0x50, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x4, 0xff, 0xfc, 0xff,
    0xff, 0xf9, 0x1, 0xff, 0xf4, 0x1, 0x7e, 0xff,
    0xf1, 0x4f, 0xfc, 0x0, 0x0, 0x3f, 0xff, 0x34,
    0xff, 0xe0, 0x0, 0x2, 0xff, 0xf1, 0xe, 0xff,
    0xd7, 0x57, 0xef, 0xfb, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xfd, 0x10, 0x0, 0x29, 0xdf, 0xfe, 0xb6,
    0x0, 0x0,

    /* U+0039 "9" */
    0x0, 0x7, 0xcf, 0xfd, 0x81, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xfe, 0x20, 0x9, 0xff, 0xf9, 0x7d,
    0xff, 0xc0, 0xf, 0xff, 0x60, 0x1, 0xef, 0xf4,
    0x2f, 0xff, 0x10, 0x0, 0xaf, 0xf9, 0x2f, 0xff,
    0x30, 0x0, 0xcf, 0xfd, 0xf, 0xff, 0xc2, 0x18,
    0xff, 0xfe, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x8f, 0xff, 0xfd, 0x9f, 0xfe, 0x0, 0x2,
    0x67, 0x40, 0x8f, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xf8, 0x7, 0xbe, 0x60, 0x2, 0xff, 0xf2,
    0x7, 0xff, 0xfa, 0xaf, 0xff, 0x90, 0x0, 0xcf,
    0xff, 0xff, 0xfc, 0x0, 0x0, 0x7, 0xdf, 0xfc,
    0x70, 0x0,

    /* U+003A ":" */
    0xdf, 0xf7, 0xdf, 0xf7, 0xdf, 0xf7, 0x23, 0x31,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x34, 0x42,
    0xdf, 0xf7, 0xdf, 0xf7, 0xdf, 0xf7,

    /* U+003B ";" */
    0xdf, 0xf7, 0xdf, 0xf7, 0xdf, 0xf7, 0x23, 0x31,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x45, 0x52,
    0xdf, 0xf7, 0xdf, 0xf7, 0xdf, 0xf7, 0x6, 0xf1,
    0xc, 0x90, 0x3f, 0x10, 0xa9, 0x0,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0,
    0x2, 0xaf, 0x0, 0x0, 0x2, 0xaf, 0xff, 0x0,
    0x2, 0xaf, 0xff, 0xfc, 0x1, 0x9f, 0xff, 0xfc,
    0x40, 0x5f, 0xff, 0xfc, 0x40, 0x0, 0x8f, 0xff,
    0x40, 0x0, 0x0, 0x8f, 0xff, 0xd6, 0x0, 0x0,
    0x7, 0xef, 0xff, 0xd6, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xd5, 0x0, 0x0, 0x18, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x19, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x19,

    /* U+003D "=" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x55, 0x55, 0x55, 0x55, 0x55, 0x40,

    /* U+003E ">" */
    0x2, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfa, 0x20,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0x91, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xf9, 0x10, 0x0, 0x0, 0x5c,
    0xff, 0xff, 0x81, 0x0, 0x0, 0x5, 0xdf, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x5f, 0xff, 0x70, 0x0,
    0x0, 0x7e, 0xff, 0xf6, 0x0, 0x7, 0xef, 0xff,
    0xe7, 0x0, 0x7e, 0xff, 0xfe, 0x70, 0x0, 0x1f,
    0xff, 0xf7, 0x0, 0x0, 0x1, 0xff, 0x81, 0x0,
    0x0, 0x0, 0x18, 0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+003F "?" */
    0x0, 0x19, 0xef, 0xea, 0x30, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0x60, 0xe, 0xff, 0xdb, 0xff, 0xff,
    0x25, 0xff, 0xc0, 0x2, 0xff, 0xf7, 0x9f, 0xf6,
    0x0, 0xf, 0xff, 0x90, 0x14, 0x10, 0x3, 0xff,
    0xf6, 0x0, 0x0, 0x4, 0xff, 0xfe, 0x0, 0x0,
    0x6, 0xff, 0xfe, 0x30, 0x0, 0x0, 0xef, 0xfc,
    0x20, 0x0, 0x0, 0xf, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0xdd, 0x90, 0x0, 0x0, 0x0, 0x3, 0x33,
    0x0, 0x0, 0x0, 0x1, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0x40, 0x0, 0x0, 0x1, 0xff,
    0xf4, 0x0, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0x0, 0x26, 0x77, 0x51, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xcf, 0xff, 0xff, 0xf9, 0x10,
    0x0, 0x0, 0x8, 0xff, 0xc7, 0x45, 0x8e, 0xfd,
    0x20, 0x0, 0x7, 0xff, 0x50, 0x0, 0x0, 0x9,
    0xfd, 0x10, 0x2, 0xff, 0x40, 0x0, 0x0, 0x0,
    0xa, 0xf8, 0x0, 0xaf, 0xa0, 0x5, 0xdf, 0xbe,
    0xf3, 0x1f, 0xe0, 0xf, 0xf4, 0x5, 0xff, 0xff,
    0xff, 0x10, 0xdf, 0x21, 0xff, 0x10, 0xdf, 0xa1,
    0x8f, 0xf0, 0xb, 0xf3, 0x2f, 0xf0, 0xf, 0xf2,
    0x0, 0xfd, 0x0, 0xdf, 0x20, 0xff, 0x20, 0xff,
    0x10, 0x3f, 0xb0, 0x3f, 0xe0, 0xd, 0xf7, 0xd,
    0xf7, 0x1c, 0xfb, 0x2d, 0xf6, 0x0, 0x7f, 0xe0,
    0x5f, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0xdf,
    0xb0, 0x5c, 0xb4, 0x5b, 0xb6, 0x0, 0x0, 0x2,
    0xef, 0xd5, 0x0, 0x0, 0x26, 0x90, 0x0, 0x0,
    0x2, 0xcf, 0xff, 0xee, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x4a, 0xdf, 0xfe, 0xb6, 0x10, 0x0,

    /* U+0041 "A" */
    0x0, 0x0, 0x7f, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0xb, 0xff, 0xaf,
    0xff, 0x10, 0x0, 0x0, 0xf, 0xfd, 0x3f, 0xff,
    0x50, 0x0, 0x0, 0x5f, 0xf9, 0xe, 0xff, 0xa0,
    0x0, 0x0, 0xaf, 0xf4, 0xa, 0xff, 0xf0, 0x0,
    0x0, 0xff, 0xf0, 0x5, 0xff, 0xf4, 0x0, 0x4,
    0xff, 0xfb, 0xbb, 0xff, 0xf9, 0x0, 0x9, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0x3f, 0xfc, 0x0, 0x0,
    0x2f, 0xff, 0x80, 0x8f, 0xf7, 0x0, 0x0, 0xd,
    0xff, 0xc0, 0xdf, 0xf2, 0x0, 0x0, 0x9, 0xff,
    0xf1,

    /* U+0042 "B" */
    0x8f, 0xff, 0xff, 0xff, 0xeb, 0x30, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x8f, 0xff, 0x99,
    0x9a, 0xff, 0xfe, 0x8, 0xff, 0xe0, 0x0, 0x8,
    0xff, 0xf2, 0x8f, 0xfe, 0x0, 0x0, 0x6f, 0xff,
    0x18, 0xff, 0xe0, 0x0, 0x2c, 0xff, 0xc0, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xc1, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xe6, 0x0, 0x8f, 0xff, 0x99, 0x9b,
    0xff, 0xfa, 0x8, 0xff, 0xe0, 0x0, 0x4, 0xff,
    0xf4, 0x8f, 0xfe, 0x0, 0x0, 0xf, 0xff, 0x88,
    0xff, 0xe0, 0x0, 0x5, 0xff, 0xf8, 0x8f, 0xff,
    0xbb, 0xbd, 0xff, 0xff, 0x38, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x8f, 0xff, 0xff, 0xff, 0xeb,
    0x50, 0x0,

    /* U+0043 "C" */
    0x0, 0x0, 0x6b, 0xef, 0xea, 0x40, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0xbf,
    0xff, 0xed, 0xff, 0xff, 0x40, 0x5, 0xff, 0xfa,
    0x0, 0x2e, 0xff, 0xc0, 0xc, 0xff, 0xf1, 0x0,
    0x8, 0xff, 0xf1, 0xf, 0xff, 0xc0, 0x0, 0x4,
    0xcc, 0xc2, 0x2f, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xb0, 0x0, 0x0, 0x66, 0x61, 0xc, 0xff,
    0xf0, 0x0, 0x5, 0xff, 0xf1, 0x6, 0xff, 0xfa,
    0x0, 0x1d, 0xff, 0xc0, 0x0, 0xcf, 0xff, 0xfd,
    0xff, 0xff, 0x40, 0x0, 0x1c, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x6b, 0xef, 0xea, 0x30,
    0x0,

    /* U+0044 "D" */
    0x8f, 0xff, 0xff, 0xec, 0x70, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xd1, 0x0, 0x8f, 0xff, 0xbb,
    0xef, 0xff, 0xd0, 0x8, 0xff, 0xd0, 0x0, 0x8f,
    0xff, 0x90, 0x8f, 0xfd, 0x0, 0x0, 0xcf, 0xff,
    0x8, 0xff, 0xd0, 0x0, 0x5, 0xff, 0xf4, 0x8f,
    0xfd, 0x0, 0x0, 0x1f, 0xff, 0x78, 0xff, 0xd0,
    0x0, 0x1, 0xff, 0xf7, 0x8f, 0xfd, 0x0, 0x0,
    0x2f, 0xff, 0x68, 0xff, 0xd0, 0x0, 0x6, 0xff,
    0xf4, 0x8f, 0xfd, 0x0, 0x0, 0xdf, 0xff, 0x8,
    0xff, 0xd0, 0x0, 0x9f, 0xff, 0x80, 0x8f, 0xff,
    0xbc, 0xef, 0xff, 0xd0, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xd1, 0x0, 0x8f, 0xff, 0xff, 0xeb, 0x60,
    0x0, 0x0,

    /* U+0045 "E" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xcc, 0xcc, 0xcc,
    0xb8, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xbb, 0xbb, 0xb5, 0x8, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x8f, 0xff, 0xff, 0xff,
    0xf7, 0x8, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0x0, 0x0, 0x0, 0x8, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xee, 0xee, 0xee, 0xd8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xf0,

    /* U+0046 "F" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xe8, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x8f, 0xff, 0xee, 0xee, 0xee,
    0xc8, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xbb, 0xbb, 0xb5, 0x8, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x8f, 0xff, 0xff, 0xff,
    0xf7, 0x8, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0x0, 0x0, 0x0, 0x8, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0,
    0x0, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x0, 0x7c, 0xff, 0xd8, 0x10, 0x0, 0x1,
    0xdf, 0xff, 0xff, 0xfe, 0x20, 0x0, 0xcf, 0xff,
    0xed, 0xff, 0xfe, 0x0, 0x5f, 0xff, 0x70, 0x4,
    0xff, 0xf7, 0xc, 0xff, 0xc0, 0x0, 0xa, 0xff,
    0xb0, 0xff, 0xf7, 0x0, 0x0, 0x47, 0x53, 0x2f,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x3, 0xff, 0xf4,
    0x1, 0xbb, 0xbb, 0xba, 0x2f, 0xff, 0x50, 0x2f,
    0xff, 0xff, 0xe1, 0xff, 0xf6, 0x2, 0xff, 0xff,
    0xfe, 0xd, 0xff, 0xb0, 0x0, 0x7, 0xff, 0xe0,
    0x7f, 0xff, 0x40, 0x0, 0xdf, 0xfe, 0x0, 0xef,
    0xff, 0xb9, 0xef, 0xff, 0xe0, 0x2, 0xef, 0xff,
    0xff, 0xfa, 0xfe, 0x0, 0x1, 0x8d, 0xff, 0xb5,
    0xd, 0xe0,

    /* U+0048 "H" */
    0x8f, 0xfd, 0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xfd,
    0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xfd, 0x0, 0x0,
    0x9f, 0xfd, 0x8f, 0xfd, 0x0, 0x0, 0x9f, 0xfd,
    0x8f, 0xfd, 0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xfd,
    0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xff, 0xee, 0xee,
    0xff, 0xfd, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x8f, 0xfd,
    0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xfd, 0x0, 0x0,
    0x9f, 0xfd, 0x8f, 0xfd, 0x0, 0x0, 0x9f, 0xfd,
    0x8f, 0xfd, 0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xfd,
    0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xfd, 0x0, 0x0,
    0x9f, 0xfd,

    /* U+0049 "I" */
    0x8f, 0xfe, 0x8f, 0xfe, 0x8f, 0xfe, 0x8f, 0xfe,
    0x8f, 0xfe, 0x8f, 0xfe, 0x8f, 0xfe, 0x8f, 0xfe,
    0x8f, 0xfe, 0x8f, 0xfe, 0x8f, 0xfe, 0x8f, 0xfe,
    0x8f, 0xfe, 0x8f, 0xfe, 0x8f, 0xfe,

    /* U+004A "J" */
    0x0, 0x6, 0xff, 0xf1, 0x0, 0x6, 0xff, 0xf1,
    0x0, 0x6, 0xff, 0xf1, 0x0, 0x6, 0xff, 0xf1,
    0x0, 0x6, 0xff, 0xf1, 0x0, 0x6, 0xff, 0xf1,
    0x0, 0x6, 0xff, 0xf1, 0x0, 0x6, 0xff, 0xf1,
    0x0, 0x6, 0xff, 0xf1, 0x0, 0x6, 0xff, 0xf1,
    0x0, 0x6, 0xff, 0xf0, 0x0, 0xb, 0xff, 0xf0,
    0xde, 0xff, 0xff, 0xc0, 0xdf, 0xff, 0xff, 0x40,
    0xbe, 0xfe, 0xb4, 0x0,

    /* U+004B "K" */
    0x8f, 0xfd, 0x0, 0x0, 0xdf, 0xf6, 0x8, 0xff,
    0xd0, 0x0, 0x8f, 0xfb, 0x0, 0x8f, 0xfd, 0x0,
    0x3f, 0xff, 0x20, 0x8, 0xff, 0xd0, 0xd, 0xff,
    0x60, 0x0, 0x8f, 0xfd, 0x7, 0xff, 0xc0, 0x0,
    0x8, 0xff, 0xd2, 0xff, 0xf5, 0x0, 0x0, 0x8f,
    0xfd, 0xcf, 0xff, 0xb0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x0, 0x8f, 0xff, 0xfe, 0xff,
    0xfa, 0x0, 0x8, 0xff, 0xff, 0x3a, 0xff, 0xf1,
    0x0, 0x8f, 0xff, 0x80, 0x3f, 0xff, 0x80, 0x8,
    0xff, 0xe0, 0x0, 0xcf, 0xff, 0x0, 0x8f, 0xfd,
    0x0, 0x4, 0xff, 0xf7, 0x8, 0xff, 0xd0, 0x0,
    0xd, 0xff, 0xe0, 0x8f, 0xfd, 0x0, 0x0, 0x6f,
    0xff, 0x60,

    /* U+004C "L" */
    0x8f, 0xff, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xee, 0xee,
    0xea, 0x8f, 0xff, 0xff, 0xff, 0xfc, 0x8f, 0xff,
    0xff, 0xff, 0xfc,

    /* U+004D "M" */
    0x8f, 0xff, 0xfe, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0x78, 0xff, 0xff, 0xf3, 0x0, 0x6, 0xff, 0xff,
    0xf7, 0x8f, 0xff, 0xff, 0x80, 0x0, 0xaf, 0xff,
    0xff, 0x78, 0xff, 0xcf, 0xfc, 0x0, 0xf, 0xfc,
    0xff, 0xf7, 0x8f, 0xf7, 0xff, 0xf1, 0x4, 0xff,
    0x7f, 0xff, 0x78, 0xff, 0x5d, 0xff, 0x60, 0x9f,
    0xf2, 0xff, 0xf7, 0x8f, 0xf5, 0x8f, 0xfa, 0xe,
    0xfd, 0xf, 0xff, 0x78, 0xff, 0x54, 0xff, 0xe3,
    0xff, 0x80, 0xff, 0xf7, 0x8f, 0xf5, 0xf, 0xff,
    0xbf, 0xf4, 0xf, 0xff, 0x78, 0xff, 0x50, 0xaf,
    0xff, 0xfe, 0x0, 0xff, 0xf7, 0x8f, 0xf5, 0x6,
    0xff, 0xff, 0xa0, 0xf, 0xff, 0x78, 0xff, 0x50,
    0x1f, 0xff, 0xf5, 0x0, 0xff, 0xf7, 0x8f, 0xf5,
    0x0, 0xcf, 0xff, 0x10, 0xf, 0xff, 0x78, 0xff,
    0x50, 0x7, 0xff, 0xb0, 0x0, 0xff, 0xf7, 0x8f,
    0xf5, 0x0, 0x3f, 0xf7, 0x0, 0xf, 0xff, 0x70,

    /* U+004E "N" */
    0x8f, 0xff, 0x70, 0x0, 0xe, 0xfc, 0x8f, 0xff,
    0xf1, 0x0, 0xe, 0xfc, 0x8f, 0xff, 0xf9, 0x0,
    0xe, 0xfc, 0x8f, 0xff, 0xff, 0x20, 0xe, 0xfc,
    0x8f, 0xff, 0xff, 0xb0, 0xe, 0xfc, 0x8f, 0xfa,
    0xff, 0xf4, 0xe, 0xfc, 0x8f, 0xf3, 0xef, 0xfd,
    0xe, 0xfc, 0x8f, 0xf2, 0x6f, 0xff, 0x6e, 0xfc,
    0x8f, 0xf2, 0xd, 0xff, 0xee, 0xfc, 0x8f, 0xf2,
    0x4, 0xff, 0xff, 0xfc, 0x8f, 0xf2, 0x0, 0xbf,
    0xff, 0xfc, 0x8f, 0xf2, 0x0, 0x2f, 0xff, 0xfc,
    0x8f, 0xf2, 0x0, 0x9, 0xff, 0xfc, 0x8f, 0xf2,
    0x0, 0x1, 0xff, 0xfc, 0x8f, 0xf2, 0x0, 0x0,
    0x7f, 0xfc,

    /* U+004F "O" */
    0x0, 0x0, 0x7c, 0xff, 0xd8, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0xcf,
    0xff, 0xed, 0xff, 0xfd, 0x0, 0x6, 0xff, 0xf7,
    0x0, 0x5f, 0xff, 0x60, 0xc, 0xff, 0xd0, 0x0,
    0xb, 0xff, 0xd0, 0xf, 0xff, 0x80, 0x0, 0x7,
    0xff, 0xf1, 0x2f, 0xff, 0x60, 0x0, 0x5, 0xff,
    0xf3, 0x3f, 0xff, 0x60, 0x0, 0x4, 0xff, 0xf4,
    0x2f, 0xff, 0x60, 0x0, 0x5, 0xff, 0xf3, 0xf,
    0xff, 0x80, 0x0, 0x7, 0xff, 0xf1, 0xc, 0xff,
    0xd0, 0x0, 0xb, 0xff, 0xd0, 0x5, 0xff, 0xf7,
    0x0, 0x5f, 0xff, 0x70, 0x0, 0xcf, 0xff, 0xdd,
    0xff, 0xfd, 0x0, 0x0, 0x1d, 0xff, 0xff, 0xff,
    0xe2, 0x0, 0x0, 0x0, 0x7d, 0xff, 0xd8, 0x0,
    0x0,

    /* U+0050 "P" */
    0x8f, 0xff, 0xff, 0xfe, 0xb5, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0x90, 0x8f, 0xff, 0xaa, 0xbf,
    0xff, 0xf4, 0x8f, 0xfd, 0x0, 0x1, 0xff, 0xfa,
    0x8f, 0xfd, 0x0, 0x0, 0xaf, 0xfc, 0x8f, 0xfd,
    0x0, 0x0, 0xcf, 0xfc, 0x8f, 0xfd, 0x0, 0x16,
    0xff, 0xf8, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x50, 0x8f, 0xff,
    0xaa, 0xa9, 0x71, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x0, 0x7c, 0xff, 0xd8, 0x10, 0x0, 0x0,
    0x1d, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0xcf,
    0xff, 0xed, 0xff, 0xfe, 0x0, 0x5, 0xff, 0xf7,
    0x0, 0x4f, 0xff, 0x80, 0xb, 0xff, 0xd0, 0x0,
    0xa, 0xff, 0xe0, 0xf, 0xff, 0x80, 0x0, 0x6,
    0xff, 0xf2, 0x2f, 0xff, 0x60, 0x0, 0x4, 0xff,
    0xf5, 0x3f, 0xff, 0x60, 0x0, 0x3, 0xff, 0xf5,
    0x2f, 0xff, 0x60, 0x0, 0x3, 0xff, 0xf4, 0xf,
    0xff, 0x80, 0x0, 0x5, 0xff, 0xf3, 0xc, 0xff,
    0xc0, 0x0, 0xa, 0xff, 0xe0, 0x5, 0xff, 0xf5,
    0x0, 0x3f, 0xff, 0x80, 0x0, 0xcf, 0xff, 0xcc,
    0xff, 0xfd, 0x0, 0x0, 0x1d, 0xff, 0xff, 0xff,
    0xd2, 0x0, 0x0, 0x0, 0x7d, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xea, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xef, 0xc0,

    /* U+0052 "R" */
    0x8f, 0xff, 0xff, 0xff, 0xda, 0x20, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x30, 0x8f, 0xff, 0x99,
    0x9b, 0xff, 0xfc, 0x8, 0xff, 0xf0, 0x0, 0x9,
    0xff, 0xf2, 0x8f, 0xff, 0x0, 0x0, 0x4f, 0xff,
    0x38, 0xff, 0xf0, 0x0, 0x9, 0xff, 0xf2, 0x8f,
    0xff, 0x77, 0x8a, 0xff, 0xfc, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x10, 0x8f, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0x8, 0xff, 0xf0, 0x6, 0xff, 0xf3,
    0x0, 0x8f, 0xff, 0x0, 0x1f, 0xff, 0x90, 0x8,
    0xff, 0xf0, 0x0, 0xaf, 0xff, 0x0, 0x8f, 0xff,
    0x0, 0x4, 0xff, 0xf6, 0x8, 0xff, 0xf0, 0x0,
    0xe, 0xff, 0xd0, 0x8f, 0xff, 0x0, 0x0, 0x8f,
    0xff, 0x30,

    /* U+0053 "S" */
    0x0, 0x7, 0xdf, 0xfd, 0x92, 0x0, 0x1, 0xdf,
    0xff, 0xff, 0xff, 0x50, 0xb, 0xff, 0xfb, 0xbe,
    0xff, 0xf2, 0x1f, 0xff, 0x40, 0x1, 0xcf, 0xc4,
    0x3f, 0xff, 0x50, 0x0, 0x21, 0x0, 0x2f, 0xff,
    0xfb, 0x73, 0x0, 0x0, 0xd, 0xff, 0xff, 0xff,
    0xe9, 0x10, 0x2, 0xdf, 0xff, 0xff, 0xff, 0xd1,
    0x0, 0x6, 0xbf, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x38, 0xff, 0xfe, 0x26, 0x94, 0x0, 0x0,
    0x9f, 0xff, 0xdf, 0xfd, 0x10, 0x0, 0xcf, 0xfc,
    0x5f, 0xff, 0xfc, 0xce, 0xff, 0xf5, 0x8, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x3a, 0xdf, 0xfd,
    0xa3, 0x0,

    /* U+0054 "T" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0xee, 0xee, 0xff, 0xfe, 0xee,
    0xa0, 0x0, 0x5f, 0xff, 0x20, 0x0, 0x0, 0x5,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0x5f, 0xff, 0x20,
    0x0, 0x0, 0x5, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0x20, 0x0, 0x0, 0x5, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0x20, 0x0, 0x0,
    0x5, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0x20, 0x0, 0x0, 0x5, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0x20, 0x0, 0x0, 0x5, 0xff,
    0xf2, 0x0, 0x0,

    /* U+0055 "U" */
    0xaf, 0xff, 0x0, 0x0, 0xe, 0xff, 0xa, 0xff,
    0xf0, 0x0, 0x0, 0xef, 0xf0, 0xaf, 0xff, 0x0,
    0x0, 0xe, 0xff, 0xa, 0xff, 0xf0, 0x0, 0x0,
    0xef, 0xf0, 0xaf, 0xff, 0x0, 0x0, 0xe, 0xff,
    0xa, 0xff, 0xf0, 0x0, 0x0, 0xef, 0xf0, 0xaf,
    0xff, 0x0, 0x0, 0xe, 0xff, 0xa, 0xff, 0xf0,
    0x0, 0x0, 0xef, 0xf0, 0xaf, 0xff, 0x0, 0x0,
    0xe, 0xff, 0xa, 0xff, 0xf0, 0x0, 0x0, 0xef,
    0xf0, 0x9f, 0xff, 0x20, 0x0, 0xf, 0xff, 0x7,
    0xff, 0xf9, 0x0, 0x7, 0xff, 0xd0, 0x1f, 0xff,
    0xfe, 0xce, 0xff, 0xf7, 0x0, 0x5f, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x29, 0xdf, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+0056 "V" */
    0xf, 0xff, 0xa0, 0x0, 0x0, 0xaf, 0xf3, 0xb,
    0xff, 0xe0, 0x0, 0x0, 0xff, 0xe0, 0x6, 0xff,
    0xf2, 0x0, 0x3, 0xff, 0x90, 0x2, 0xff, 0xf7,
    0x0, 0x8, 0xff, 0x50, 0x0, 0xdf, 0xfb, 0x0,
    0xc, 0xff, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x1f,
    0xfb, 0x0, 0x0, 0x3f, 0xff, 0x40, 0x5f, 0xf7,
    0x0, 0x0, 0xe, 0xff, 0x80, 0xaf, 0xf2, 0x0,
    0x0, 0xa, 0xff, 0xd0, 0xef, 0xd0, 0x0, 0x0,
    0x5, 0xff, 0xf5, 0xff, 0x90, 0x0, 0x0, 0x1,
    0xff, 0xfd, 0xff, 0x40, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf1, 0x0,
    0x0,

    /* U+0057 "W" */
    0xbf, 0xfc, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0,
    0xdf, 0xe0, 0x7f, 0xff, 0x0, 0x1, 0xff, 0xfd,
    0x0, 0x1, 0xff, 0xb0, 0x3f, 0xff, 0x30, 0x4,
    0xff, 0xff, 0x10, 0x5, 0xff, 0x70, 0xf, 0xff,
    0x60, 0x8, 0xff, 0xff, 0x50, 0x8, 0xff, 0x30,
    0xb, 0xff, 0xa0, 0xc, 0xff, 0xff, 0x90, 0xc,
    0xff, 0x0, 0x7, 0xff, 0xd0, 0xf, 0xfc, 0xff,
    0xd0, 0xf, 0xfb, 0x0, 0x3, 0xff, 0xf1, 0x3f,
    0xf5, 0xff, 0xf1, 0x3f, 0xf7, 0x0, 0x0, 0xff,
    0xf4, 0x7f, 0xf0, 0xdf, 0xf4, 0x7f, 0xf3, 0x0,
    0x0, 0xbf, 0xf8, 0xbf, 0xc0, 0x9f, 0xf8, 0xbf,
    0xf0, 0x0, 0x0, 0x7f, 0xfc, 0xff, 0x80, 0x5f,
    0xfc, 0xef, 0xb0, 0x0, 0x0, 0x3f, 0xff, 0xff,
    0x50, 0x1f, 0xff, 0xff, 0x70, 0x0, 0x0, 0xf,
    0xff, 0xff, 0x10, 0xd, 0xff, 0xff, 0x30, 0x0,
    0x0, 0xb, 0xff, 0xfd, 0x0, 0x9, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xf9, 0x0, 0x5,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x3, 0xff, 0xf6,
    0x0, 0x1, 0xff, 0xf7, 0x0, 0x0,

    /* U+0058 "X" */
    0x2f, 0xff, 0xc0, 0x0, 0xd, 0xff, 0x50, 0x9,
    0xff, 0xf5, 0x0, 0x6f, 0xfc, 0x0, 0x1, 0xff,
    0xfd, 0x0, 0xef, 0xf3, 0x0, 0x0, 0x7f, 0xff,
    0x58, 0xff, 0x90, 0x0, 0x0, 0xd, 0xff, 0xef,
    0xff, 0x10, 0x0, 0x0, 0x4, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xe0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0xd, 0xff, 0xef, 0xff, 0x10, 0x0, 0x0, 0x6f,
    0xfb, 0x4f, 0xff, 0x90, 0x0, 0x1, 0xef, 0xf2,
    0xb, 0xff, 0xf2, 0x0, 0x8, 0xff, 0xa0, 0x2,
    0xff, 0xfb, 0x0, 0x2f, 0xff, 0x10, 0x0, 0xaf,
    0xff, 0x40, 0xaf, 0xf8, 0x0, 0x0, 0x2f, 0xff,
    0xd0,

    /* U+0059 "Y" */
    0x5f, 0xff, 0xa0, 0x0, 0x4, 0xff, 0xc0, 0xc,
    0xff, 0xf2, 0x0, 0xc, 0xff, 0x40, 0x4, 0xff,
    0xfa, 0x0, 0x3f, 0xfb, 0x0, 0x0, 0xbf, 0xff,
    0x20, 0xbf, 0xf3, 0x0, 0x0, 0x3f, 0xff, 0x93,
    0xff, 0xa0, 0x0, 0x0, 0xa, 0xff, 0xfc, 0xff,
    0x20, 0x0, 0x0, 0x2, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0x70, 0x0,
    0x0,

    /* U+005A "Z" */
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xc, 0xcc, 0xcc,
    0xcd, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x7f, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x1e, 0xff, 0xe1, 0x0, 0x0, 0x0, 0xb,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x8, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x1, 0xef, 0xfd, 0x10, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0x30, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xec, 0xcc, 0xcc, 0xcc, 0x39, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x40,

    /* U+005B "[" */
    0xdf, 0xff, 0xcd, 0xfc, 0x64, 0xdf, 0xa0, 0xd,
    0xfa, 0x0, 0xdf, 0xa0, 0xd, 0xfa, 0x0, 0xdf,
    0xa0, 0xd, 0xfa, 0x0, 0xdf, 0xa0, 0xd, 0xfa,
    0x0, 0xdf, 0xa0, 0xd, 0xfa, 0x0, 0xdf, 0xa0,
    0xd, 0xfa, 0x0, 0xdf, 0xa0, 0xd, 0xfa, 0x0,
    0xdf, 0xa0, 0xd, 0xfc, 0x54, 0xdf, 0xff, 0xc0,

    /* U+005C "\\" */
    0x2f, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xe0,

    /* U+005D "]" */
    0x5f, 0xff, 0xf4, 0x15, 0x7f, 0xf4, 0x0, 0x3f,
    0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0,
    0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4,
    0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f,
    0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0,
    0x3f, 0xf4, 0x0, 0x3f, 0xf4, 0x0, 0x3f, 0xf4,
    0x0, 0x3f, 0xf4, 0x16, 0x8f, 0xf4, 0x5f, 0xff,
    0xf4,

    /* U+005E "^" */
    0x0, 0x4, 0x88, 0x84, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xe0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0x50,
    0x0, 0xd, 0xff, 0x7f, 0xfd, 0x0, 0x4, 0xff,
    0xc0, 0xcf, 0xf4, 0x0, 0xcf, 0xf5, 0x5, 0xff,
    0xb0, 0x3f, 0xfd, 0x0, 0xd, 0xff, 0x3a, 0xff,
    0x60, 0x0, 0x6f, 0xfa,

    /* U+005F "_" */
    0x88, 0x88, 0x88, 0x88, 0x88, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0,

    /* U+0060 "`" */
    0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x4f, 0xfd,
    0x50, 0x1, 0x7d, 0xf8, 0x0, 0x0, 0x43,

    /* U+0061 "a" */
    0x0, 0x18, 0xdf, 0xfd, 0x92, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xe1, 0xc, 0xff, 0x92, 0x3e, 0xff,
    0x70, 0x68, 0x90, 0x0, 0xaf, 0xf9, 0x0, 0x2,
    0x68, 0xae, 0xff, 0x90, 0x2c, 0xff, 0xff, 0xff,
    0xf9, 0xd, 0xff, 0xc4, 0x9, 0xff, 0x93, 0xff,
    0xf2, 0x0, 0xbf, 0xf9, 0x3f, 0xff, 0x30, 0x3f,
    0xff, 0x90, 0xdf, 0xff, 0xdf, 0xcf, 0xf9, 0x2,
    0xae, 0xfc, 0x46, 0xff, 0xb0,

    /* U+0062 "b" */
    0xaf, 0xf8, 0x0, 0x0, 0x0, 0xa, 0xff, 0x80,
    0x0, 0x0, 0x0, 0xaf, 0xf8, 0x0, 0x0, 0x0,
    0xa, 0xff, 0x80, 0x0, 0x0, 0x0, 0xaf, 0xf8,
    0x7e, 0xfc, 0x30, 0xa, 0xff, 0xef, 0xff, 0xff,
    0x20, 0xaf, 0xff, 0x63, 0xcf, 0xfb, 0xa, 0xff,
    0xb0, 0x3, 0xff, 0xf0, 0xaf, 0xf8, 0x0, 0x1f,
    0xff, 0x2a, 0xff, 0x80, 0x0, 0xff, 0xf3, 0xaf,
    0xf8, 0x0, 0x1f, 0xff, 0x2a, 0xff, 0xa0, 0x4,
    0xff, 0xf0, 0xaf, 0xff, 0x64, 0xdf, 0xfa, 0xa,
    0xf9, 0xef, 0xff, 0xfe, 0x20, 0xaf, 0x22, 0xcf,
    0xfb, 0x20, 0x0,

    /* U+0063 "c" */
    0x0, 0x6, 0xcf, 0xfc, 0x60, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xa0, 0x8, 0xff, 0xf9, 0x7e, 0xff,
    0x50, 0xff, 0xf9, 0x0, 0x4f, 0xfb, 0x3f, 0xff,
    0x50, 0x0, 0x22, 0x24, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0x50, 0x0, 0x44, 0x30, 0xff,
    0xf9, 0x0, 0x6f, 0xfb, 0x9, 0xff, 0xfb, 0xaf,
    0xff, 0x50, 0xc, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x7, 0xdf, 0xfc, 0x50, 0x0,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0x9, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x9f, 0xf8, 0x0, 0x0, 0x0, 0x9, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x9f, 0xf8, 0x0, 0x4c,
    0xfe, 0x89, 0xff, 0x80, 0x3f, 0xff, 0xff, 0xff,
    0xf8, 0xb, 0xff, 0xe5, 0x6f, 0xff, 0x80, 0xff,
    0xf6, 0x0, 0xbf, 0xf8, 0x3f, 0xff, 0x20, 0x9,
    0xff, 0x84, 0xff, 0xf1, 0x0, 0x9f, 0xf8, 0x3f,
    0xff, 0x10, 0x9, 0xff, 0x81, 0xff, 0xf4, 0x0,
    0xaf, 0xf8, 0xc, 0xff, 0xc1, 0x4f, 0xff, 0x80,
    0x4f, 0xff, 0xff, 0xcf, 0xf8, 0x0, 0x4d, 0xfd,
    0x66, 0xff, 0x80,

    /* U+0065 "e" */
    0x0, 0x6, 0xcf, 0xfc, 0x50, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xf9, 0x0, 0x8, 0xff, 0xc2, 0x2b,
    0xff, 0x50, 0xf, 0xff, 0x30, 0x2, 0xff, 0xb0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x4f, 0xff,
    0xdd, 0xdd, 0xdd, 0xd0, 0x3f, 0xff, 0x10, 0x0,
    0x0, 0x0, 0xf, 0xff, 0x50, 0x1, 0xfe, 0xa0,
    0x8, 0xff, 0xe6, 0x4c, 0xff, 0x60, 0x0, 0xbf,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x6, 0xcf, 0xfc,
    0x60, 0x0,

    /* U+0066 "f" */
    0x0, 0x2, 0x67, 0x50, 0x8, 0xff, 0xfe, 0x2,
    0xff, 0xff, 0xe0, 0x5f, 0xfd, 0x10, 0x6, 0xff,
    0xa0, 0xb, 0xff, 0xff, 0xfa, 0xbf, 0xff, 0xff,
    0xa5, 0xbf, 0xfd, 0x74, 0x7, 0xff, 0xa0, 0x0,
    0x7f, 0xfa, 0x0, 0x7, 0xff, 0xa0, 0x0, 0x7f,
    0xfa, 0x0, 0x7, 0xff, 0xa0, 0x0, 0x7f, 0xfa,
    0x0, 0x7, 0xff, 0xa0, 0x0, 0x7f, 0xfa, 0x0,

    /* U+0067 "g" */
    0x0, 0x0, 0x0, 0x0, 0x7, 0xef, 0x20, 0x2,
    0x9d, 0xff, 0xa3, 0xff, 0xf2, 0x4, 0xff, 0xfc,
    0xdf, 0xff, 0x40, 0x0, 0xdf, 0xf7, 0x0, 0x9f,
    0xfa, 0x0, 0xf, 0xff, 0x30, 0x4, 0xff, 0xe0,
    0x0, 0xef, 0xf7, 0x0, 0x9f, 0xfc, 0x0, 0x4,
    0xff, 0xfc, 0xdf, 0xff, 0x40, 0x0, 0xa, 0xfe,
    0xff, 0xda, 0x20, 0x0, 0xd, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xfa, 0x88, 0x87, 0x62,
    0x0, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x7f, 0xf3,
    0x0, 0x1, 0x4f, 0xff, 0xb, 0xff, 0x50, 0x0,
    0x4, 0xff, 0xd0, 0x6f, 0xff, 0xfe, 0xef, 0xff,
    0xe3, 0x0, 0x4a, 0xdf, 0xff, 0xec, 0x81, 0x0,

    /* U+0068 "h" */
    0xaf, 0xf6, 0x0, 0x0, 0x0, 0xaf, 0xf6, 0x0,
    0x0, 0x0, 0xaf, 0xf6, 0x0, 0x0, 0x0, 0xaf,
    0xf6, 0x0, 0x0, 0x0, 0xaf, 0xf6, 0x7e, 0xfc,
    0x40, 0xaf, 0xfd, 0xff, 0xff, 0xf3, 0xaf, 0xff,
    0xb9, 0xff, 0xf8, 0xaf, 0xfa, 0x0, 0xaf, 0xf9,
    0xaf, 0xf7, 0x0, 0x8f, 0xfa, 0xaf, 0xf6, 0x0,
    0x8f, 0xfa, 0xaf, 0xf6, 0x0, 0x8f, 0xfa, 0xaf,
    0xf6, 0x0, 0x8f, 0xfa, 0xaf, 0xf6, 0x0, 0x8f,
    0xfa, 0xaf, 0xf6, 0x0, 0x8f, 0xfa, 0xaf, 0xf6,
    0x0, 0x8f, 0xfa,

    /* U+0069 "i" */
    0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8, 0x23, 0x31,
    0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8,
    0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8,
    0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8,

    /* U+006A "j" */
    0x0, 0xbf, 0xf9, 0x0, 0xbf, 0xf9, 0x0, 0xbf,
    0xf9, 0x0, 0x23, 0x32, 0x0, 0xbf, 0xf9, 0x0,
    0xbf, 0xf9, 0x0, 0xbf, 0xf9, 0x0, 0xbf, 0xf9,
    0x0, 0xbf, 0xf9, 0x0, 0xbf, 0xf9, 0x0, 0xbf,
    0xf9, 0x0, 0xbf, 0xf9, 0x0, 0xbf, 0xf9, 0x0,
    0xbf, 0xf9, 0x0, 0xbf, 0xf9, 0x0, 0xdf, 0xf9,
    0x7b, 0xff, 0xf7, 0xaf, 0xff, 0xf2, 0x9f, 0xfc,
    0x40,

    /* U+006B "k" */
    0xaf, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xf5, 0x0, 0x1d, 0xff, 0x30, 0xaf, 0xf5,
    0x0, 0xcf, 0xf5, 0x0, 0xaf, 0xf5, 0x9, 0xff,
    0x80, 0x0, 0xaf, 0xf5, 0x7f, 0xfb, 0x0, 0x0,
    0xaf, 0xf9, 0xff, 0xfd, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0x50, 0x0, 0xaf, 0xff, 0xc9, 0xff,
    0xd0, 0x0, 0xaf, 0xfd, 0x11, 0xff, 0xf5, 0x0,
    0xaf, 0xf5, 0x0, 0xaf, 0xfc, 0x0, 0xaf, 0xf5,
    0x0, 0x3f, 0xff, 0x40, 0xaf, 0xf5, 0x0, 0xb,
    0xff, 0xc0,

    /* U+006C "l" */
    0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8,
    0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8,
    0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8,
    0xaf, 0xf8, 0xaf, 0xf8, 0xaf, 0xf8,

    /* U+006D "m" */
    0xaf, 0xf5, 0x8e, 0xfd, 0x50, 0x7d, 0xfd, 0x60,
    0xaf, 0xfd, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xf6,
    0xaf, 0xff, 0x66, 0xff, 0xff, 0x85, 0xdf, 0xfb,
    0xaf, 0xf9, 0x0, 0xaf, 0xfc, 0x0, 0x7f, 0xfc,
    0xaf, 0xf7, 0x0, 0x8f, 0xfa, 0x0, 0x6f, 0xfd,
    0xaf, 0xf6, 0x0, 0x8f, 0xfa, 0x0, 0x6f, 0xfd,
    0xaf, 0xf6, 0x0, 0x8f, 0xfa, 0x0, 0x6f, 0xfd,
    0xaf, 0xf6, 0x0, 0x8f, 0xfa, 0x0, 0x6f, 0xfd,
    0xaf, 0xf6, 0x0, 0x8f, 0xfa, 0x0, 0x6f, 0xfd,
    0xaf, 0xf6, 0x0, 0x8f, 0xfa, 0x0, 0x6f, 0xfd,
    0xaf, 0xf6, 0x0, 0x8f, 0xfa, 0x0, 0x6f, 0xfd,

    /* U+006E "n" */
    0xaf, 0xf4, 0x7e, 0xfc, 0x50, 0xaf, 0xfb, 0xff,
    0xff, 0xf4, 0xaf, 0xff, 0x75, 0xef, 0xf9, 0xaf,
    0xfb, 0x0, 0x8f, 0xfb, 0xaf, 0xf8, 0x0, 0x7f,
    0xfb, 0xaf, 0xf8, 0x0, 0x7f, 0xfc, 0xaf, 0xf8,
    0x0, 0x7f, 0xfc, 0xaf, 0xf8, 0x0, 0x7f, 0xfc,
    0xaf, 0xf8, 0x0, 0x7f, 0xfc, 0xaf, 0xf8, 0x0,
    0x7f, 0xfc, 0xaf, 0xf8, 0x0, 0x7f, 0xfc,

    /* U+006F "o" */
    0x0, 0x7, 0xdf, 0xfc, 0x50, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xf9, 0x0, 0x9, 0xff, 0xc2, 0x3e,
    0xff, 0x50, 0xf, 0xff, 0x40, 0x7, 0xff, 0xc0,
    0x3f, 0xff, 0x10, 0x5, 0xff, 0xf0, 0x4f, 0xff,
    0x10, 0x4, 0xff, 0xf1, 0x3f, 0xff, 0x20, 0x5,
    0xff, 0xf0, 0xf, 0xff, 0x40, 0x7, 0xff, 0xc0,
    0x8, 0xff, 0xd2, 0x4e, 0xff, 0x40, 0x0, 0xcf,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x7, 0xdf, 0xfb,
    0x50, 0x0,

    /* U+0070 "p" */
    0xaf, 0xf5, 0x9e, 0xfb, 0x20, 0xa, 0xff, 0xef,
    0xff, 0xfe, 0x10, 0xaf, 0xfe, 0x21, 0xcf, 0xf9,
    0xa, 0xff, 0x80, 0x5, 0xff, 0xe0, 0xaf, 0xf6,
    0x0, 0x3f, 0xff, 0x1a, 0xff, 0x60, 0x2, 0xff,
    0xf1, 0xaf, 0xf6, 0x0, 0x3f, 0xff, 0xa, 0xff,
    0x80, 0x6, 0xff, 0xe0, 0xaf, 0xff, 0x65, 0xef,
    0xf9, 0xa, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xaf,
    0xf7, 0x9f, 0xfb, 0x20, 0xa, 0xff, 0x60, 0x0,
    0x0, 0x0, 0xaf, 0xf6, 0x0, 0x0, 0x0, 0xa,
    0xff, 0x60, 0x0, 0x0, 0x0, 0xaf, 0xf6, 0x0,
    0x0, 0x0, 0x0,

    /* U+0071 "q" */
    0x0, 0x2a, 0xef, 0xc3, 0x2f, 0xb0, 0x2e, 0xff,
    0xff, 0xfb, 0xfa, 0xb, 0xff, 0xd4, 0x5f, 0xff,
    0xa0, 0xff, 0xf5, 0x0, 0x9f, 0xfa, 0x3f, 0xff,
    0x20, 0x7, 0xff, 0xa4, 0xff, 0xf1, 0x0, 0x7f,
    0xfa, 0x3f, 0xff, 0x20, 0x7, 0xff, 0xa0, 0xff,
    0xf5, 0x0, 0xbf, 0xfa, 0xb, 0xff, 0xd4, 0x7f,
    0xff, 0xa0, 0x3f, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x3b, 0xfe, 0x87, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x7f, 0xfa, 0x0, 0x0, 0x0, 0x7, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x7f, 0xfa, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xa0,

    /* U+0072 "r" */
    0x0, 0x0, 0x0, 0xa, 0xff, 0x4a, 0xf2, 0xaf,
    0xfc, 0xff, 0x2a, 0xff, 0xff, 0xf2, 0xaf, 0xff,
    0x60, 0xa, 0xff, 0xb0, 0x0, 0xaf, 0xf7, 0x0,
    0xa, 0xff, 0x60, 0x0, 0xaf, 0xf6, 0x0, 0xa,
    0xff, 0x60, 0x0, 0xaf, 0xf6, 0x0, 0xa, 0xff,
    0x60, 0x0,

    /* U+0073 "s" */
    0x0, 0x6c, 0xef, 0xd7, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xa0, 0x4f, 0xf9, 0x0, 0x8f, 0xf3, 0x7f,
    0xfb, 0x30, 0x4, 0x0, 0x4f, 0xff, 0xff, 0xea,
    0x30, 0xa, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x38,
    0xce, 0xff, 0xfc, 0x25, 0x70, 0x0, 0x2f, 0xfe,
    0x9f, 0xf9, 0x32, 0x6f, 0xfa, 0x1d, 0xff, 0xff,
    0xff, 0xe2, 0x1, 0x8d, 0xff, 0xd9, 0x10,

    /* U+0074 "t" */
    0x0, 0x24, 0x50, 0x0, 0x0, 0xef, 0xe0, 0x0,
    0x0, 0xff, 0xe0, 0x0, 0x0, 0xff, 0xe0, 0x0,
    0xff, 0xff, 0xff, 0xf4, 0xff, 0xff, 0xff, 0xf4,
    0x79, 0xff, 0xf7, 0x71, 0x4, 0xff, 0xe0, 0x0,
    0x4, 0xff, 0xe0, 0x0, 0x4, 0xff, 0xe0, 0x0,
    0x4, 0xff, 0xe0, 0x0, 0x4, 0xff, 0xf0, 0x0,
    0x2, 0xff, 0xfb, 0x83, 0x0, 0xef, 0xff, 0xf6,
    0x0, 0x3b, 0xff, 0xe5,

    /* U+0075 "u" */
    0xaf, 0xf6, 0x0, 0x9f, 0xf9, 0xaf, 0xf6, 0x0,
    0x9f, 0xf9, 0xaf, 0xf6, 0x0, 0x9f, 0xf9, 0xaf,
    0xf6, 0x0, 0x9f, 0xf9, 0xaf, 0xf6, 0x0, 0x9f,
    0xf9, 0xaf, 0xf6, 0x0, 0x9f, 0xf9, 0xaf, 0xf6,
    0x0, 0x9f, 0xf9, 0xaf, 0xf7, 0x0, 0xbf, 0xf9,
    0x8f, 0xfd, 0x58, 0xff, 0xf9, 0x4f, 0xff, 0xff,
    0xcf, 0xf9, 0x7, 0xef, 0xd6, 0x6f, 0xf9,

    /* U+0076 "v" */
    0xe, 0xff, 0x60, 0x0, 0xaf, 0xa0, 0x9f, 0xfb,
    0x0, 0xf, 0xf5, 0x3, 0xff, 0xf0, 0x4, 0xff,
    0x0, 0xe, 0xff, 0x40, 0x9f, 0xa0, 0x0, 0x8f,
    0xf9, 0xe, 0xf5, 0x0, 0x3, 0xff, 0xe3, 0xff,
    0x0, 0x0, 0xe, 0xff, 0xbf, 0xa0, 0x0, 0x0,
    0x8f, 0xff, 0xf5, 0x0, 0x0, 0x3, 0xff, 0xff,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x8f, 0xf4, 0x0, 0x0,

    /* U+0077 "w" */
    0xbf, 0xf9, 0x0, 0x4f, 0xfe, 0x0, 0xe, 0xf8,
    0x6f, 0xfd, 0x0, 0x7f, 0xff, 0x20, 0x3f, 0xf3,
    0x1f, 0xff, 0x10, 0xbf, 0xff, 0x50, 0x7f, 0xe0,
    0xd, 0xff, 0x50, 0xff, 0xff, 0x90, 0xcf, 0xa0,
    0x8, 0xff, 0xa3, 0xfc, 0xff, 0xd0, 0xff, 0x50,
    0x3, 0xff, 0xe7, 0xf7, 0xcf, 0xf5, 0xff, 0x0,
    0x0, 0xef, 0xfd, 0xf3, 0x8f, 0xfd, 0xfb, 0x0,
    0x0, 0x9f, 0xff, 0xf0, 0x4f, 0xff, 0xf7, 0x0,
    0x0, 0x4f, 0xff, 0xc0, 0xf, 0xff, 0xf2, 0x0,
    0x0, 0xf, 0xff, 0x80, 0xc, 0xff, 0xd0, 0x0,
    0x0, 0xb, 0xff, 0x40, 0x8, 0xff, 0x80, 0x0,

    /* U+0078 "x" */
    0x3f, 0xff, 0x60, 0xb, 0xfe, 0x10, 0x9f, 0xfe,
    0x14, 0xff, 0x60, 0x1, 0xef, 0xf9, 0xdf, 0xc0,
    0x0, 0x6, 0xff, 0xff, 0xf3, 0x0, 0x0, 0xc,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0xaf, 0xff, 0x70,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0x10, 0x0, 0xd,
    0xfc, 0xdf, 0xfb, 0x0, 0x7, 0xff, 0x34, 0xff,
    0xf4, 0x2, 0xff, 0x90, 0xb, 0xff, 0xe0, 0xbf,
    0xf1, 0x0, 0x2f, 0xff, 0x80,

    /* U+0079 "y" */
    0xe, 0xff, 0x70, 0x0, 0xcf, 0x80, 0x8f, 0xfc,
    0x0, 0x1f, 0xf3, 0x3, 0xff, 0xf1, 0x5, 0xfe,
    0x0, 0xd, 0xff, 0x60, 0xaf, 0x90, 0x0, 0x7f,
    0xfb, 0xf, 0xf4, 0x0, 0x2, 0xff, 0xf5, 0xff,
    0x0, 0x0, 0xc, 0xff, 0xdf, 0xa0, 0x0, 0x0,
    0x6f, 0xff, 0xf5, 0x0, 0x0, 0x1, 0xff, 0xff,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x5f, 0xf6, 0x0, 0x0, 0x0, 0x4, 0xff,
    0x10, 0x0, 0x4, 0x77, 0xdf, 0xa0, 0x0, 0x0,
    0x7f, 0xff, 0xf3, 0x0, 0x0, 0x6, 0xff, 0xc4,
    0x0, 0x0, 0x0,

    /* U+007A "z" */
    0x2f, 0xff, 0xff, 0xff, 0xc2, 0xff, 0xff, 0xff,
    0xfc, 0x2, 0x22, 0x4f, 0xff, 0x60, 0x0, 0xc,
    0xff, 0xa0, 0x0, 0x7, 0xff, 0xe1, 0x0, 0x3,
    0xff, 0xf3, 0x0, 0x1, 0xef, 0xf8, 0x0, 0x0,
    0xbf, 0xfc, 0x0, 0x0, 0x6f, 0xff, 0x75, 0x55,
    0x49, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff,
    0xff, 0xf0,

    /* U+007B "{" */
    0x0, 0x2c, 0xff, 0x10, 0xb, 0xfe, 0x40, 0x0,
    0xdf, 0xc0, 0x0, 0xe, 0xfc, 0x0, 0x0, 0xef,
    0xc0, 0x0, 0xe, 0xfc, 0x0, 0x0, 0xef, 0xc0,
    0x0, 0xe, 0xfa, 0x0, 0x8, 0xff, 0x60, 0x1,
    0xff, 0xc0, 0x0, 0x5, 0xff, 0x60, 0x0, 0xe,
    0xfb, 0x0, 0x0, 0xef, 0xc0, 0x0, 0xe, 0xfc,
    0x0, 0x0, 0xef, 0xc0, 0x0, 0xe, 0xfc, 0x0,
    0x0, 0xdf, 0xc0, 0x0, 0xa, 0xfe, 0x50, 0x0,
    0x2c, 0xff, 0x10,

    /* U+007C "|" */
    0xf, 0xff, 0x0, 0xff, 0xf0, 0xf, 0xff, 0x0,
    0xff, 0xf0, 0xf, 0xff, 0x0, 0xff, 0xf0, 0xf,
    0xff, 0x0, 0xff, 0xf0, 0xf, 0xff, 0x0, 0xff,
    0xf0, 0xf, 0xff, 0x0, 0xff, 0xf0, 0xf, 0xff,
    0x0, 0xff, 0xf0, 0xf, 0xff, 0x0, 0xff, 0xf0,
    0xf, 0xff, 0x0, 0xff, 0xf0, 0xf, 0xff, 0x0,

    /* U+007D "}" */
    0x1f, 0xfc, 0x20, 0x0, 0x5f, 0xfa, 0x0, 0x0,
    0xdf, 0xc0, 0x0, 0xd, 0xfd, 0x0, 0x0, 0xdf,
    0xd0, 0x0, 0xd, 0xfd, 0x0, 0x0, 0xcf, 0xd0,
    0x0, 0xb, 0xfe, 0x0, 0x0, 0x6f, 0xf4, 0x0,
    0x0, 0xcf, 0xf1, 0x0, 0x7f, 0xf7, 0x0, 0xb,
    0xfe, 0x0, 0x0, 0xcf, 0xd0, 0x0, 0xd, 0xfd,
    0x0, 0x0, 0xdf, 0xd0, 0x0, 0xd, 0xfd, 0x0,
    0x0, 0xdf, 0xc0, 0x0, 0x5f, 0xf9, 0x0, 0x1f,
    0xfc, 0x10, 0x0,

    /* U+007E "~" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4c, 0xfc,
    0x72, 0x4, 0xc2, 0x2f, 0xff, 0xff, 0xfe, 0xff,
    0x8a, 0xff, 0xef, 0xff, 0xff, 0xd1, 0x5e, 0x30,
    0x38, 0xdf, 0xb2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+00B0 "°" */
    0x4, 0xcf, 0xc3, 0x2, 0xfe, 0xae, 0xe1, 0x8f,
    0x10, 0x3f, 0x68, 0xf2, 0x3, 0xf6, 0x2f, 0xea,
    0xee, 0x10, 0x4c, 0xfc, 0x30,

    /* U+0410 "А" */
    0x0, 0x0, 0x7f, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0xb, 0xff, 0xaf,
    0xff, 0x10, 0x0, 0x0, 0xf, 0xfd, 0x3f, 0xff,
    0x50, 0x0, 0x0, 0x5f, 0xf9, 0xe, 0xff, 0xa0,
    0x0, 0x0, 0xaf, 0xf4, 0xa, 0xff, 0xf0, 0x0,
    0x0, 0xff, 0xf0, 0x5, 0xff, 0xf4, 0x0, 0x4,
    0xff, 0xfb, 0xbb, 0xff, 0xf9, 0x0, 0x9, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0x3f, 0xfc, 0x0, 0x0,
    0x2f, 0xff, 0x80, 0x8f, 0xf7, 0x0, 0x0, 0xd,
    0xff, 0xc0, 0xdf, 0xf2, 0x0, 0x0, 0x9, 0xff,
    0xf1,

    /* U+0411 "Б" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x40, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0x40, 0x8f, 0xff, 0x99, 0x99,
    0x99, 0x20, 0x8f, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xfe, 0x99, 0x87,
    0x62, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x8f, 0xfd,
    0x0, 0x3, 0xef, 0xfb, 0x8f, 0xfd, 0x0, 0x0,
    0x9f, 0xfd, 0x8f, 0xfd, 0x0, 0x0, 0xdf, 0xfd,
    0x8f, 0xff, 0xcc, 0xce, 0xff, 0xf8, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xd1, 0x8f, 0xff, 0xff, 0xff,
    0xd8, 0x0,

    /* U+0412 "В" */
    0x8f, 0xff, 0xff, 0xff, 0xeb, 0x30, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x8f, 0xff, 0x99,
    0x9a, 0xff, 0xfe, 0x8, 0xff, 0xe0, 0x0, 0x8,
    0xff, 0xf2, 0x8f, 0xfe, 0x0, 0x0, 0x6f, 0xff,
    0x18, 0xff, 0xe0, 0x0, 0x2c, 0xff, 0xc0, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xc1, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xe6, 0x0, 0x8f, 0xff, 0x99, 0x9b,
    0xff, 0xfa, 0x8, 0xff, 0xe0, 0x0, 0x4, 0xff,
    0xf4, 0x8f, 0xfe, 0x0, 0x0, 0xf, 0xff, 0x88,
    0xff, 0xe0, 0x0, 0x5, 0xff, 0xf8, 0x8f, 0xff,
    0xbb, 0xbd, 0xff, 0xff, 0x38, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x8f, 0xff, 0xff, 0xff, 0xeb,
    0x50, 0x0,

    /* U+0413 "Г" */
    0x8f, 0xff, 0xff, 0xff, 0xd8, 0xff, 0xff, 0xff,
    0xfd, 0x8f, 0xff, 0xee, 0xee, 0xc8, 0xff, 0xd0,
    0x0, 0x0, 0x8f, 0xfd, 0x0, 0x0, 0x8, 0xff,
    0xd0, 0x0, 0x0, 0x8f, 0xfd, 0x0, 0x0, 0x8,
    0xff, 0xd0, 0x0, 0x0, 0x8f, 0xfd, 0x0, 0x0,
    0x8, 0xff, 0xd0, 0x0, 0x0, 0x8f, 0xfd, 0x0,
    0x0, 0x8, 0xff, 0xd0, 0x0, 0x0, 0x8f, 0xfd,
    0x0, 0x0, 0x8, 0xff, 0xd0, 0x0, 0x0, 0x8f,
    0xfd, 0x0, 0x0, 0x0,

    /* U+0414 "Д" */
    0x0, 0x0, 0xf, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xfd, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0x2f, 0xff, 0x40, 0x0, 0x0, 0x0,
    0xff, 0xc0, 0xef, 0xf8, 0x0, 0x0, 0x0, 0x3f,
    0xf8, 0xa, 0xff, 0xc0, 0x0, 0x0, 0x7, 0xff,
    0x50, 0x7f, 0xff, 0x0, 0x0, 0x0, 0xbf, 0xf1,
    0x4, 0xff, 0xf4, 0x0, 0x0, 0xf, 0xfe, 0x0,
    0xf, 0xff, 0x80, 0x0, 0x3, 0xff, 0xa0, 0x0,
    0xdf, 0xfc, 0x0, 0x0, 0x7f, 0xf7, 0x0, 0x9,
    0xff, 0xf0, 0x0, 0xb, 0xff, 0x30, 0x0, 0x6f,
    0xff, 0x40, 0x3c, 0xff, 0xfc, 0xcc, 0xcc, 0xff,
    0xfd, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe5, 0xff, 0x30, 0x0, 0x0, 0x0, 0xa, 0xfe,
    0x5f, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xe5,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfe, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,

    /* U+0415 "Е" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0xff, 0xcc, 0xcc, 0xcc,
    0xb8, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xbb, 0xbb, 0xb5, 0x8, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x8f, 0xff, 0xff, 0xff,
    0xf7, 0x8, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0x0, 0x0, 0x0, 0x8, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xee, 0xee, 0xee, 0xd8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xf0,

    /* U+0416 "Ж" */
    0x9, 0xff, 0xe0, 0x0, 0xf, 0xff, 0x20, 0x0,
    0xcf, 0xf5, 0x0, 0x1e, 0xff, 0x80, 0x0, 0xff,
    0xf2, 0x0, 0x6f, 0xfa, 0x0, 0x0, 0x5f, 0xff,
    0x20, 0xf, 0xff, 0x20, 0x1f, 0xfe, 0x10, 0x0,
    0x0, 0xbf, 0xfc, 0x0, 0xff, 0xf2, 0xa, 0xff,
    0x50, 0x0, 0x0, 0x2, 0xff, 0xf5, 0xf, 0xff,
    0x24, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xe1, 0xff, 0xf2, 0xdf, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xdf, 0xff, 0xdf, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xff,
    0x8f, 0xff, 0x8e, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0x70, 0xff, 0xf2, 0x6f, 0xff, 0x50,
    0x0, 0x0, 0x4, 0xff, 0xc0, 0xf, 0xff, 0x20,
    0xbf, 0xfe, 0x0, 0x0, 0x1, 0xef, 0xf2, 0x0,
    0xff, 0xf2, 0x2, 0xff, 0xf9, 0x0, 0x0, 0xaf,
    0xf8, 0x0, 0xf, 0xff, 0x20, 0x6, 0xff, 0xf3,
    0x0, 0x5f, 0xfd, 0x0, 0x0, 0xff, 0xf2, 0x0,
    0xc, 0xff, 0xd0, 0x1e, 0xff, 0x30, 0x0, 0xf,
    0xff, 0x20, 0x0, 0x2f, 0xff, 0x70,

    /* U+0417 "З" */
    0x0, 0x18, 0xdf, 0xfe, 0xb5, 0x0, 0x0, 0x2e,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0xd, 0xff, 0xfd,
    0xdf, 0xff, 0xf7, 0x3, 0xff, 0xe2, 0x0, 0x2e,
    0xff, 0xb0, 0x15, 0x85, 0x0, 0x0, 0xcf, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0x30, 0x0,
    0x0, 0xa, 0xff, 0xfc, 0x30, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x2, 0x47,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xf1, 0x8e, 0xf8, 0x0, 0x0, 0x7f, 0xff, 0x28,
    0xff, 0xf3, 0x0, 0x1d, 0xff, 0xf0, 0x1f, 0xff,
    0xfd, 0xdf, 0xff, 0xf9, 0x0, 0x5f, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x29, 0xdf, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+0418 "И" */
    0x8f, 0xfd, 0x0, 0x0, 0x2f, 0xff, 0x38, 0xff,
    0xd0, 0x0, 0x3, 0xff, 0xf3, 0x8f, 0xfd, 0x0,
    0x0, 0xcf, 0xff, 0x38, 0xff, 0xd0, 0x0, 0x7f,
    0xff, 0xf3, 0x8f, 0xfd, 0x0, 0x3f, 0xff, 0xff,
    0x38, 0xff, 0xd0, 0xd, 0xfe, 0xff, 0xf3, 0x8f,
    0xfd, 0x8, 0xff, 0x8f, 0xff, 0x38, 0xff, 0xc2,
    0xff, 0xd3, 0xff, 0xf3, 0x8f, 0xfc, 0xaf, 0xf4,
    0x2f, 0xff, 0x38, 0xff, 0xef, 0xf9, 0x2, 0xff,
    0xf3, 0x8f, 0xff, 0xfd, 0x0, 0x2f, 0xff, 0x38,
    0xff, 0xff, 0x30, 0x2, 0xff, 0xf3, 0x8f, 0xff,
    0x80, 0x0, 0x2f, 0xff, 0x38, 0xff, 0xe0, 0x0,
    0x2, 0xff, 0xf3, 0x8f, 0xfd, 0x0, 0x0, 0x2f,
    0xff, 0x30,

    /* U+0419 "Й" */
    0x4, 0xf7, 0x0, 0x6f, 0x40, 0x0, 0x0, 0xd,
    0xfb, 0xbf, 0xd0, 0x0, 0x0, 0x0, 0x2a, 0xee,
    0xa2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xfd, 0x0, 0x0, 0x2f, 0xff,
    0x38, 0xff, 0xd0, 0x0, 0x3, 0xff, 0xf3, 0x8f,
    0xfd, 0x0, 0x0, 0xcf, 0xff, 0x38, 0xff, 0xd0,
    0x0, 0x7f, 0xff, 0xf3, 0x8f, 0xfd, 0x0, 0x3f,
    0xff, 0xff, 0x38, 0xff, 0xd0, 0xd, 0xfe, 0xff,
    0xf3, 0x8f, 0xfd, 0x8, 0xff, 0x8f, 0xff, 0x38,
    0xff, 0xc2, 0xff, 0xd3, 0xff, 0xf3, 0x8f, 0xfc,
    0xaf, 0xf4, 0x2f, 0xff, 0x38, 0xff, 0xef, 0xf9,
    0x2, 0xff, 0xf3, 0x8f, 0xff, 0xfd, 0x0, 0x2f,
    0xff, 0x38, 0xff, 0xff, 0x30, 0x2, 0xff, 0xf3,
    0x8f, 0xff, 0x80, 0x0, 0x2f, 0xff, 0x38, 0xff,
    0xe0, 0x0, 0x2, 0xff, 0xf3, 0x8f, 0xfd, 0x0,
    0x0, 0x2f, 0xff, 0x30,

    /* U+041A "К" */
    0x8f, 0xfd, 0x0, 0x0, 0xdf, 0xf6, 0x8, 0xff,
    0xd0, 0x0, 0x8f, 0xfb, 0x0, 0x8f, 0xfd, 0x0,
    0x3f, 0xff, 0x20, 0x8, 0xff, 0xd0, 0xd, 0xff,
    0x60, 0x0, 0x8f, 0xfd, 0x7, 0xff, 0xc0, 0x0,
    0x8, 0xff, 0xd2, 0xff, 0xf5, 0x0, 0x0, 0x8f,
    0xfd, 0xcf, 0xff, 0xb0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x0, 0x8f, 0xff, 0xfe, 0xff,
    0xfa, 0x0, 0x8, 0xff, 0xff, 0x3a, 0xff, 0xf1,
    0x0, 0x8f, 0xff, 0x80, 0x3f, 0xff, 0x80, 0x8,
    0xff, 0xe0, 0x0, 0xcf, 0xff, 0x0, 0x8f, 0xfd,
    0x0, 0x4, 0xff, 0xf7, 0x8, 0xff, 0xd0, 0x0,
    0xd, 0xff, 0xe0, 0x8f, 0xfd, 0x0, 0x0, 0x6f,
    0xff, 0x60,

    /* U+041B "Л" */
    0x0, 0x0, 0x5f, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0x10, 0x0, 0x0, 0x2, 0xff,
    0xcf, 0xff, 0x60, 0x0, 0x0, 0x7, 0xff, 0x6d,
    0xff, 0xa0, 0x0, 0x0, 0xb, 0xff, 0x29, 0xff,
    0xe0, 0x0, 0x0, 0xf, 0xfe, 0x5, 0xff, 0xf3,
    0x0, 0x0, 0x4f, 0xfa, 0x1, 0xff, 0xf7, 0x0,
    0x0, 0x8f, 0xf6, 0x0, 0xdf, 0xfc, 0x0, 0x0,
    0xdf, 0xf2, 0x0, 0x8f, 0xff, 0x10, 0x1, 0xff,
    0xd0, 0x0, 0x4f, 0xff, 0x50, 0x5, 0xff, 0x90,
    0x0, 0xf, 0xff, 0x90, 0xa, 0xff, 0x50, 0x0,
    0xc, 0xff, 0xe0, 0xe, 0xff, 0x10, 0x0, 0x8,
    0xff, 0xf2, 0x3f, 0xfd, 0x0, 0x0, 0x4, 0xff,
    0xf7,

    /* U+041C "М" */
    0x8f, 0xff, 0xfe, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0x78, 0xff, 0xff, 0xf3, 0x0, 0x6, 0xff, 0xff,
    0xf7, 0x8f, 0xff, 0xff, 0x80, 0x0, 0xaf, 0xff,
    0xff, 0x78, 0xff, 0xcf, 0xfc, 0x0, 0xf, 0xfc,
    0xff, 0xf7, 0x8f, 0xf7, 0xff, 0xf1, 0x4, 0xff,
    0x7f, 0xff, 0x78, 0xff, 0x5d, 0xff, 0x60, 0x9f,
    0xf2, 0xff, 0xf7, 0x8f, 0xf5, 0x8f, 0xfa, 0xe,
    0xfd, 0xf, 0xff, 0x78, 0xff, 0x54, 0xff, 0xe3,
    0xff, 0x80, 0xff, 0xf7, 0x8f, 0xf5, 0xf, 0xff,
    0xbf, 0xf4, 0xf, 0xff, 0x78, 0xff, 0x50, 0xaf,
    0xff, 0xfe, 0x0, 0xff, 0xf7, 0x8f, 0xf5, 0x6,
    0xff, 0xff, 0xa0, 0xf, 0xff, 0x78, 0xff, 0x50,
    0x1f, 0xff, 0xf5, 0x0, 0xff, 0xf7, 0x8f, 0xf5,
    0x0, 0xcf, 0xff, 0x10, 0xf, 0xff, 0x78, 0xff,
    0x50, 0x7, 0xff, 0xb0, 0x0, 0xff, 0xf7, 0x8f,
    0xf5, 0x0, 0x3f, 0xf7, 0x0, 0xf, 0xff, 0x70,

    /* U+041D "Н" */
    0x8f, 0xfd, 0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xfd,
    0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xfd, 0x0, 0x0,
    0x9f, 0xfd, 0x8f, 0xfd, 0x0, 0x0, 0x9f, 0xfd,
    0x8f, 0xfd, 0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xfd,
    0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xff, 0xee, 0xee,
    0xff, 0xfd, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x8f, 0xfd,
    0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xfd, 0x0, 0x0,
    0x9f, 0xfd, 0x8f, 0xfd, 0x0, 0x0, 0x9f, 0xfd,
    0x8f, 0xfd, 0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xfd,
    0x0, 0x0, 0x9f, 0xfd, 0x8f, 0xfd, 0x0, 0x0,
    0x9f, 0xfd,

    /* U+041E "О" */
    0x0, 0x0, 0x7c, 0xff, 0xd8, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0xcf,
    0xff, 0xed, 0xff, 0xfd, 0x0, 0x6, 0xff, 0xf7,
    0x0, 0x5f, 0xff, 0x60, 0xc, 0xff, 0xd0, 0x0,
    0xb, 0xff, 0xd0, 0xf, 0xff, 0x80, 0x0, 0x7,
    0xff, 0xf1, 0x2f, 0xff, 0x60, 0x0, 0x5, 0xff,
    0xf3, 0x3f, 0xff, 0x60, 0x0, 0x4, 0xff, 0xf4,
    0x2f, 0xff, 0x60, 0x0, 0x5, 0xff, 0xf3, 0xf,
    0xff, 0x80, 0x0, 0x7, 0xff, 0xf1, 0xc, 0xff,
    0xd0, 0x0, 0xb, 0xff, 0xd0, 0x5, 0xff, 0xf7,
    0x0, 0x5f, 0xff, 0x70, 0x0, 0xcf, 0xff, 0xdd,
    0xff, 0xfd, 0x0, 0x0, 0x1d, 0xff, 0xff, 0xff,
    0xe2, 0x0, 0x0, 0x0, 0x7d, 0xff, 0xd8, 0x0,
    0x0,

    /* U+041F "П" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x8f, 0xff, 0xaa, 0xaa,
    0xff, 0xf6, 0x8f, 0xfd, 0x0, 0x0, 0xff, 0xf6,
    0x8f, 0xfd, 0x0, 0x0, 0xff, 0xf6, 0x8f, 0xfd,
    0x0, 0x0, 0xff, 0xf6, 0x8f, 0xfd, 0x0, 0x0,
    0xff, 0xf6, 0x8f, 0xfd, 0x0, 0x0, 0xff, 0xf6,
    0x8f, 0xfd, 0x0, 0x0, 0xff, 0xf6, 0x8f, 0xfd,
    0x0, 0x0, 0xff, 0xf6, 0x8f, 0xfd, 0x0, 0x0,
    0xff, 0xf6, 0x8f, 0xfd, 0x0, 0x0, 0xff, 0xf6,
    0x8f, 0xfd, 0x0, 0x0, 0xff, 0xf6, 0x8f, 0xfd,
    0x0, 0x0, 0xff, 0xf6, 0x8f, 0xfd, 0x0, 0x0,
    0xff, 0xf6,

    /* U+0420 "Р" */
    0x8f, 0xff, 0xff, 0xfe, 0xb5, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0x90, 0x8f, 0xff, 0xaa, 0xbf,
    0xff, 0xf4, 0x8f, 0xfd, 0x0, 0x1, 0xff, 0xfa,
    0x8f, 0xfd, 0x0, 0x0, 0xaf, 0xfc, 0x8f, 0xfd,
    0x0, 0x0, 0xcf, 0xfc, 0x8f, 0xfd, 0x0, 0x16,
    0xff, 0xf8, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x50, 0x8f, 0xff,
    0xaa, 0xa9, 0x71, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x0, 0x0,
    0x0, 0x0,

    /* U+0421 "С" */
    0x0, 0x0, 0x6b, 0xef, 0xea, 0x40, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0xbf,
    0xff, 0xed, 0xff, 0xff, 0x40, 0x5, 0xff, 0xfa,
    0x0, 0x2e, 0xff, 0xc0, 0xc, 0xff, 0xf1, 0x0,
    0x8, 0xff, 0xf1, 0xf, 0xff, 0xc0, 0x0, 0x4,
    0xcc, 0xc2, 0x2f, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xb0, 0x0, 0x0, 0x66, 0x61, 0xc, 0xff,
    0xf0, 0x0, 0x5, 0xff, 0xf1, 0x6, 0xff, 0xfa,
    0x0, 0x1d, 0xff, 0xc0, 0x0, 0xcf, 0xff, 0xfd,
    0xff, 0xff, 0x40, 0x0, 0x1c, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x6b, 0xef, 0xea, 0x30,
    0x0,

    /* U+0422 "Т" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0xee, 0xee, 0xff, 0xfe, 0xee,
    0xa0, 0x0, 0x5f, 0xff, 0x20, 0x0, 0x0, 0x5,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0x5f, 0xff, 0x20,
    0x0, 0x0, 0x5, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0x20, 0x0, 0x0, 0x5, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0x20, 0x0, 0x0,
    0x5, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0x20, 0x0, 0x0, 0x5, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0x20, 0x0, 0x0, 0x5, 0xff,
    0xf2, 0x0, 0x0,

    /* U+0423 "У" */
    0x2f, 0xff, 0x80, 0x0, 0x1, 0xff, 0xe0, 0xa,
    0xff, 0xe0, 0x0, 0x7, 0xff, 0x90, 0x2, 0xff,
    0xf7, 0x0, 0xd, 0xff, 0x20, 0x0, 0xaf, 0xfe,
    0x0, 0x4f, 0xfc, 0x0, 0x0, 0x2f, 0xff, 0x60,
    0xaf, 0xf5, 0x0, 0x0, 0xa, 0xff, 0xe1, 0xff,
    0xe0, 0x0, 0x0, 0x2, 0xff, 0xfc, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x6c, 0xef, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xec, 0x40, 0x0, 0x0,
    0x0,

    /* U+0424 "Ф" */
    0x0, 0x0, 0x0, 0x2f, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xfb, 0x20, 0x0, 0x0,
    0x0, 0x5, 0xcf, 0xff, 0xff, 0xfe, 0x91, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x30,
    0x6, 0xff, 0xfa, 0x6f, 0xfb, 0x6e, 0xff, 0xd0,
    0xd, 0xff, 0x90, 0x2f, 0xfa, 0x2, 0xff, 0xf5,
    0x1f, 0xff, 0x20, 0x2f, 0xfa, 0x0, 0xaf, 0xf9,
    0x2f, 0xff, 0x0, 0x2f, 0xfa, 0x0, 0x8f, 0xfa,
    0x1f, 0xff, 0x20, 0x2f, 0xfa, 0x0, 0xaf, 0xf9,
    0xd, 0xff, 0x90, 0x2f, 0xfa, 0x2, 0xff, 0xf5,
    0x6, 0xff, 0xfa, 0x6f, 0xfb, 0x6e, 0xff, 0xe0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x30,
    0x0, 0x5, 0xcf, 0xff, 0xff, 0xfe, 0x91, 0x0,
    0x0, 0x0, 0x1, 0x5f, 0xfb, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xfa, 0x0, 0x0, 0x0,

    /* U+0425 "Х" */
    0x2f, 0xff, 0xc0, 0x0, 0xd, 0xff, 0x50, 0x9,
    0xff, 0xf5, 0x0, 0x6f, 0xfc, 0x0, 0x1, 0xff,
    0xfd, 0x0, 0xef, 0xf3, 0x0, 0x0, 0x7f, 0xff,
    0x58, 0xff, 0x90, 0x0, 0x0, 0xd, 0xff, 0xef,
    0xff, 0x10, 0x0, 0x0, 0x4, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xe0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0xd, 0xff, 0xef, 0xff, 0x10, 0x0, 0x0, 0x6f,
    0xfb, 0x4f, 0xff, 0x90, 0x0, 0x1, 0xef, 0xf2,
    0xb, 0xff, 0xf2, 0x0, 0x8, 0xff, 0xa0, 0x2,
    0xff, 0xfb, 0x0, 0x2f, 0xff, 0x10, 0x0, 0xaf,
    0xff, 0x40, 0xaf, 0xf8, 0x0, 0x0, 0x2f, 0xff,
    0xd0,

    /* U+0426 "Ц" */
    0x6f, 0xff, 0x0, 0x0, 0xcf, 0xf9, 0x0, 0x6f,
    0xff, 0x0, 0x0, 0xcf, 0xf9, 0x0, 0x6f, 0xff,
    0x0, 0x0, 0xcf, 0xf9, 0x0, 0x6f, 0xff, 0x0,
    0x0, 0xcf, 0xf9, 0x0, 0x6f, 0xff, 0x0, 0x0,
    0xcf, 0xf9, 0x0, 0x6f, 0xff, 0x0, 0x0, 0xcf,
    0xf9, 0x0, 0x6f, 0xff, 0x0, 0x0, 0xcf, 0xf9,
    0x0, 0x6f, 0xff, 0x0, 0x0, 0xcf, 0xf9, 0x0,
    0x6f, 0xff, 0x0, 0x0, 0xcf, 0xf9, 0x0, 0x6f,
    0xff, 0x0, 0x0, 0xcf, 0xf9, 0x0, 0x6f, 0xff,
    0x0, 0x0, 0xcf, 0xf9, 0x0, 0x6f, 0xff, 0x0,
    0x0, 0xcf, 0xf9, 0x0, 0x6f, 0xff, 0xee, 0xee,
    0xff, 0xff, 0xe5, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x10,

    /* U+0427 "Ч" */
    0xdf, 0xf8, 0x0, 0x0, 0xff, 0xf6, 0xdf, 0xf8,
    0x0, 0x0, 0xff, 0xf6, 0xdf, 0xf8, 0x0, 0x0,
    0xff, 0xf6, 0xdf, 0xf8, 0x0, 0x0, 0xff, 0xf6,
    0xdf, 0xf8, 0x0, 0x0, 0xff, 0xf6, 0xdf, 0xf8,
    0x0, 0x0, 0xff, 0xf6, 0xcf, 0xf9, 0x0, 0x0,
    0xff, 0xf6, 0xaf, 0xfe, 0x20, 0x29, 0xff, 0xf6,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xa, 0xff,
    0xff, 0xfd, 0xff, 0xf6, 0x0, 0x5a, 0xca, 0x60,
    0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xf6,

    /* U+0428 "Ш" */
    0x6f, 0xff, 0x0, 0x1, 0xff, 0xf4, 0x0, 0xd,
    0xff, 0x96, 0xff, 0xf0, 0x0, 0x1f, 0xff, 0x40,
    0x0, 0xdf, 0xf9, 0x6f, 0xff, 0x0, 0x1, 0xff,
    0xf4, 0x0, 0xd, 0xff, 0x96, 0xff, 0xf0, 0x0,
    0x1f, 0xff, 0x40, 0x0, 0xdf, 0xf9, 0x6f, 0xff,
    0x0, 0x1, 0xff, 0xf4, 0x0, 0xd, 0xff, 0x96,
    0xff, 0xf0, 0x0, 0x1f, 0xff, 0x40, 0x0, 0xdf,
    0xf9, 0x6f, 0xff, 0x0, 0x1, 0xff, 0xf4, 0x0,
    0xd, 0xff, 0x96, 0xff, 0xf0, 0x0, 0x1f, 0xff,
    0x40, 0x0, 0xdf, 0xf9, 0x6f, 0xff, 0x0, 0x1,
    0xff, 0xf4, 0x0, 0xd, 0xff, 0x96, 0xff, 0xf0,
    0x0, 0x1f, 0xff, 0x40, 0x0, 0xdf, 0xf9, 0x6f,
    0xff, 0x0, 0x1, 0xff, 0xf4, 0x0, 0xd, 0xff,
    0x96, 0xff, 0xf0, 0x0, 0x1f, 0xff, 0x40, 0x0,
    0xdf, 0xf9, 0x6f, 0xff, 0xee, 0xee, 0xff, 0xfe,
    0xee, 0xef, 0xff, 0x96, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,

    /* U+0429 "Щ" */
    0x6f, 0xff, 0x0, 0x1, 0xff, 0xf4, 0x0, 0xd,
    0xff, 0x90, 0x6, 0xff, 0xf0, 0x0, 0x1f, 0xff,
    0x40, 0x0, 0xdf, 0xf9, 0x0, 0x6f, 0xff, 0x0,
    0x1, 0xff, 0xf4, 0x0, 0xd, 0xff, 0x90, 0x6,
    0xff, 0xf0, 0x0, 0x1f, 0xff, 0x40, 0x0, 0xdf,
    0xf9, 0x0, 0x6f, 0xff, 0x0, 0x1, 0xff, 0xf4,
    0x0, 0xd, 0xff, 0x90, 0x6, 0xff, 0xf0, 0x0,
    0x1f, 0xff, 0x40, 0x0, 0xdf, 0xf9, 0x0, 0x6f,
    0xff, 0x0, 0x1, 0xff, 0xf4, 0x0, 0xd, 0xff,
    0x90, 0x6, 0xff, 0xf0, 0x0, 0x1f, 0xff, 0x40,
    0x0, 0xdf, 0xf9, 0x0, 0x6f, 0xff, 0x0, 0x1,
    0xff, 0xf4, 0x0, 0xd, 0xff, 0x90, 0x6, 0xff,
    0xf0, 0x0, 0x1f, 0xff, 0x40, 0x0, 0xdf, 0xf9,
    0x0, 0x6f, 0xff, 0x0, 0x1, 0xff, 0xf4, 0x0,
    0xd, 0xff, 0x90, 0x6, 0xff, 0xf0, 0x0, 0x1f,
    0xff, 0x40, 0x0, 0xdf, 0xf9, 0x0, 0x6f, 0xff,
    0xee, 0xee, 0xff, 0xfe, 0xee, 0xef, 0xff, 0xfe,
    0x56, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,

    /* U+042A "Ъ" */
    0x8f, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x7e, 0xee, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xfe, 0xa3, 0x0,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x1, 0xff, 0xfb, 0xaa, 0xbf, 0xff, 0xe0,
    0x0, 0x1, 0xff, 0xf4, 0x0, 0x6, 0xff, 0xf3,
    0x0, 0x1, 0xff, 0xf4, 0x0, 0x2, 0xff, 0xf5,
    0x0, 0x1, 0xff, 0xf4, 0x0, 0x7, 0xff, 0xf3,
    0x0, 0x1, 0xff, 0xfd, 0xcc, 0xdf, 0xff, 0xe0,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xfe, 0xa2, 0x0,

    /* U+042B "Ы" */
    0x6f, 0xff, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xe6, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xfe, 0x6f, 0xff, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xe6, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xfe, 0x6f, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xe6, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xfe, 0x6f, 0xff, 0xff, 0xff, 0xd8,
    0x10, 0x7, 0xff, 0xe6, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x10, 0x7f, 0xfe, 0x6f, 0xff, 0xaa, 0xad,
    0xff, 0xf9, 0x7, 0xff, 0xe6, 0xff, 0xf0, 0x0,
    0xb, 0xff, 0xe0, 0x7f, 0xfe, 0x6f, 0xff, 0x0,
    0x0, 0x7f, 0xff, 0x7, 0xff, 0xe6, 0xff, 0xf0,
    0x0, 0xc, 0xff, 0xe0, 0x7f, 0xfe, 0x6f, 0xff,
    0xcc, 0xce, 0xff, 0xf9, 0x7, 0xff, 0xe6, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x10, 0x7f, 0xfe, 0x6f,
    0xff, 0xff, 0xff, 0xd8, 0x0, 0x7, 0xff, 0xe0,

    /* U+042C "Ь" */
    0x8f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xfe,
    0xc8, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x8f, 0xff, 0xaa, 0xad, 0xff, 0xf7, 0x8f, 0xfd,
    0x0, 0x0, 0xdf, 0xfc, 0x8f, 0xfd, 0x0, 0x0,
    0x9f, 0xfe, 0x8f, 0xfd, 0x0, 0x0, 0xdf, 0xfc,
    0x8f, 0xff, 0xcc, 0xce, 0xff, 0xf7, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0x8f, 0xff, 0xff, 0xff,
    0xc7, 0x0,

    /* U+042D "Э" */
    0x0, 0x3, 0xad, 0xfe, 0xc6, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xff, 0xff, 0xc1, 0x0, 0x8, 0xff,
    0xff, 0xdf, 0xff, 0xfc, 0x0, 0x1f, 0xff, 0x90,
    0x0, 0x6f, 0xff, 0x60, 0x2, 0x69, 0x0, 0x0,
    0xa, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xf0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xf2, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xf3,
    0x0, 0x0, 0x25, 0x55, 0x58, 0xff, 0xf1, 0x0,
    0x1, 0x0, 0x0, 0x6, 0xff, 0xf0, 0x6d, 0xfb,
    0x0, 0x0, 0xc, 0xff, 0xb0, 0x3f, 0xff, 0x80,
    0x0, 0x8f, 0xff, 0x50, 0x9, 0xff, 0xfe, 0xce,
    0xff, 0xfb, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0x5, 0xbe, 0xfe, 0xc6, 0x0,
    0x0,

    /* U+042E "Ю" */
    0x8f, 0xfd, 0x0, 0x0, 0x2, 0x9e, 0xfe, 0xb6,
    0x0, 0x0, 0x8f, 0xfd, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0xc1, 0x0, 0x8f, 0xfd, 0x0, 0x5,
    0xff, 0xfd, 0x9b, 0xff, 0xfc, 0x0, 0x8f, 0xfd,
    0x0, 0xe, 0xff, 0xc0, 0x0, 0x6f, 0xff, 0x60,
    0x8f, 0xfd, 0x0, 0x5f, 0xff, 0x30, 0x0, 0xd,
    0xff, 0xd0, 0x8f, 0xfd, 0x0, 0xaf, 0xfe, 0x0,
    0x0, 0x8, 0xff, 0xf1, 0x8f, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x6, 0xff, 0xf3, 0x8f, 0xff,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x5, 0xff, 0xf4,
    0x8f, 0xff, 0xaa, 0xef, 0xfb, 0x0, 0x0, 0x6,
    0xff, 0xf3, 0x8f, 0xfd, 0x0, 0xaf, 0xfd, 0x0,
    0x0, 0x9, 0xff, 0xf1, 0x8f, 0xfd, 0x0, 0x6f,
    0xff, 0x20, 0x0, 0xe, 0xff, 0xc0, 0x8f, 0xfd,
    0x0, 0x1e, 0xff, 0xb0, 0x0, 0x8f, 0xff, 0x50,
    0x8f, 0xfd, 0x0, 0x6, 0xff, 0xfd, 0x9c, 0xff,
    0xfb, 0x0, 0x8f, 0xfd, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x8f, 0xfd, 0x0, 0x0,
    0x3, 0xae, 0xfe, 0xc6, 0x0, 0x0,

    /* U+042F "Я" */
    0x0, 0x7, 0xce, 0xff, 0xff, 0xff, 0xf0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x5, 0xff, 0xfe,
    0xa9, 0x9c, 0xff, 0xf0, 0xbf, 0xff, 0x10, 0x0,
    0x7f, 0xff, 0xc, 0xff, 0xc0, 0x0, 0x7, 0xff,
    0xf0, 0xaf, 0xff, 0x10, 0x0, 0x7f, 0xff, 0x4,
    0xff, 0xfd, 0x87, 0x7b, 0xff, 0xf0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0xcf, 0xf7, 0x0, 0x7f,
    0xff, 0x0, 0x4f, 0xff, 0x10, 0x7, 0xff, 0xf0,
    0xc, 0xff, 0xa0, 0x0, 0x7f, 0xff, 0x3, 0xff,
    0xf3, 0x0, 0x7, 0xff, 0xf0, 0xbf, 0xfd, 0x0,
    0x0, 0x7f, 0xff, 0x2f, 0xff, 0x60, 0x0, 0x7,
    0xff, 0xf0,

    /* U+0430 "а" */
    0x0, 0x18, 0xdf, 0xfd, 0x92, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xe1, 0xc, 0xff, 0x92, 0x3e, 0xff,
    0x70, 0x68, 0x90, 0x0, 0xaf, 0xf9, 0x0, 0x2,
    0x68, 0xae, 0xff, 0x90, 0x2c, 0xff, 0xff, 0xff,
    0xf9, 0xd, 0xff, 0xc4, 0x9, 0xff, 0x93, 0xff,
    0xf2, 0x0, 0xbf, 0xf9, 0x3f, 0xff, 0x30, 0x3f,
    0xff, 0x90, 0xdf, 0xff, 0xdf, 0xcf, 0xf9, 0x2,
    0xae, 0xfc, 0x46, 0xff, 0xb0,

    /* U+0431 "б" */
    0x0, 0x0, 0x0, 0x1d, 0xff, 0x50, 0x0, 0x0,
    0x7c, 0xff, 0xfd, 0x0, 0x0, 0x1d, 0xff, 0xfc,
    0x70, 0x0, 0x0, 0xbf, 0xe6, 0x0, 0x0, 0x0,
    0x5, 0xff, 0x50, 0x0, 0x0, 0x0, 0xa, 0xff,
    0x7e, 0xfe, 0xa2, 0x0, 0xe, 0xff, 0xff, 0xff,
    0xff, 0x30, 0x1f, 0xff, 0xd4, 0x3b, 0xff, 0xd0,
    0x2f, 0xff, 0x40, 0x1, 0xff, 0xf4, 0x3f, 0xff,
    0x0, 0x0, 0xef, 0xf7, 0x2f, 0xff, 0x0, 0x0,
    0xdf, 0xf8, 0x1f, 0xff, 0x0, 0x0, 0xef, 0xf6,
    0xd, 0xff, 0x40, 0x1, 0xff, 0xf3, 0x6, 0xff,
    0xd4, 0x3b, 0xff, 0xb0, 0x0, 0xaf, 0xff, 0xff,
    0xfd, 0x10, 0x0, 0x6, 0xce, 0xfd, 0x81, 0x0,

    /* U+0432 "в" */
    0xaf, 0xff, 0xff, 0xfe, 0xa1, 0xa, 0xff, 0xff,
    0xff, 0xff, 0xb0, 0xaf, 0xf8, 0x0, 0x4f, 0xff,
    0xa, 0xff, 0x80, 0x0, 0xff, 0xd0, 0xaf, 0xfc,
    0x99, 0xcf, 0xe3, 0xa, 0xff, 0xff, 0xff, 0xf8,
    0x10, 0xaf, 0xf8, 0x0, 0x3f, 0xfd, 0xa, 0xff,
    0x80, 0x0, 0xdf, 0xf4, 0xaf, 0xf9, 0x22, 0x5f,
    0xff, 0x4a, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xaf,
    0xff, 0xff, 0xfe, 0xa2, 0x0,

    /* U+0433 "г" */
    0xaf, 0xff, 0xff, 0xf7, 0xaf, 0xff, 0xff, 0xf7,
    0xaf, 0xfa, 0x55, 0x52, 0xaf, 0xf8, 0x0, 0x0,
    0xaf, 0xf8, 0x0, 0x0, 0xaf, 0xf8, 0x0, 0x0,
    0xaf, 0xf8, 0x0, 0x0, 0xaf, 0xf8, 0x0, 0x0,
    0xaf, 0xf8, 0x0, 0x0, 0xaf, 0xf8, 0x0, 0x0,
    0xaf, 0xf8, 0x0, 0x0,

    /* U+0434 "д" */
    0x0, 0x0, 0x8f, 0xff, 0xf3, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xff, 0x70, 0x0, 0x0, 0x1, 0xff,
    0x7f, 0xfb, 0x0, 0x0, 0x0, 0x5f, 0xe1, 0xff,
    0xe0, 0x0, 0x0, 0xa, 0xfa, 0xe, 0xff, 0x20,
    0x0, 0x0, 0xef, 0x60, 0xbf, 0xf6, 0x0, 0x0,
    0x3f, 0xf2, 0x8, 0xff, 0xa0, 0x0, 0x7, 0xfd,
    0x0, 0x5f, 0xfe, 0x0, 0x3, 0xcf, 0xb3, 0x35,
    0xff, 0xf4, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82,
    0xff, 0x0, 0x0, 0x0, 0xc, 0xf8, 0x2f, 0xe0,
    0x0, 0x0, 0x0, 0xaf, 0x81, 0x76, 0x0, 0x0,
    0x0, 0x3, 0x73,

    /* U+0435 "е" */
    0x0, 0x6, 0xcf, 0xfc, 0x50, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xf9, 0x0, 0x8, 0xff, 0xc2, 0x2b,
    0xff, 0x50, 0xf, 0xff, 0x30, 0x2, 0xff, 0xb0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x4f, 0xff,
    0xdd, 0xdd, 0xdd, 0xd0, 0x3f, 0xff, 0x10, 0x0,
    0x0, 0x0, 0xf, 0xff, 0x50, 0x1, 0xfe, 0xa0,
    0x8, 0xff, 0xe6, 0x4c, 0xff, 0x60, 0x0, 0xbf,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x6, 0xcf, 0xfc,
    0x60, 0x0,

    /* U+0436 "ж" */
    0xa, 0xff, 0x80, 0xb, 0xff, 0x80, 0xa, 0xff,
    0x60, 0x1, 0xef, 0xf3, 0xb, 0xff, 0x80, 0x5f,
    0xfa, 0x0, 0x0, 0x5f, 0xfd, 0xb, 0xff, 0x81,
    0xef, 0xd0, 0x0, 0x0, 0xa, 0xff, 0x8b, 0xff,
    0x8a, 0xff, 0x20, 0x0, 0x0, 0x1, 0xef, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0x10, 0x0, 0x0, 0x5,
    0xff, 0x8d, 0xff, 0xba, 0xff, 0xa0, 0x0, 0x0,
    0x1e, 0xfd, 0xb, 0xff, 0x81, 0xef, 0xf4, 0x0,
    0x0, 0xaf, 0xf3, 0xb, 0xff, 0x80, 0x6f, 0xfd,
    0x0, 0x4, 0xff, 0xa0, 0xb, 0xff, 0x80, 0xd,
    0xff, 0x60, 0xe, 0xff, 0x10, 0xb, 0xff, 0x80,
    0x4, 0xff, 0xe1,

    /* U+0437 "з" */
    0x0, 0x7c, 0xef, 0xeb, 0x40, 0x0, 0xcf, 0xff,
    0xff, 0xff, 0x40, 0x4f, 0xfc, 0x33, 0xcf, 0xfa,
    0x0, 0x2, 0x10, 0xb, 0xff, 0x70, 0x0, 0x0,
    0xdf, 0xff, 0x70, 0x0, 0x0, 0xf, 0xff, 0xfd,
    0x30, 0x0, 0x0, 0x1, 0xbf, 0xfd, 0x3, 0x7a,
    0x40, 0x5, 0xff, 0xf0, 0x6f, 0xfd, 0x22, 0xbf,
    0xfe, 0x0, 0xbf, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x7c, 0xff, 0xeb, 0x30, 0x0,

    /* U+0438 "и" */
    0xaf, 0xf8, 0x0, 0xf, 0xff, 0x3a, 0xff, 0x80,
    0x2, 0xff, 0xf3, 0xaf, 0xf8, 0x0, 0xcf, 0xff,
    0x3a, 0xff, 0x80, 0x7f, 0xff, 0xf3, 0xaf, 0xf8,
    0x3f, 0xff, 0xff, 0x3a, 0xff, 0x7d, 0xf8, 0xff,
    0xf3, 0xaf, 0xfd, 0xfd, 0xf, 0xff, 0x3a, 0xff,
    0xff, 0x30, 0xff, 0xf3, 0xaf, 0xff, 0x70, 0xf,
    0xff, 0x3a, 0xff, 0xc0, 0x0, 0xff, 0xf3, 0xaf,
    0xf8, 0x0, 0xf, 0xff, 0x30,

    /* U+0439 "й" */
    0x0, 0x76, 0x0, 0x28, 0x40, 0x0, 0xb, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x5, 0x9a, 0x72, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xff, 0x80, 0x0, 0xff,
    0xf3, 0xaf, 0xf8, 0x0, 0x2f, 0xff, 0x3a, 0xff,
    0x80, 0xc, 0xff, 0xf3, 0xaf, 0xf8, 0x7, 0xff,
    0xff, 0x3a, 0xff, 0x83, 0xff, 0xff, 0xf3, 0xaf,
    0xf7, 0xdf, 0x8f, 0xff, 0x3a, 0xff, 0xdf, 0xd0,
    0xff, 0xf3, 0xaf, 0xff, 0xf3, 0xf, 0xff, 0x3a,
    0xff, 0xf7, 0x0, 0xff, 0xf3, 0xaf, 0xfc, 0x0,
    0xf, 0xff, 0x3a, 0xff, 0x80, 0x0, 0xff, 0xf3,

    /* U+043A "к" */
    0xaf, 0xf8, 0x0, 0xc, 0xff, 0x30, 0xaf, 0xf8,
    0x0, 0xbf, 0xf5, 0x0, 0xaf, 0xf8, 0xa, 0xff,
    0x60, 0x0, 0xaf, 0xf8, 0x8f, 0xf9, 0x0, 0x0,
    0xaf, 0xfd, 0xff, 0xfa, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0x30, 0x0, 0xaf, 0xff, 0xba, 0xff,
    0xb0, 0x0, 0xaf, 0xfc, 0x2, 0xff, 0xf3, 0x0,
    0xaf, 0xf8, 0x0, 0x9f, 0xfb, 0x0, 0xaf, 0xf8,
    0x0, 0x1f, 0xff, 0x40, 0xaf, 0xf8, 0x0, 0x9,
    0xff, 0xc0,

    /* U+043B "л" */
    0x0, 0x0, 0xcf, 0xff, 0x10, 0x0, 0x0, 0x2,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x7, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0xc, 0xfa, 0xff, 0xf0, 0x0,
    0x0, 0x2f, 0xf3, 0xdf, 0xf4, 0x0, 0x0, 0x7f,
    0xe0, 0x9f, 0xf8, 0x0, 0x0, 0xcf, 0x90, 0x5f,
    0xfd, 0x0, 0x1, 0xff, 0x40, 0xf, 0xff, 0x20,
    0x7, 0xfe, 0x0, 0xc, 0xff, 0x70, 0xc, 0xfa,
    0x0, 0x8, 0xff, 0xc0, 0x1f, 0xf5, 0x0, 0x3,
    0xff, 0xf1,

    /* U+043C "м" */
    0xaf, 0xff, 0xf1, 0x0, 0x6, 0xff, 0xff, 0x1a,
    0xff, 0xff, 0x50, 0x0, 0xaf, 0xff, 0xf1, 0xaf,
    0xdf, 0xf9, 0x0, 0xe, 0xed, 0xff, 0x1a, 0xfc,
    0xbf, 0xe0, 0x3, 0xfa, 0xdf, 0xf1, 0xaf, 0xc6,
    0xff, 0x20, 0x7f, 0x6d, 0xff, 0x1a, 0xfc, 0x2f,
    0xf6, 0xc, 0xf1, 0xdf, 0xf1, 0xaf, 0xc0, 0xdf,
    0xb1, 0xfd, 0xd, 0xff, 0x1a, 0xfc, 0x9, 0xff,
    0x5f, 0x80, 0xdf, 0xf1, 0xaf, 0xc0, 0x4f, 0xfd,
    0xf4, 0xd, 0xff, 0x1a, 0xfc, 0x0, 0xff, 0xff,
    0x0, 0xdf, 0xf1, 0xaf, 0xc0, 0xc, 0xff, 0xb0,
    0xd, 0xff, 0x10,

    /* U+043D "н" */
    0xaf, 0xf8, 0x0, 0x2f, 0xff, 0xa, 0xff, 0x80,
    0x2, 0xff, 0xf0, 0xaf, 0xf8, 0x0, 0x2f, 0xff,
    0xa, 0xff, 0x80, 0x2, 0xff, 0xf0, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xaf, 0xfa, 0x55, 0x6f, 0xff, 0xa, 0xff,
    0x80, 0x2, 0xff, 0xf0, 0xaf, 0xf8, 0x0, 0x2f,
    0xff, 0xa, 0xff, 0x80, 0x2, 0xff, 0xf0, 0xaf,
    0xf8, 0x0, 0x2f, 0xff, 0x0,

    /* U+043E "о" */
    0x0, 0x7, 0xdf, 0xfc, 0x50, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xf9, 0x0, 0x9, 0xff, 0xc2, 0x3e,
    0xff, 0x50, 0xf, 0xff, 0x40, 0x7, 0xff, 0xc0,
    0x3f, 0xff, 0x10, 0x5, 0xff, 0xf0, 0x4f, 0xff,
    0x10, 0x4, 0xff, 0xf1, 0x3f, 0xff, 0x20, 0x5,
    0xff, 0xf0, 0xf, 0xff, 0x40, 0x7, 0xff, 0xc0,
    0x8, 0xff, 0xd2, 0x4e, 0xff, 0x40, 0x0, 0xcf,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x7, 0xdf, 0xfb,
    0x50, 0x0,

    /* U+043F "п" */
    0xaf, 0xff, 0xff, 0xff, 0xfa, 0xaf, 0xff, 0xff,
    0xff, 0xfa, 0xaf, 0xf9, 0x22, 0xaf, 0xfa, 0xaf,
    0xf8, 0x0, 0x9f, 0xfa, 0xaf, 0xf8, 0x0, 0x9f,
    0xfa, 0xaf, 0xf8, 0x0, 0x9f, 0xfa, 0xaf, 0xf8,
    0x0, 0x9f, 0xfa, 0xaf, 0xf8, 0x0, 0x9f, 0xfa,
    0xaf, 0xf8, 0x0, 0x9f, 0xfa, 0xaf, 0xf8, 0x0,
    0x9f, 0xfa, 0xaf, 0xf8, 0x0, 0x9f, 0xfa,

    /* U+0440 "р" */
    0xaf, 0xf5, 0x9e, 0xfb, 0x20, 0xa, 0xff, 0xef,
    0xff, 0xfe, 0x10, 0xaf, 0xfe, 0x21, 0xcf, 0xf9,
    0xa, 0xff, 0x80, 0x5, 0xff, 0xe0, 0xaf, 0xf6,
    0x0, 0x3f, 0xff, 0x1a, 0xff, 0x60, 0x2, 0xff,
    0xf1, 0xaf, 0xf6, 0x0, 0x3f, 0xff, 0xa, 0xff,
    0x80, 0x6, 0xff, 0xe0, 0xaf, 0xff, 0x65, 0xef,
    0xf9, 0xa, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xaf,
    0xf7, 0x9f, 0xfb, 0x20, 0xa, 0xff, 0x60, 0x0,
    0x0, 0x0, 0xaf, 0xf6, 0x0, 0x0, 0x0, 0xa,
    0xff, 0x60, 0x0, 0x0, 0x0, 0xaf, 0xf6, 0x0,
    0x0, 0x0, 0x0,

    /* U+0441 "с" */
    0x0, 0x6, 0xcf, 0xfc, 0x60, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xa0, 0x8, 0xff, 0xf9, 0x7e, 0xff,
    0x50, 0xff, 0xf9, 0x0, 0x4f, 0xfb, 0x3f, 0xff,
    0x50, 0x0, 0x22, 0x24, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0x50, 0x0, 0x44, 0x30, 0xff,
    0xf9, 0x0, 0x6f, 0xfb, 0x9, 0xff, 0xfb, 0xaf,
    0xff, 0x50, 0xc, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x7, 0xdf, 0xfc, 0x50, 0x0,

    /* U+0442 "т" */
    0x3f, 0xff, 0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff,
    0xff, 0xfe, 0x15, 0x57, 0xff, 0xf5, 0x54, 0x0,
    0x3, 0xff, 0xf0, 0x0, 0x0, 0x3, 0xff, 0xf0,
    0x0, 0x0, 0x3, 0xff, 0xf0, 0x0, 0x0, 0x3,
    0xff, 0xf0, 0x0, 0x0, 0x3, 0xff, 0xf0, 0x0,
    0x0, 0x3, 0xff, 0xf0, 0x0, 0x0, 0x3, 0xff,
    0xf0, 0x0, 0x0, 0x3, 0xff, 0xf0, 0x0,

    /* U+0443 "у" */
    0xe, 0xff, 0x70, 0x0, 0xcf, 0x80, 0x8f, 0xfc,
    0x0, 0x1f, 0xf3, 0x3, 0xff, 0xf1, 0x5, 0xfe,
    0x0, 0xd, 0xff, 0x60, 0xaf, 0x90, 0x0, 0x7f,
    0xfb, 0xf, 0xf4, 0x0, 0x2, 0xff, 0xf5, 0xff,
    0x0, 0x0, 0xc, 0xff, 0xdf, 0xa0, 0x0, 0x0,
    0x6f, 0xff, 0xf5, 0x0, 0x0, 0x1, 0xff, 0xff,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x5f, 0xf6, 0x0, 0x0, 0x0, 0x4, 0xff,
    0x10, 0x0, 0x4, 0x77, 0xdf, 0xa0, 0x0, 0x0,
    0x7f, 0xff, 0xf3, 0x0, 0x0, 0x6, 0xff, 0xc4,
    0x0, 0x0, 0x0,

    /* U+0444 "ф" */
    0x0, 0x0, 0x0, 0xaf, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1b, 0xff, 0x50, 0x0, 0x0, 0x0, 0x5,
    0xcf, 0xff, 0xff, 0xfa, 0x10, 0x0, 0x9, 0xff,
    0xfe, 0xff, 0xdf, 0xfe, 0x30, 0x6, 0xff, 0xe2,
    0x8f, 0xf2, 0x7f, 0xfe, 0x10, 0xdf, 0xf6, 0x8,
    0xff, 0x20, 0xcf, 0xf7, 0x1f, 0xff, 0x10, 0x8f,
    0xf2, 0x8, 0xff, 0xb3, 0xff, 0xf0, 0x8, 0xff,
    0x20, 0x6f, 0xfc, 0x2f, 0xff, 0x10, 0x8f, 0xf2,
    0x8, 0xff, 0xc0, 0xef, 0xf6, 0x8, 0xff, 0x20,
    0xcf, 0xf8, 0x8, 0xff, 0xe2, 0x8f, 0xf2, 0x7f,
    0xff, 0x20, 0xc, 0xff, 0xfe, 0xff, 0xef, 0xff,
    0x60, 0x0, 0x7, 0xef, 0xff, 0xff, 0xfc, 0x40,
    0x0, 0x0, 0x0, 0x2b, 0xff, 0x61, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xf3, 0x0, 0x0, 0x0,

    /* U+0445 "х" */
    0x3f, 0xff, 0x60, 0xb, 0xfe, 0x10, 0x9f, 0xfe,
    0x14, 0xff, 0x60, 0x1, 0xef, 0xf9, 0xdf, 0xc0,
    0x0, 0x6, 0xff, 0xff, 0xf3, 0x0, 0x0, 0xc,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0xaf, 0xff, 0x70,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0x10, 0x0, 0xd,
    0xfc, 0xdf, 0xfb, 0x0, 0x7, 0xff, 0x34, 0xff,
    0xf4, 0x2, 0xff, 0x90, 0xb, 0xff, 0xe0, 0xbf,
    0xf1, 0x0, 0x2f, 0xff, 0x80,

    /* U+0446 "ц" */
    0xaf, 0xf8, 0x0, 0x5f, 0xfd, 0x0, 0xaf, 0xf8,
    0x0, 0x5f, 0xfd, 0x0, 0xaf, 0xf8, 0x0, 0x5f,
    0xfd, 0x0, 0xaf, 0xf8, 0x0, 0x5f, 0xfd, 0x0,
    0xaf, 0xf8, 0x0, 0x5f, 0xfd, 0x0, 0xaf, 0xf8,
    0x0, 0x5f, 0xfd, 0x0, 0xaf, 0xf8, 0x0, 0x5f,
    0xfd, 0x0, 0xaf, 0xf8, 0x0, 0x5f, 0xfd, 0x0,
    0xaf, 0xfa, 0x55, 0x8f, 0xfe, 0x52, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x4, 0x73,

    /* U+0447 "ч" */
    0xff, 0xf3, 0x0, 0xdf, 0xf5, 0xff, 0xf3, 0x0,
    0xdf, 0xf5, 0xff, 0xf3, 0x0, 0xdf, 0xf5, 0xff,
    0xf3, 0x0, 0xdf, 0xf5, 0xff, 0xf3, 0x0, 0xdf,
    0xf5, 0xdf, 0xf9, 0x25, 0xff, 0xf5, 0x8f, 0xff,
    0xff, 0xff, 0xf5, 0x8, 0xdf, 0xd7, 0xef, 0xf5,
    0x0, 0x0, 0x0, 0xdf, 0xf5, 0x0, 0x0, 0x0,
    0xdf, 0xf5, 0x0, 0x0, 0x0, 0xdf, 0xf5,

    /* U+0448 "ш" */
    0x9f, 0xf9, 0x0, 0x8f, 0xfa, 0x0, 0x7f, 0xfb,
    0x9f, 0xf9, 0x0, 0x8f, 0xfa, 0x0, 0x7f, 0xfb,
    0x9f, 0xf9, 0x0, 0x8f, 0xfa, 0x0, 0x7f, 0xfb,
    0x9f, 0xf9, 0x0, 0x8f, 0xfa, 0x0, 0x7f, 0xfb,
    0x9f, 0xf9, 0x0, 0x8f, 0xfa, 0x0, 0x7f, 0xfb,
    0x9f, 0xf9, 0x0, 0x8f, 0xfa, 0x0, 0x7f, 0xfb,
    0x9f, 0xf9, 0x0, 0x8f, 0xfa, 0x0, 0x7f, 0xfb,
    0x9f, 0xf9, 0x0, 0x8f, 0xfa, 0x0, 0x7f, 0xfb,
    0x9f, 0xfb, 0x55, 0xaf, 0xfc, 0x55, 0x9f, 0xfb,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+0449 "щ" */
    0x9f, 0xf9, 0x0, 0x8f, 0xfa, 0x0, 0x7f, 0xfc,
    0x0, 0x9f, 0xf9, 0x0, 0x8f, 0xfa, 0x0, 0x7f,
    0xfc, 0x0, 0x9f, 0xf9, 0x0, 0x8f, 0xfa, 0x0,
    0x7f, 0xfc, 0x0, 0x9f, 0xf9, 0x0, 0x8f, 0xfa,
    0x0, 0x7f, 0xfc, 0x0, 0x9f, 0xf9, 0x0, 0x8f,
    0xfa, 0x0, 0x7f, 0xfc, 0x0, 0x9f, 0xf9, 0x0,
    0x8f, 0xfa, 0x0, 0x7f, 0xfc, 0x0, 0x9f, 0xf9,
    0x0, 0x8f, 0xfa, 0x0, 0x7f, 0xfc, 0x0, 0x9f,
    0xf9, 0x0, 0x8f, 0xfa, 0x0, 0x7f, 0xfc, 0x0,
    0x9f, 0xfb, 0x55, 0xaf, 0xfc, 0x55, 0x9f, 0xfd,
    0x52, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x73,

    /* U+044A "ъ" */
    0x8f, 0xff, 0xff, 0x80, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x25, 0x5c, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xc5,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0xa, 0xff, 0x80, 0x7, 0xff, 0xb0, 0x0, 0xaf,
    0xf8, 0x0, 0x1f, 0xfd, 0x0, 0xa, 0xff, 0x92,
    0x28, 0xff, 0xc0, 0x0, 0xaf, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0xa, 0xff, 0xff, 0xff, 0xc4, 0x0,

    /* U+044B "ы" */
    0x9f, 0xf9, 0x0, 0x0, 0x0, 0xc, 0xff, 0x79,
    0xff, 0x90, 0x0, 0x0, 0x0, 0xcf, 0xf7, 0x9f,
    0xf9, 0x0, 0x0, 0x0, 0xc, 0xff, 0x79, 0xff,
    0x90, 0x0, 0x0, 0x0, 0xcf, 0xf7, 0x9f, 0xff,
    0xff, 0xfd, 0x50, 0xc, 0xff, 0x79, 0xff, 0xff,
    0xff, 0xff, 0x50, 0xcf, 0xf7, 0x9f, 0xf9, 0x0,
    0x6f, 0xfc, 0xc, 0xff, 0x79, 0xff, 0x90, 0x0,
    0xff, 0xe0, 0xcf, 0xf7, 0x9f, 0xfa, 0x22, 0x7f,
    0xfd, 0xc, 0xff, 0x79, 0xff, 0xff, 0xff, 0xff,
    0x60, 0xcf, 0xf7, 0x9f, 0xff, 0xff, 0xfc, 0x50,
    0xc, 0xff, 0x70,

    /* U+044C "ь" */
    0xaf, 0xf8, 0x0, 0x0, 0x0, 0xaf, 0xf8, 0x0,
    0x0, 0x0, 0xaf, 0xf8, 0x0, 0x0, 0x0, 0xaf,
    0xf8, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xfc,
    0x50, 0xaf, 0xff, 0xff, 0xff, 0xf3, 0xaf, 0xf8,
    0x0, 0x7f, 0xfa, 0xaf, 0xf8, 0x0, 0x2f, 0xfd,
    0xaf, 0xf9, 0x22, 0x8f, 0xfb, 0xaf, 0xff, 0xff,
    0xff, 0xf5, 0xaf, 0xff, 0xff, 0xec, 0x40,

    /* U+044D "э" */
    0x0, 0x6c, 0xef, 0xd9, 0x20, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0x40, 0x4f, 0xfd, 0x42, 0x7f, 0xfe,
    0x10, 0x1, 0x10, 0x0, 0xcf, 0xf7, 0x0, 0xd,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0xdf, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0xa, 0xff, 0xb3, 0x7a,
    0x40, 0x0, 0xdf, 0xf7, 0x5f, 0xfe, 0x42, 0x9f,
    0xfe, 0x10, 0xaf, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x6c, 0xef, 0xd9, 0x20, 0x0,

    /* U+044E "ю" */
    0xaf, 0xf8, 0x0, 0x2, 0x9e, 0xfe, 0xb5, 0x0,
    0xa, 0xff, 0x80, 0x5, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0xaf, 0xf8, 0x2, 0xff, 0xf5, 0x1, 0xdf,
    0xf7, 0xa, 0xff, 0x80, 0x8f, 0xfc, 0x0, 0x5,
    0xff, 0xe0, 0xaf, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x2f, 0xff, 0x2a, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x1, 0xff, 0xf3, 0xaf, 0xf9, 0x3b, 0xff, 0x90,
    0x0, 0x2f, 0xff, 0x2a, 0xff, 0x80, 0x6f, 0xfb,
    0x0, 0x5, 0xff, 0xe0, 0xaf, 0xf8, 0x0, 0xef,
    0xf5, 0x1, 0xdf, 0xf7, 0xa, 0xff, 0x80, 0x3,
    0xef, 0xff, 0xff, 0xfa, 0x0, 0xaf, 0xf8, 0x0,
    0x1, 0x9d, 0xff, 0xb5, 0x0, 0x0,

    /* U+044F "я" */
    0x0, 0x7d, 0xff, 0xff, 0xff, 0x70, 0x8f, 0xff,
    0xff, 0xff, 0xf7, 0xf, 0xff, 0x40, 0xa, 0xff,
    0x71, 0xff, 0xe0, 0x0, 0xaf, 0xf7, 0xf, 0xff,
    0x41, 0x1b, 0xff, 0x70, 0x6f, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x7f, 0xff, 0xff, 0xff, 0x70, 0xd,
    0xfe, 0x0, 0xbf, 0xf7, 0x6, 0xff, 0x70, 0xb,
    0xff, 0x70, 0xef, 0xe0, 0x0, 0xbf, 0xf7, 0x7f,
    0xf8, 0x0, 0xb, 0xff, 0x70,

    /* U+0451 "ё" */
    0x0, 0xa, 0xe4, 0x2e, 0xc0, 0x0, 0x0, 0xe,
    0xf8, 0x4f, 0xf1, 0x0, 0x0, 0x3, 0x60, 0x5,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xcf, 0xfc, 0x50, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xf9, 0x0, 0x8, 0xff, 0xc2, 0x2b,
    0xff, 0x50, 0xf, 0xff, 0x30, 0x2, 0xff, 0xb0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x4f, 0xff,
    0xdd, 0xdd, 0xdd, 0xd0, 0x3f, 0xff, 0x10, 0x0,
    0x0, 0x0, 0xf, 0xff, 0x50, 0x1, 0xfe, 0xa0,
    0x8, 0xff, 0xe6, 0x4c, 0xff, 0x60, 0x0, 0xbf,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x6, 0xcf, 0xfc,
    0x60, 0x0,

    /* U+2022 "•" */
    0x5, 0xdf, 0xb2, 0x3, 0xff, 0xff, 0xd0, 0x9f,
    0xff, 0xff, 0x49, 0xff, 0xff, 0xf4, 0x4f, 0xff,
    0xfe, 0x0, 0x6e, 0xfc, 0x20, 0x0, 0x0, 0x0,
    0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 88, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 103, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 38, .adv_w = 130, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 66, .adv_w = 206, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 164, .adv_w = 206, .box_w = 12, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 272, .adv_w = 243, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 385, .adv_w = 253, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 505, .adv_w = 68, .box_w = 4, .box_h = 7, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 519, .adv_w = 103, .box_w = 6, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 576, .adv_w = 103, .box_w = 6, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 633, .adv_w = 206, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 683, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 749, .adv_w = 91, .box_w = 4, .box_h = 8, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 765, .adv_w = 91, .box_w = 6, .box_h = 3, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 774, .adv_w = 91, .box_w = 4, .box_h = 4, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 782, .adv_w = 188, .box_w = 14, .box_h = 19, .ofs_x = -2, .ofs_y = -4},
    {.bitmap_index = 915, .adv_w = 206, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1013, .adv_w = 206, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1111, .adv_w = 206, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1201, .adv_w = 206, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1291, .adv_w = 206, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1389, .adv_w = 206, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1487, .adv_w = 206, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1585, .adv_w = 206, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1668, .adv_w = 206, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1766, .adv_w = 206, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1856, .adv_w = 91, .box_w = 4, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1878, .adv_w = 91, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 1908, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 1973, .adv_w = 206, .box_w = 11, .box_h = 7, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 2012, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 2084, .adv_w = 180, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2167, .adv_w = 273, .box_w = 17, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2303, .adv_w = 214, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2408, .adv_w = 229, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2506, .adv_w = 221, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2611, .adv_w = 228, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2709, .adv_w = 201, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2792, .adv_w = 195, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2875, .adv_w = 226, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2973, .adv_w = 228, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3063, .adv_w = 102, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3093, .adv_w = 134, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3153, .adv_w = 222, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3251, .adv_w = 177, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3326, .adv_w = 303, .box_w = 17, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3454, .adv_w = 228, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3544, .adv_w = 225, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3649, .adv_w = 212, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3739, .adv_w = 227, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3865, .adv_w = 231, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3963, .adv_w = 204, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4053, .adv_w = 172, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4136, .adv_w = 229, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4234, .adv_w = 196, .box_w = 14, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4339, .adv_w = 307, .box_w = 20, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4489, .adv_w = 211, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4594, .adv_w = 184, .box_w = 14, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4699, .adv_w = 204, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4797, .adv_w = 103, .box_w = 5, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 4845, .adv_w = 188, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4978, .adv_w = 103, .box_w = 6, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5035, .adv_w = 176, .box_w = 11, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 5079, .adv_w = 176, .box_w = 11, .box_h = 3, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5096, .adv_w = 176, .box_w = 6, .box_h = 5, .ofs_x = 2, .ofs_y = 12},
    {.bitmap_index = 5111, .adv_w = 191, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5172, .adv_w = 192, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5255, .adv_w = 180, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5316, .adv_w = 190, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5399, .adv_w = 188, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5465, .adv_w = 113, .box_w = 7, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5521, .adv_w = 195, .box_w = 13, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5625, .adv_w = 191, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5700, .adv_w = 93, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5730, .adv_w = 95, .box_w = 6, .box_h = 19, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 5787, .adv_w = 191, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5877, .adv_w = 93, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5907, .adv_w = 290, .box_w = 16, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5995, .adv_w = 193, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6050, .adv_w = 188, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6116, .adv_w = 190, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 6199, .adv_w = 191, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6282, .adv_w = 122, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6324, .adv_w = 167, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6379, .adv_w = 124, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6439, .adv_w = 191, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6494, .adv_w = 159, .box_w = 11, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6555, .adv_w = 254, .box_w = 16, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6643, .adv_w = 174, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6704, .adv_w = 157, .box_w = 11, .box_h = 15, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 6787, .adv_w = 151, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6837, .adv_w = 103, .box_w = 7, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6904, .adv_w = 176, .box_w = 5, .box_h = 19, .ofs_x = 3, .ofs_y = -4},
    {.bitmap_index = 6952, .adv_w = 103, .box_w = 7, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7019, .adv_w = 206, .box_w = 11, .box_h = 6, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 7052, .adv_w = 206, .box_w = 7, .box_h = 6, .ofs_x = 3, .ofs_y = 9},
    {.bitmap_index = 7073, .adv_w = 214, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7178, .adv_w = 218, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7268, .adv_w = 229, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7366, .adv_w = 157, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7434, .adv_w = 217, .box_w = 15, .box_h = 19, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 7577, .adv_w = 201, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7660, .adv_w = 304, .box_w = 21, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7818, .adv_w = 206, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7916, .adv_w = 235, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8014, .adv_w = 235, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8138, .adv_w = 222, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8236, .adv_w = 198, .box_w = 14, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8341, .adv_w = 301, .box_w = 17, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8469, .adv_w = 228, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8559, .adv_w = 225, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8664, .adv_w = 221, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8754, .adv_w = 212, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8844, .adv_w = 221, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8949, .adv_w = 172, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9032, .adv_w = 187, .box_w = 14, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9137, .adv_w = 264, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9257, .adv_w = 211, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9362, .adv_w = 229, .box_w = 14, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 9495, .adv_w = 222, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9585, .adv_w = 338, .box_w = 19, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9728, .adv_w = 340, .box_w = 21, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 9928, .adv_w = 236, .box_w = 16, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 10048, .adv_w = 312, .box_w = 17, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10176, .adv_w = 213, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10266, .adv_w = 224, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10371, .adv_w = 337, .box_w = 20, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10521, .adv_w = 231, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10619, .adv_w = 191, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10680, .adv_w = 196, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10776, .adv_w = 193, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10837, .adv_w = 137, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10881, .adv_w = 181, .box_w = 13, .box_h = 14, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 10972, .adv_w = 188, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11038, .adv_w = 253, .box_w = 18, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11137, .adv_w = 172, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11198, .adv_w = 200, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11259, .adv_w = 200, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11347, .adv_w = 186, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11413, .adv_w = 160, .box_w = 12, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11479, .adv_w = 263, .box_w = 15, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11562, .adv_w = 198, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11623, .adv_w = 188, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11689, .adv_w = 191, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11744, .adv_w = 190, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 11827, .adv_w = 180, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11888, .adv_w = 139, .box_w = 10, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11943, .adv_w = 157, .box_w = 11, .box_h = 15, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 12026, .adv_w = 250, .box_w = 15, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12169, .adv_w = 174, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12230, .adv_w = 197, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 12314, .adv_w = 186, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12369, .adv_w = 290, .box_w = 16, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12457, .adv_w = 293, .box_w = 18, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 12583, .adv_w = 197, .box_w = 13, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12655, .adv_w = 269, .box_w = 15, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12738, .adv_w = 181, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12793, .adv_w = 183, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12854, .adv_w = 287, .box_w = 17, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12948, .adv_w = 189, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13009, .adv_w = 188, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13099, .adv_w = 235, .box_w = 7, .box_h = 7, .ofs_x = 4, .ofs_y = 4}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_3[] = {
    0x0, 0x1bd1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 176, .range_length = 1, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1040, .range_length = 64, .glyph_id_start = 97,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1105, .range_length = 7122, .glyph_id_start = 161,
        .unicode_list = unicode_list_3, .glyph_id_ofs_list = NULL, .list_length = 2, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Pair left and right glyphs for kerning*/
static const uint8_t kern_pair_glyph_ids[] =
{
    13, 18,
    14, 34,
    14, 53,
    14, 56,
    14, 58,
    14, 97,
    14, 115,
    14, 116,
    14, 147,
    14, 148,
    15, 18,
    17, 18,
    17, 21,
    17, 24,
    18, 13,
    18, 15,
    18, 17,
    18, 18,
    18, 19,
    18, 20,
    18, 21,
    18, 22,
    18, 23,
    18, 24,
    18, 25,
    19, 18,
    19, 21,
    19, 24,
    20, 18,
    20, 24,
    21, 18,
    21, 21,
    21, 24,
    22, 18,
    22, 21,
    22, 24,
    23, 18,
    23, 21,
    24, 15,
    24, 18,
    24, 21,
    24, 23,
    24, 24,
    24, 27,
    25, 18,
    25, 21,
    25, 24,
    26, 18,
    26, 24,
    34, 13,
    34, 14,
    34, 15,
    34, 36,
    34, 40,
    34, 48,
    34, 50,
    34, 53,
    34, 54,
    34, 55,
    34, 56,
    34, 58,
    34, 68,
    34, 70,
    34, 72,
    34, 80,
    34, 82,
    34, 85,
    34, 86,
    34, 87,
    34, 88,
    34, 90,
    35, 55,
    35, 56,
    35, 58,
    36, 34,
    37, 34,
    37, 43,
    37, 53,
    37, 55,
    37, 58,
    39, 13,
    39, 14,
    39, 15,
    39, 34,
    39, 43,
    39, 48,
    39, 66,
    39, 70,
    39, 80,
    39, 83,
    39, 86,
    40, 34,
    40, 53,
    40, 55,
    40, 56,
    40, 58,
    43, 34,
    44, 36,
    44, 40,
    44, 48,
    44, 53,
    44, 66,
    44, 70,
    44, 80,
    44, 86,
    44, 90,
    45, 14,
    45, 36,
    45, 40,
    45, 48,
    45, 53,
    45, 54,
    45, 55,
    45, 56,
    45, 58,
    45, 90,
    47, 13,
    47, 15,
    48, 34,
    48, 53,
    48, 55,
    48, 56,
    48, 57,
    48, 58,
    49, 13,
    49, 15,
    49, 34,
    49, 43,
    49, 66,
    49, 70,
    49, 80,
    51, 36,
    51, 40,
    51, 48,
    51, 54,
    51, 55,
    51, 56,
    51, 58,
    51, 70,
    51, 80,
    51, 86,
    51, 90,
    52, 34,
    52, 53,
    52, 55,
    52, 56,
    52, 58,
    52, 85,
    53, 13,
    53, 14,
    53, 15,
    53, 27,
    53, 28,
    53, 34,
    53, 36,
    53, 40,
    53, 43,
    53, 52,
    53, 55,
    53, 56,
    53, 58,
    53, 66,
    53, 68,
    53, 70,
    53, 72,
    53, 80,
    53, 83,
    53, 84,
    53, 86,
    53, 87,
    53, 88,
    53, 90,
    54, 34,
    54, 78,
    54, 79,
    54, 81,
    54, 83,
    55, 13,
    55, 15,
    55, 27,
    55, 28,
    55, 34,
    55, 36,
    55, 40,
    55, 48,
    55, 53,
    55, 66,
    55, 70,
    55, 72,
    55, 80,
    55, 83,
    55, 86,
    55, 90,
    56, 13,
    56, 14,
    56, 15,
    56, 27,
    56, 34,
    56, 36,
    56, 40,
    56, 48,
    56, 52,
    56, 53,
    56, 66,
    56, 70,
    56, 72,
    56, 80,
    56, 83,
    56, 86,
    56, 90,
    57, 14,
    57, 36,
    57, 48,
    57, 50,
    57, 70,
    57, 80,
    57, 90,
    58, 13,
    58, 14,
    58, 15,
    58, 27,
    58, 28,
    58, 34,
    58, 36,
    58, 40,
    58, 48,
    58, 52,
    58, 53,
    58, 66,
    58, 70,
    58, 72,
    58, 80,
    58, 81,
    58, 86,
    66, 87,
    66, 88,
    66, 90,
    67, 87,
    67, 88,
    67, 90,
    68, 73,
    68, 76,
    70, 87,
    70, 88,
    70, 89,
    70, 90,
    71, 66,
    71, 70,
    71, 71,
    71, 80,
    71, 84,
    71, 85,
    73, 90,
    76, 13,
    76, 15,
    76, 70,
    76, 72,
    76, 80,
    76, 86,
    78, 87,
    78, 88,
    78, 90,
    79, 87,
    79, 88,
    79, 90,
    80, 87,
    80, 88,
    80, 89,
    80, 90,
    81, 85,
    81, 90,
    83, 13,
    83, 14,
    83, 15,
    83, 71,
    83, 73,
    83, 76,
    83, 81,
    83, 84,
    83, 85,
    83, 87,
    83, 88,
    83, 89,
    83, 90,
    84, 85,
    85, 27,
    85, 28,
    85, 66,
    85, 70,
    85, 80,
    87, 13,
    87, 14,
    87, 15,
    87, 27,
    87, 66,
    87, 68,
    87, 70,
    87, 72,
    87, 80,
    88, 13,
    88, 14,
    88, 15,
    88, 66,
    88, 68,
    88, 70,
    88, 72,
    88, 80,
    89, 66,
    89, 68,
    89, 70,
    89, 80,
    89, 82,
    90, 13,
    90, 14,
    90, 15,
    90, 27,
    90, 66,
    90, 68,
    90, 70,
    90, 72,
    90, 80,
    97, 13,
    97, 14,
    97, 15,
    97, 27,
    97, 28,
    97, 108,
    97, 111,
    97, 114,
    97, 115,
    97, 117,
    97, 120,
    97, 123,
    97, 136,
    97, 140,
    97, 143,
    97, 146,
    97, 147,
    97, 148,
    97, 149,
    97, 152,
    97, 155,
    98, 97,
    98, 103,
    98, 115,
    98, 116,
    98, 120,
    98, 121,
    98, 135,
    98, 147,
    98, 148,
    98, 155,
    99, 97,
    99, 103,
    99, 115,
    99, 116,
    99, 120,
    99, 135,
    99, 147,
    99, 148,
    99, 152,
    99, 155,
    100, 13,
    100, 14,
    100, 15,
    100, 27,
    100, 28,
    100, 101,
    100, 108,
    100, 115,
    100, 116,
    100, 117,
    100, 120,
    100, 129,
    100, 131,
    100, 133,
    100, 134,
    100, 135,
    100, 136,
    100, 137,
    100, 139,
    100, 140,
    100, 141,
    100, 142,
    100, 143,
    100, 144,
    100, 145,
    100, 146,
    100, 147,
    100, 148,
    100, 149,
    100, 150,
    100, 151,
    100, 152,
    100, 155,
    100, 159,
    100, 160,
    102, 117,
    103, 111,
    103, 114,
    103, 117,
    103, 129,
    103, 130,
    103, 134,
    103, 136,
    103, 143,
    103, 146,
    103, 147,
    103, 148,
    103, 149,
    103, 152,
    104, 97,
    104, 101,
    104, 103,
    104, 104,
    104, 108,
    104, 115,
    104, 116,
    104, 118,
    104, 120,
    104, 128,
    104, 147,
    104, 148,
    104, 150,
    104, 152,
    107, 104,
    107, 111,
    107, 114,
    107, 117,
    107, 129,
    107, 130,
    107, 134,
    107, 136,
    107, 143,
    107, 146,
    107, 147,
    107, 148,
    107, 149,
    107, 152,
    111, 97,
    111, 103,
    111, 108,
    111, 115,
    111, 116,
    111, 118,
    111, 120,
    111, 123,
    111, 128,
    113, 13,
    113, 15,
    113, 97,
    113, 101,
    113, 108,
    113, 129,
    113, 131,
    113, 132,
    113, 133,
    113, 134,
    113, 136,
    113, 140,
    113, 143,
    113, 146,
    113, 149,
    114, 97,
    114, 103,
    114, 104,
    114, 115,
    114, 116,
    114, 118,
    114, 128,
    114, 147,
    114, 148,
    115, 13,
    115, 14,
    115, 15,
    115, 27,
    115, 28,
    115, 97,
    115, 101,
    115, 104,
    115, 108,
    115, 114,
    115, 115,
    115, 116,
    115, 117,
    115, 129,
    115, 131,
    115, 132,
    115, 133,
    115, 134,
    115, 135,
    115, 136,
    115, 137,
    115, 139,
    115, 140,
    115, 141,
    115, 142,
    115, 143,
    115, 144,
    115, 145,
    115, 146,
    115, 147,
    115, 148,
    115, 149,
    115, 150,
    115, 151,
    115, 152,
    115, 155,
    115, 160,
    116, 13,
    116, 14,
    116, 15,
    116, 27,
    116, 28,
    116, 97,
    116, 101,
    116, 108,
    116, 111,
    116, 114,
    116, 115,
    116, 116,
    116, 117,
    116, 120,
    116, 128,
    116, 129,
    116, 130,
    116, 133,
    116, 134,
    116, 135,
    116, 136,
    116, 137,
    116, 139,
    116, 140,
    116, 141,
    116, 142,
    116, 143,
    116, 144,
    116, 145,
    116, 146,
    116, 147,
    116, 148,
    116, 149,
    116, 150,
    116, 151,
    116, 152,
    116, 159,
    116, 160,
    117, 97,
    117, 101,
    117, 103,
    117, 108,
    117, 116,
    117, 118,
    117, 120,
    117, 123,
    117, 128,
    117, 133,
    117, 140,
    118, 104,
    118, 111,
    118, 114,
    118, 117,
    118, 129,
    118, 134,
    118, 136,
    118, 143,
    118, 146,
    118, 147,
    118, 148,
    118, 149,
    118, 152,
    123, 115,
    123, 116,
    123, 120,
    123, 123,
    125, 115,
    125, 116,
    125, 120,
    125, 123,
    125, 155,
    126, 97,
    126, 108,
    126, 115,
    126, 116,
    126, 120,
    126, 123,
    126, 128,
    127, 97,
    127, 103,
    127, 108,
    127, 115,
    127, 116,
    127, 118,
    127, 120,
    127, 123,
    127, 128,
    127, 140,
    129, 147,
    129, 148,
    129, 152,
    130, 135,
    130, 147,
    130, 148,
    130, 150,
    130, 152,
    130, 160,
    131, 136,
    131, 147,
    131, 148,
    131, 150,
    131, 152,
    132, 13,
    132, 14,
    132, 15,
    132, 27,
    132, 28,
    132, 133,
    132, 140,
    132, 149,
    132, 160,
    134, 135,
    134, 136,
    134, 140,
    134, 148,
    134, 150,
    134, 152,
    135, 134,
    135, 143,
    135, 146,
    135, 149,
    136, 135,
    136, 147,
    136, 148,
    136, 150,
    136, 152,
    139, 129,
    139, 134,
    139, 143,
    139, 146,
    139, 149,
    143, 135,
    143, 140,
    143, 147,
    143, 148,
    143, 150,
    143, 155,
    145, 14,
    145, 15,
    145, 27,
    145, 28,
    145, 135,
    145, 147,
    145, 148,
    145, 150,
    145, 152,
    146, 129,
    146, 136,
    146, 143,
    146, 147,
    146, 150,
    147, 13,
    147, 15,
    147, 27,
    147, 28,
    147, 129,
    147, 133,
    147, 134,
    147, 136,
    147, 140,
    147, 143,
    147, 146,
    147, 147,
    147, 148,
    147, 152,
    147, 160,
    148, 13,
    148, 14,
    148, 15,
    148, 27,
    148, 28,
    148, 129,
    148, 133,
    148, 134,
    148, 140,
    148, 143,
    148, 146,
    148, 147,
    148, 149,
    148, 152,
    148, 160,
    149, 133,
    149, 135,
    149, 140,
    149, 148,
    149, 150,
    149, 152,
    149, 155,
    149, 160,
    150, 129,
    150, 134,
    150, 136,
    150, 143,
    150, 146,
    150, 149,
    155, 134,
    155, 146,
    155, 147,
    155, 148,
    155, 152,
    155, 155,
    157, 134,
    157, 146,
    157, 147,
    157, 148,
    157, 152,
    157, 155,
    158, 140,
    158, 147,
    158, 148,
    158, 152,
    158, 155,
    158, 160,
    159, 135,
    159, 140,
    159, 147,
    159, 148,
    159, 150,
    159, 152,
    159, 155
};

/* Kerning between the respective left and right glyphs
 * 4.4 format which needs to scaled with `kern_scale`*/
static const int8_t kern_pair_values[] =
{
    5, 7, -7, 1, -9, 7, -7, -6,
    -1, 6, 5, -5, 2, -9, 12, 12,
    -2, 4, 6, 5, 3, 2, -2, -18,
    5, -3, -2, -8, -6, -10, -4, 4,
    -18, -3, 3, -12, -4, 2, -27, -8,
    -24, -12, -7, -15, -3, 3, -7, -6,
    -10, 8, 7, 8, -8, -7, -7, -8,
    -18, -6, -11, -11, -16, -3, -3, 4,
    -3, -2, -2, -2, -5, -5, -6, -2,
    -4, -3, -2, -8, -4, -3, -6, -10,
    -23, 3, -23, -14, -15, -3, -10, -8,
    -7, -9, -10, 2, -1, -5, -5, -8,
    -5, -10, -10, -10, 3, -2, -9, -9,
    -8, -13, 2, -4, -2, -3, -19, -2,
    -17, -15, -22, -13, 3, 3, -7, -1,
    -5, -5, -9, -8, -30, -30, -14, -17,
    -3, -4, -4, -5, -5, -5, -3, -4,
    -6, -5, -6, -6, -3, 2, -3, 2,
    -3, -5, -4, -2, -15, -7, -14, -16,
    -16, -16, -1, -2, -16, 4, 13, 10,
    16, -19, -18, -18, -17, -18, -16, -14,
    -17, -17, -18, -17, -5, 2, 2, 1,
    2, -14, -14, -5, -6, -11, -5, -5,
    -5, 13, -10, -10, -8, -10, -7, -7,
    3, -11, 2, -11, -6, -10, -5, -4,
    -4, -1, 11, -9, -9, -7, -8, -6,
    -7, 2, -4, -9, -9, -9, -9, -9,
    -12, -18, -9, -18, -10, -10, -16, -8,
    -9, -8, -2, 17, -17, -17, -15, -17,
    -10, -12, -3, -3, -4, -2, -2, -3,
    2, 2, -3, -3, -5, -5, -1, -3,
    5, -2, 3, 7, -3, 7, 7, -4,
    5, -4, -2, -2, -2, -3, -2, -2,
    -3, -3, -3, -5, -5, 2, -3, -12,
    4, -12, 5, -2, -2, -2, 3, 7,
    7, 6, 3, 7, 3, 5, 5, 3,
    -2, -1, -11, 6, -10, 1, -5, -4,
    -4, -3, -4, -9, 6, -8, -4, -3,
    -3, -2, -3, -2, -6, -6, -5, -4,
    -9, 7, -9, 2, -4, -4, -4, -2,
    -3, 8, 7, 8, 2, 2, 14, -8,
    -8, -14, -10, -15, -9, 1, 12, -3,
    -3, -7, -6, -5, -10, -3, -1, -5,
    -6, -3, -8, -2, -4, -6, -6, -3,
    -1, -5, 2, -4, -6, 2, 4, 3,
    -4, 7, -26, -16, -25, -6, -8, -14,
    -11, 12, 15, -8, 3, -19, -8, -26,
    -22, 2, -14, -8, -8, -23, -8, -8,
    -21, -8, -6, -22, 4, 2, -24, -2,
    -9, -6, 6, -6, -15, -6, -6, -7,
    -11, 5, -4, -3, 3, -3, -3, -4,
    -10, -5, -15, -2, 7, -6, 5, 1,
    2, -3, -7, -6, -3, 4, 2, -2,
    -3, -4, -10, -10, -15, -2, -8, -9,
    -2, -9, -9, -13, -13, -10, -17, -7,
    -8, -2, -1, -6, -9, -3, 2, -5,
    -30, -30, -14, -13, -9, -3, -2, -2,
    -17, -4, 1, -14, -4, -4, -5, -2,
    -6, 5, 3, -3, -7, -2, 9, 6,
    -15, -7, -14, -6, -8, -14, -11, 5,
    -9, -1, 12, 15, -8, -15, -8, -8,
    -16, -15, 1, -14, -8, -8, -15, -8,
    -8, -15, -8, -7, -15, 4, 2, -17,
    -2, -10, -6, 6, -14, -23, -4, -23,
    -6, -7, -15, -12, -10, -6, -6, 16,
    19, -9, 7, -4, -13, -8, -19, -15,
    2, -9, -8, -8, -16, -8, -8, -15,
    -8, -7, -15, 4, 2, -16, -2, -9,
    -6, -7, -11, -9, -7, -13, -5, -10,
    -14, -3, -4, -6, -7, -4, -5, -9,
    -9, -14, -1, -9, -2, -9, -9, -10,
    -12, -11, -19, -16, -5, -5, -11, -16,
    -5, -5, -11, 1, -7, -3, -1, -6,
    -3, 2, -5, -8, -9, -3, -2, -6,
    -10, -3, 2, -5, -1, 1, -4, -7,
    -4, 2, -5, -6, -3, -1, 3, 4,
    -2, -3, -5, -19, -11, -19, 1, 1,
    -13, -9, -1, 3, -3, 2, -1, -5,
    -5, -3, -2, -2, -2, -4, -2, 4,
    -3, -3, -6, 1, -2, -2, -2, -4,
    -3, -1, 2, -5, -5, 5, 14, 2,
    1, 1, -1, 3, -3, -3, -3, 1,
    4, 1, 7, -3, -8, -8, 4, 4,
    3, -8, 2, 8, -6, 2, 2, 14,
    13, 5, 5, -9, 7, -9, 2, 1,
    -4, -7, -4, -4, -3, -4, 12, -6,
    2, -2, -1, -5, -3, -6, -7, -3,
    3, -3, -2, -6, -3, -5, -6, -7,
    1, 1, -13, -10, -3, -9, 1, 1,
    -13, -10, -3, -9, -1, 2, -5, -2,
    5, -1, -4, -2, 2, -5, -6, -3,
    4
};

/*Collect the kern pair's data in one place*/
static const lv_font_fmt_txt_kern_pair_t kern_pairs =
{
    .glyph_ids = kern_pair_glyph_ids,
    .values = kern_pair_values,
    .pair_cnt = 729,
    .glyph_ids_size = 0
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_pairs,
    .kern_scale = 16,
    .cmap_num = 4,
    .bpp = 4,
    .kern_classes = 0,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif

};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t Franklin_24_rus = {
#else
lv_font_t Franklin_24_rus = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 23,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -2,
    .underline_thickness = 1,
#endif
    //.static_bitmap = 0,
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if FRANKLIN_24_RUS*/
