#include <array>
#include <stdexcept> // For std::overflow_error

template <typename T, size_t Capacity>
class FixedSizeQueue
{
private:
    std::array<T, Capacity> data;
    size_t head = 0;
    size_t tail = 0;
    size_t current_size = 0;

public:
    void push(const T &value)
    {
        if (current_size == Capacity)
        {
            throw std::overflow_error("Queue is full");
        }
        data[tail] = value;
        tail = (tail + 1) % Capacity;
        current_size++;
    }

    T pop()
    {
        if (current_size == 0)
        {
            throw std::underflow_error("Queue is empty");
        }
        T value = data[head];
        head = (head + 1) % Capacity;
        current_size--;
        return value;
    }

    bool empty() const
    {
        return current_size == 0;
    }

    bool full() const
    {
        return current_size == Capacity;
    }

    size_t size() const
    {
        return current_size;
    }

    size_t capacity() const
    {
        return Capacity;
    }
};