#!/usr/bin/python3
import atexit
import shelve
from dataclasses import dataclass, asdict
from typing import Dict
from dacite import from_dict
import hashlib

@dataclass
class Sync:
	test_count: int
	received: int
	damaged: int
	recovered: int
	quality: float

@dataclass
class Test:
	last_sync: int
	count: int
	result: Dict[int, Sync]

# Открываем хранилище
persistent_storage = shelve.open("sync")
test = Test(0, 0, {})
try:
	result = persistent_storage.get("result")
	if result is not None:
		test = from_dict(data_class=Test, data=result)
		print(f"Накоплено результатов {test.count}")
	else:
		print(f"Результатов нет")
except Exception as e:
	print(f"Ошибка чтения результатов: {e}")

# Корректное завершение при остановке
def on_shutdown():
	persistent_storage.close()
atexit.register(on_shutdown)

while True:

	# Запрашиваем seed и определяем по нему sync
	seed = input("Укажи Seed: ")
	if len(seed) < 3:
		break

	salt = "vptMexfYNrQN0Y4fyjqhPNgwSzktq7yE"
	md5_hash_object = hashlib.md5((seed + salt).encode('utf-8'))
	digest = md5_hash_object.digest()

	sync = ((digest[14] << 13) ^ (digest[8] << 8) ^ (digest[4] << 5) ^ digest[13]) & 0xFFFF
	
	# Проверяем качество
	info = test.result.get(sync)
	if info is None:
		print(f"{seed}: плохой")
	else:
		quality = (1.0 - info.quality) * 100
		print(f"{sync:04X}: {info.quality:.3f}, {info.test_count} => {info.received} / {info.damaged}, {info.recovered}")
		if info.quality > 0.01:
			print(f"{seed}: плохой, качество {quality:.1f}%")
		elif info.quality <= 0.001:
			print(f"{seed}: отличный, качество 100%")
		else:
			print(f"{seed}: хороший, качество {quality:.1f}%")
	