#!/usr/bin/python3
import atexit
import shelve
from dataclasses import dataclass, asdict
from typing import Dict
from dacite import from_dict
import hashlib

@dataclass
class Sync:
	test_count: int
	received: int
	damaged: int
	recovered: int
	quality: float

@dataclass
class Test:
	last_sync: int
	count: int
	result: Dict[int, Sync]

# Открываем хранилище
persistent_storage = shelve.open("sync")
test = Test(0, 0, {})
try:
	result = persistent_storage.get("result")
	if result is not None:
		test = from_dict(data_class=Test, data=result)
		print(f"Накоплено результатов {test.count}")
	else:
		print(f"Результатов нет")
except Exception as e:
	print(f"Ошибка чтения результатов: {e}")

# Корректное завершение при остановке
def on_shutdown():
	persistent_storage.close()
atexit.register(on_shutdown)

while True:

	# Запрашиваем seed и определяем по нему sync
	sync = input("Укажи Sync: ")
	try:
		sync = int(sync)
	except:
		break
	
	# Проверяем качество
	info = test.result.get(sync)
	if info is None:
		print(f"{sync:04X}: плохой")
	else:
		quality = (1.0 - info.quality) * 100
		print(f"{sync:04X}: {info.quality:.3f}, {info.test_count} => {info.received} / {info.damaged}, {info.recovered}")
		if info.quality > 0.01:
			print(f"{sync:04X}: плохой, качество {quality:.1f}%")
		elif info.quality <= 0.001:
			print(f"{sync:04X}: отличный, качество 100%")
		else:
			print(f"{sync:04X}: хороший, качество {quality:.1f}%")
	