#!/usr/bin/python3
import logging
import time
import atexit
import shelve
from dataclasses import dataclass, asdict
from typing import Dict
from dacite import from_dict
import json

@dataclass
class Sync:
	test_count: int
	received: int
	damaged: int
	recovered: int
	quality: float

@dataclass
class Test:
	last_sync: int
	count: int
	result: Dict[int, Sync]

# Настраиваем логирование
logging.basicConfig(
	level=logging.DEBUG,
	format="%(asctime)s:%(levelname)s:%(name)s:%(message)s", 
	datefmt="%Y%m%d-%H%M%S"
)
logger = logging.getLogger("test")
logger.info("Start")

# Открываем хранилище
persistent_storage = shelve.open("test")

# Начало тестирования
test = Test(0, 0, {})
try:
	result = persistent_storage.get("result")
	if result is not None:
		test = from_dict(data_class=Test, data=result)
		print(f"Накоплено результатов {test.count}, последний sync {test.last_sync:X}")
	else:
		print(f"Результатов нет")
except Exception as e:
	print(f"Ошибка чтения результатов: {e}")

# Корректное завершение при остановке
def on_shutdown():
	logger.info(f"Выход")
	persistent_storage.close()

atexit.register(on_shutdown)


if test.count > 0:
	sync_storage = shelve.open("sync")
	sync_storage.clear()
	result = dict(sorted(asdict(test).items()))
	sync_storage["result"] = result
	sync_storage.close()
