#!/usr/bin/python3
import logging
import time
import atexit
import shelve
from coral import Coral, find_devices

# Настраиваем логирование
logging.basicConfig(
	level=logging.DEBUG,
	format="%(asctime)s:%(levelname)s:%(name)s:%(message)s", 
	datefmt="%Y%m%d-%H%M%S"
)
logger = logging.getLogger("parse")
logger.info("Start")

# Открываем хранилище
persistent_storage = shelve.open("sync.dat")
best = persistent_storage.get("second_iteration", [])
best = list(set(best))
best.sort()
print(f"Загружено {len(best)} значений")

with open('filtered.txt', 'r') as file:
	filtered = []
	for line in file:
		value = int(line.split(":")[0], 16)
		filtered.append(value)
	print(f"В фильтре {len(filtered)} значений")
	set_filtered = set(filtered)
	best = [item for item in best if item not in set_filtered]
	print(f"Осталось {len(best)} значений")

def bit_distance(x, y):
	diff_bits = x ^ y
	return diff_bits.bit_count()

def delete_near(min_distance: int) -> int:
	min_distance_left = 16
	min_distance_right = 16
	min_index = None

	for index, value in enumerate(best):
		distance_left = 16
		distance_right = 16
		for other in best:
			distance = bit_distance(value, other)
			if other < value and distance < distance_left:
				distance_left = distance
			if other > value and distance < distance_right:
				distance_right = distance
		if distance_left + distance_right < min_distance_left + min_distance_right:
			min_distance_left = distance_left
			min_distance_right = distance_right
			min_index = index

	if min_index is not None and (min_distance_left < min_distance or min_distance_right < min_distance):
		print(f"{best[min_index]:X}: {min_index},{min_distance_left},{min_distance_right}")
		best.pop(min_index)
		return min(min_distance_left, min_distance_right)
	return min_distance

d = 0
while d < 3:
	d = delete_near(3)

persistent_storage["final"] = best
print(f"Осталось {len(best)} значений")
hex_list_best = '[{}]'.format(', '.join(hex(x) for x in best))
print(hex_list_best)
