#!/usr/bin/python3
import logging
import time
import atexit
import shelve
from dataclasses import dataclass, asdict
from typing import Dict
from dacite import from_dict
import json

@dataclass
class Sync:
	test_count: int
	received: int
	damaged: int
	recovered: int
	quality: float

@dataclass
class Test:
	last_sync: int
	count: int
	result: Dict[int, Sync]

# Настраиваем логирование
logging.basicConfig(
	level=logging.DEBUG,
	format="%(asctime)s:%(levelname)s:%(name)s:%(message)s", 
	datefmt="%Y%m%d-%H%M%S"
)
logger = logging.getLogger("test")
logger.info("Start")

# Открываем хранилище
persistent_storage = shelve.open("sync")

# Начало тестирования
test = Test(0, 0, {})
result = persistent_storage.get("result")
if result is not None:
	result = result.get('result')
	result = dict(sorted(result.items()))
	with open('sync.json', 'w') as json_file:
		json.dump(result, json_file, indent=4)
	print(f"Накоплено результатов {test.count}, последний sync {test.last_sync:X}")
else:
	print(f"Результатов нет")

# Корректное завершение при остановке
def on_shutdown():
	logger.info(f"Выход")
	persistent_storage.close()

atexit.register(on_shutdown)
