#!/usr/bin/python3
import logging
import time
import atexit
import shelve
from coral import Coral, find_devices

# Настраиваем логирование
logging.basicConfig(
	level=logging.DEBUG,
	format="%(asctime)s:%(levelname)s:%(name)s:%(message)s", 
	datefmt="%Y%m%d-%H%M%S"
)
logger = logging.getLogger("test")
logger.info("Start")

# Открываем хранилище
persistent_storage = shelve.open("sync.dat")

# Настраиваем Коралл
coral_devices = find_devices()
coral_tx = None
coral_rx = None

for port, device in coral_devices.items():
	if device.get("name") == "Коралл-15":
		coral_tx = Coral(port, None, None)
		logger.info(f"Найден передатчик: {port}")
	if device.get("name") == "Коралл-Б":
		coral_rx = Coral(port, None, None, 420000)
		logger.info(f"Найден приемник: {port}")
if coral_tx is None or coral_rx is None:
	print("Не найдены устройства")
	exit(1)

# Начало тестирования
sync = persistent_storage.get("sync", 0)
if sync > 0:
	print(f"Продолжение с sync {sync:X} ({sync * 100 / 0xFFFF:.1f}%)")
	last_sync = persistent_storage.get("last_sync", 0)
	best = persistent_storage.get("best", [])
	good = persistent_storage.get("good", [])
else:
	last_sync = 0
	best = []
	good = []

def print_result():
	# Вывод результатов
	print(f"\nПоследний sync: {sync:X}")

	hex_list_best = '[{}]'.format(', '.join(hex(x) for x in best))
	print("Лучшие:")
	print(hex_list_best)

	#hex_list_good = '[{}]'.format(', '.join(hex(x) for x in good))
	#print("Хорошие:")
	#print(hex_list_good)

# Корректное завершение при остановке
def on_shutdown():
	logger.info("Выход")
	print_result()
	persistent_storage["sync"] = sync
	persistent_storage["last_sync"] = last_sync
	persistent_storage["best"] = best
	persistent_storage["good"] = good

atexit.register(on_shutdown)

while sync < 0xFFFF:
	sync += 1
	low_bit_count = (sync & 0xFF).bit_count()
	high_bit_count = (sync >> 8).bit_count()
	if low_bit_count < 1 or low_bit_count > 7:
		continue
	if high_bit_count < 1 or high_bit_count > 7:
		continue

	if coral_tx.control.write("Sync", sync) != True:
		print(f"Ошибка установки sync передатчика, sync {sync:X}")
		sync = last_sync
		continue
	if coral_rx.control.write("Sync", sync) != True:
		print(f"Ошибка установки sync приемника, sync {sync:X}")
		sync = last_sync
		continue
	time.sleep(2)

	sent = coral_tx["Пакетов отправлено"]
	received = coral_rx["Пакетов принято"]
	damaged = coral_rx["Пакетов повреждено"]
	recovered = coral_rx["Пакетов восстановлено"]
	
	if sent is None or received is None or damaged is None or recovered is None:
		sync = last_sync
		coral_tx.control.port.flushInput()
		coral_tx.control.port.flushOutput()
		coral_rx.control.port.flushInput()
		coral_rx.control.port.flushOutput()
		continue
	last_sync = sync

	if sent > 100:
		if (sent - received) < 5:
			if (damaged + recovered) < 2:
				best.append(sync)
				good.append(sync)
				print(f"best {sync:X}: {sent} => {received} / {damaged}, {recovered}")
			elif (damaged + recovered) < 10:
				good.append(sync)
				print(f"good {sync:X}: {sent} => {received} / {damaged}, {recovered}")
	else:
		print(f"err {sync:X}: {sent} => {received} / {damaged}, {recovered}")

print_result()
persistent_storage["sync"] = sync
persistent_storage["last_sync"] = last_sync
persistent_storage["best"] = best
persistent_storage["good"] = good
