#!/usr/bin/python3
import logging
import time
import atexit
import shelve
from coral import Coral, find_devices

# Настраиваем логирование
logging.basicConfig(
	level=logging.DEBUG,
	format="%(asctime)s:%(levelname)s:%(name)s:%(message)s", 
	datefmt="%Y%m%d-%H%M%S"
)
logger = logging.getLogger("test")
logger.info("Start")

# Открываем хранилище
persistent_storage = shelve.open("sync.dat")

# Настраиваем Коралл
coral_devices = find_devices()
coral_tx = None
coral_rx = None

for port, device in coral_devices.items():
	if device.get("name") == "Коралл-15":
		coral_tx = Coral(port, None, None)
		logger.info(f"Найден передатчик: {port}")
	if device.get("name") == "Коралл-Б":
		coral_rx = Coral(port, None, None, 420000)
		logger.info(f"Найден приемник: {port}")
if coral_tx is None or coral_rx is None:
	print("Не найдены устройства")
	exit(1)

# Начало тестирования
best = persistent_storage.get("best", [])
best.sort()
print(f"Загружено {len(best)} значений")

second_iteration = persistent_storage.get("second_iteration", [])

def print_result():
	# Вывод результатов
	print(f"\nРезультатов: {len(second_iteration)}")

	hex_list_best = '[{}]'.format(', '.join(hex(x) for x in second_iteration))
	print("Лучшие:")
	print(hex_list_best)

# Корректное завершение при остановке
def on_shutdown():
	logger.info("Выход")
	persistent_storage["second_iteration"] = second_iteration
	print_result()

atexit.register(on_shutdown)

for sync in best:

	if coral_tx.control.write("Sync", sync) != True:
		print(f"Ошибка установки sync передатчика, sync {sync:X}")
		sync = last_sync
		continue
	if coral_rx.control.write("Sync", sync) != True:
		print(f"Ошибка установки sync приемника, sync {sync:X}")
		sync = last_sync
		continue
	time.sleep(2)

	sent = coral_tx["Пакетов отправлено"]
	received = coral_rx["Пакетов принято"]
	damaged = coral_rx["Пакетов повреждено"]
	recovered = coral_rx["Пакетов восстановлено"]
	
	if sent is None or received is None or damaged is None or recovered is None:
		sync = last_sync
		coral_tx.control.port.flushInput()
		coral_tx.control.port.flushOutput()
		coral_rx.control.port.flushInput()
		coral_rx.control.port.flushOutput()
		continue
	last_sync = sync

	if sent > 100:
		if (sent - received) < 5:
			if (damaged + recovered) < 2:
				second_iteration.append(sync)
				print(f"best {sync:X}: {sent} => {received} / {damaged}, {recovered}")
			elif (damaged + recovered) < 10:
				print(f"good {sync:X}: {sent} => {received} / {damaged}, {recovered}")
			else:
				print(f"bad {sync:X}: {sent} => {received} / {damaged}, {recovered}")
		else:	
			print(f"bad {sync:X}: {sent} => {received} / {damaged}, {recovered}")
	else:
		print(f"err {sync:X}: {sent} => {received} / {damaged}, {recovered}")

persistent_storage["second_iteration"] = second_iteration
print_result()
